/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.timeseq;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import kd.wtc.wtbs.business.timeseq.AbstractTimeSeqBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqSupport;
import kd.wtc.wtbs.business.timeseq.TimeSeqVersion;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;

public class TimeSeqAvailableBo<T extends TimeSeqVersion>
extends AbstractTimeSeqBo<T>
implements Serializable {
    private static final long serialVersionUID = 6346038870502506123L;
    private final List<T> versions;
    private final boolean timeSequenced;
    private static final TimeSeqAvailableBo<? extends TimeSeqVersion> EMPTY = new TimeSeqAvailableBo();

    public TimeSeqAvailableBo() {
        this.versions = Collections.emptyList();
        this.timeSequenced = false;
    }

    public TimeSeqAvailableBo(T timeSeqAvailable) {
        this.timeSequenced = timeSeqAvailable.hasTimeSeqInfo();
        this.versions = Collections.singletonList(timeSeqAvailable);
    }

    public TimeSeqAvailableBo(T timeSeqAvailable, boolean timeSequenced) {
        if (timeSequenced) {
            TimeSeqSupport.checkTimeSeq(timeSeqAvailable);
        }
        this.versions = Collections.singletonList(timeSeqAvailable);
        this.timeSequenced = timeSequenced;
    }

    public TimeSeqAvailableBo(Collection<T> timeSeqVersions) {
        Objects.requireNonNull(timeSeqVersions, "timeSeqVersions could not be null");
        this.versions = TimeSeqSupport.sortTimeSeqVersions(timeSeqVersions);
        this.timeSequenced = true;
    }

    @Override
    public List<T> getVersions() {
        return this.versions;
    }

    @Override
    public boolean isTimeSeq() {
        return this.timeSequenced;
    }

    @Override
    public String getNumber() {
        if (this.isEmpty()) {
            return "";
        }
        return WTCCollectionIndexUtil.getEleFromList(this.getVersions(), (int)0).isPresent() ? ((TimeSeqVersion)WTCCollectionIndexUtil.getEleFromList(this.getVersions(), (int)0).get()).getNumber() : "";
    }

    @Deprecated
    public static <T extends TimeSeqVersion> TimeSeqAvailableBo<T> empty() {
        TimeSeqAvailableBo<? extends TimeSeqVersion> empty = EMPTY;
        return empty;
    }

    @Deprecated
    public static <T extends TimeSeqVersion> TimeSeqAvailableBo<T> ofNonTimeSeq(T timeSeqAvailable) {
        return new TimeSeqAvailableBo<T>(timeSeqAvailable, false);
    }

    @Deprecated
    public static <T extends TimeSeqVersion> TimeSeqAvailableBo<T> ofTimeSeq(T timeSeq) {
        return new TimeSeqAvailableBo<T>(timeSeq, true);
    }

    @Deprecated
    public static <T extends TimeSeqVersion> TimeSeqAvailableBo<T> ofMultiTimeSeq(Collection<T> timeSeqClt) {
        return new TimeSeqAvailableBo<T>(timeSeqClt);
    }
}

