/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.timeseq;

import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kd.wtc.wtbs.business.timeseq.TimeSeqSupport;
import kd.wtc.wtbs.business.timeseq.TimeSeqVersion;

public interface TimeSeqBo<T extends TimeSeqVersion> {
    public List<T> getVersions();

    public long getBid();

    public String getNumber();

    public boolean isTimeSeq();

    public T getBoVersion();

    public boolean isEmpty();

    public T getVersionByDate(LocalDate var1);

    public List<T> getVersionsBetweenDate(LocalDate var1, LocalDate var2);

    public static <T extends TimeSeqVersion> TimeSeqBo<T> ofTimeSeq(T timeSeqVersion) {
        Objects.requireNonNull(timeSeqVersion, "timeSeqVersion could not be null");
        return TimeSeqSupport.ofTimeSeq(timeSeqVersion);
    }

    public static <T extends TimeSeqVersion> TimeSeqBo<T> ofNonTimeSeq(T timeSeqAvailable) {
        Objects.requireNonNull(timeSeqAvailable, "timeSeqAvailable could not be null");
        return TimeSeqSupport.ofNonTimeSeq(timeSeqAvailable);
    }

    public static <T extends TimeSeqVersion> TimeSeqBo<T> empty() {
        return TimeSeqSupport.empty();
    }

    public static <T extends TimeSeqVersion> TimeSeqBo<T> ofMultiTimeSeq(Collection<T> timeSeqVersions) {
        Objects.requireNonNull(timeSeqVersions, "timeSeqVersions could not be null");
        return TimeSeqSupport.ofTimeSeqMulti(timeSeqVersions);
    }
}

