/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.timeseq;

import java.io.Serializable;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.Objects;
import kd.wtc.wtbs.business.Entity;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfo;
import kd.wtc.wtbs.common.enums.HisDataStatus;
import kd.wtc.wtbs.common.util.WTCDateUtils;

public class TimeSeqInfoImpl
extends Entity
implements TimeSeqInfo,
Serializable {
    private static final long serialVersionUID = 879452103368324569L;
    private long bid;
    private LocalDate bsed;
    private LocalDate blsed;

    @Deprecated
    public TimeSeqInfoImpl(long vid, long bid, LocalDate bsed, LocalDate blsed) {
        this(vid, bid, String.valueOf(bid), bsed, blsed);
    }

    @Deprecated
    public TimeSeqInfoImpl(long vid, long bid, String number, LocalDate bsed, LocalDate blsed) {
        super(vid, number);
        Objects.requireNonNull(bsed, "bsed could not be null");
        Objects.requireNonNull(blsed, "blsed could not be null");
        if (bsed.isAfter(blsed)) {
            throw new IllegalArgumentException(MessageFormat.format("number:{0},bsed:{1} is larger than blsed:{2}", number, bsed, blsed));
        }
        this.bid = bid;
        this.bsed = bsed;
        this.blsed = blsed;
    }

    @Deprecated
    public TimeSeqInfoImpl(long vid, long bid, boolean bo, LocalDate bsed, LocalDate blsed, HisDataStatus dataStatus) {
        this(vid, bid, bsed, blsed);
    }

    protected TimeSeqInfoImpl(Builder<?, ?> builder) {
        super(builder);
        this.bid = ((Builder)builder).bid;
        this.bsed = ((Builder)builder).bsed;
        this.blsed = ((Builder)builder).blsed;
    }

    @Deprecated
    protected TimeSeqInfoImpl() {
    }

    public static Builder<?, ?> with() {
        return new BuilderImpl();
    }

    @Deprecated
    public static Builder<?, ?> with(long bid) {
        return new BuilderImpl();
    }

    @Override
    public long getBid() {
        return this.bid;
    }

    @Override
    public LocalDate getBsed() {
        return this.bsed;
    }

    @Override
    public LocalDate getBlsed() {
        return this.blsed;
    }

    public boolean isBo() {
        return false;
    }

    public HisDataStatus getHisDataStatus() {
        return HisDataStatus.EFFECTIVE;
    }

    public String toString() {
        return "TimeSeqEntity{bid=" + this.bid + ", bsed=" + this.bsed + ", blsed=" + this.blsed + '}';
    }

    private static final class BuilderImpl
    extends Builder<TimeSeqInfoImpl, BuilderImpl> {
        private BuilderImpl() {
        }

        @Override
        protected BuilderImpl self() {
            return this;
        }

        @Override
        public TimeSeqInfoImpl building() {
            return new TimeSeqInfoImpl(this);
        }
    }

    public static abstract class Builder<E extends TimeSeqInfoImpl, B extends Builder<E, B>>
    extends Entity.Builder<E, B> {
        private long bid;
        private LocalDate bsed;
        private LocalDate blsed;

        public B bid(long bid) {
            this.bid = bid;
            return (B)((Builder)this.self());
        }

        public B vid(long vid) {
            return (B)((Builder)this.id(vid));
        }

        public B bsed(LocalDate bsed) {
            this.bsed = bsed;
            return (B)((Builder)this.self());
        }

        public B blsed(LocalDate blsed) {
            this.blsed = blsed;
            return (B)((Builder)this.self());
        }

        public B bo(boolean bo) {
            return (B)((Builder)this.self());
        }

        public B versionStatus(HisDataStatus versionStatus) {
            return (B)((Builder)this.self());
        }

        public long getBid() {
            return this.bid;
        }

        public LocalDate getBsed() {
            return this.bsed;
        }

        public LocalDate getBlsed() {
            return this.blsed;
        }

        @Override
        protected void check() {
            super.check();
            Objects.requireNonNull(this.bsed, "bsed could not be null");
            Objects.requireNonNull(this.blsed, "blsed could not be null");
            if (this.bsed.isAfter(this.blsed)) {
                throw new IllegalArgumentException(MessageFormat.format("number:{0},bsed:{1} is larger than blsed:{2}", this.getNumber(), WTCDateUtils.format((LocalDate)this.bsed), WTCDateUtils.format((LocalDate)this.blsed)));
            }
        }
    }
}

