/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.timeseq;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.timeseq.AbstractTimeSeqBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfo;
import kd.wtc.wtbs.business.timeseq.TimeSeqVersion;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;

class TimeSeqSupport {
    private static final Log log = LogFactory.getLog(TimeSeqSupport.class);
    private static final TimeSeqBo EMPTY = new EmptyBo();

    public static <T extends TimeSeqVersion> T sliceVersionByDate(List<T> timeSeqVersions, LocalDate inDate) {
        TimeSeqVersion last;
        TimeSeqVersion first = (TimeSeqVersion)timeSeqVersions.get(0);
        if (first == (last = (TimeSeqVersion)timeSeqVersions.get(timeSeqVersions.size() - 1))) {
            if (first.getTimeSeqInfo().isDuring(inDate)) {
                return (T)first;
            }
            return null;
        }
        if (!first.getTimeSeqInfo().getBsed().isAfter(inDate) && last.getTimeSeqInfo().getBlsed().compareTo(inDate) >= 0) {
            for (TimeSeqVersion timSeq : timeSeqVersions) {
                if (timSeq.getTimeSeqInfo().getBlsed().compareTo(inDate) < 0) continue;
                return (T)timSeq;
            }
        }
        return null;
    }

    public static <T extends TimeSeqVersion> List<T> sliceVersionBetweenDate(List<T> timeSeqVersions, LocalDate fromDate, LocalDate toDate) {
        return timeSeqVersions.stream().filter(timeSeqVersion -> timeSeqVersion.getTimeSeqInfo().isDuring(fromDate, toDate)).collect(Collectors.toList());
    }

    public static void checkTimeSeq(TimeSeqVersion timeSeq) {
        if (!timeSeq.hasTimeSeqInfo()) {
            throw new IllegalStateException("illegal time sequenced");
        }
    }

    public static <T extends TimeSeqVersion> List<T> sortTimeSeqVersions(Collection<T> timeSeqVersions) {
        if (timeSeqVersions.isEmpty()) {
            return Collections.emptyList();
        }
        for (TimeSeqVersion timeSeq : timeSeqVersions) {
            TimeSeqSupport.checkTimeSeq(timeSeq);
        }
        if (timeSeqVersions.size() == 1) {
            return Collections.singletonList(timeSeqVersions.iterator().next());
        }
        ArrayList<T> sortedTimeSeqVersions = new ArrayList<T>(timeSeqVersions);
        sortedTimeSeqVersions.sort(Comparator.comparing(timeSeqVersion -> timeSeqVersion.getTimeSeqInfo().getBsed()));
        Iterator iterator = sortedTimeSeqVersions.iterator();
        TimeSeqInfo cur = ((TimeSeqVersion)iterator.next()).getTimeSeqInfo();
        long bid = cur.getBid();
        String number = cur.getNumber();
        while (iterator.hasNext()) {
            TimeSeqInfo next = ((TimeSeqVersion)iterator.next()).getTimeSeqInfo();
            if (bid != next.getBid()) {
                log.error("TimeSeq has error,current bid:{0} is not equals next bid:{1},vid is:{2},{3}", new Object[]{cur.getBid(), next.getBid(), cur.getVid(), next.getVid()});
                throw new IllegalStateException(ResManager.loadKDString((String)"\u6570\u636e\u5bf9\u8c61\u65f6\u5e8f\u5f02\u5e38\uff0c\u201c{0}\u201d\u591a\u4e2a\u7248\u672cID\u4e0d\u4e00\u81f4\u3002", (String)"TimeSeqSupport_0", (String)"wtc-wtbs-business", (Object[])new Object[]{number}));
            }
            if (!cur.getBlsed().plusDays(1L).isEqual(next.getBsed())) {
                log.error("TimeSeq has error,number:{0},current blsed:{1},next bsed:{2},vid is::{3},{4} ", new Object[]{number, cur.getBlsed(), next.getBsed(), cur.getVid(), next.getVid()});
                throw new IllegalStateException(ResManager.loadKDString((String)"\u6570\u636e\u5bf9\u8c61\u65f6\u5e8f\u5f02\u5e38\uff0c\u201c{0}\u201d\u591a\u4e2a\u7248\u672c\u4e4b\u95f4\u65e5\u671f\u5b58\u5728\u4e0d\u8fde\u7eed\uff1a\u201c{1}\u201d\u4e0e\u201c{2}\u201d\u3002", (String)"TimeSeqSupport_2", (String)"wtc-wtbs-business", (Object[])new Object[]{number, cur.getBlsed(), next.getBsed()}));
            }
            cur = next;
        }
        return Collections.unmodifiableList(sortedTimeSeqVersions);
    }

    static <T extends TimeSeqVersion> TimeSeqBo<T> ofTimeSeq(T obj) {
        TimeSeqSupport.checkTimeSeq(obj);
        return new SingleTimeSeqBo<T>(obj);
    }

    static <T extends TimeSeqVersion> TimeSeqBo<T> ofNonTimeSeq(T obj) {
        return new SingleNonTimeSeqBo<T>(obj);
    }

    static <T extends TimeSeqVersion> TimeSeqBo<T> empty() {
        return EMPTY;
    }

    static <T extends TimeSeqVersion> TimeSeqBo<T> ofTimeSeqMulti(Collection<T> timeSeqVersions) {
        if (timeSeqVersions.isEmpty()) {
            return TimeSeqSupport.empty();
        }
        List<T> sortedTimeSeqVersions = TimeSeqSupport.sortTimeSeqVersions(timeSeqVersions);
        return new MultiVersionBo<T>(sortedTimeSeqVersions);
    }

    private TimeSeqSupport() {
    }

    private static class SingleNonTimeSeqBo<T extends TimeSeqVersion>
    extends SingleTimeSeqBo<T> {
        private static final long serialVersionUID = -7917851166109315809L;

        public SingleNonTimeSeqBo(T obj) {
            super(obj);
        }

        @Override
        public T getBoVersion() {
            return (T)this.obj;
        }

        @Override
        public T getVersionByDate(LocalDate inDate) {
            return (T)this.obj;
        }

        @Override
        public boolean isTimeSeq() {
            return false;
        }

        @Override
        public List<T> getVersionsBetweenDate(LocalDate fromDate, LocalDate toDate) {
            return this.getVersions();
        }
    }

    private static class SingleTimeSeqBo<T extends TimeSeqVersion>
    extends AbstractTimeSeqBo<T>
    implements Serializable {
        private static final long serialVersionUID = 2834235825581144668L;
        final T obj;
        transient List<T> singleObjList;

        public SingleTimeSeqBo(T obj) {
            this.obj = obj;
        }

        @Override
        public List<T> getVersions() {
            if (this.singleObjList == null) {
                this.singleObjList = Collections.singletonList(this.obj);
            }
            return this.singleObjList;
        }

        @Override
        public long getBid() {
            return this.obj.getId();
        }

        @Override
        public String getNumber() {
            return this.obj.getNumber();
        }

        @Override
        public boolean isTimeSeq() {
            return true;
        }

        @Override
        public T getBoVersion() {
            return this.getVersion(LocalDate.now());
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public T getVersionByDate(LocalDate inDate) {
            return this.getVersion(inDate);
        }

        private T getVersion(LocalDate inDate) {
            if (this.obj.getTimeSeqInfo().isDuring(inDate)) {
                return this.obj;
            }
            return null;
        }

        @Override
        public List<T> getVersionsBetweenDate(LocalDate fromDate, LocalDate toDate) {
            if (this.obj.getTimeSeqInfo().isDuring(fromDate, toDate)) {
                return this.getVersions();
            }
            return Collections.emptyList();
        }
    }

    private static class MultiVersionBo<T extends TimeSeqVersion>
    extends AbstractTimeSeqBo<T>
    implements Serializable {
        private static final long serialVersionUID = 4566247984490152470L;
        final List<T> timeSeqVersions;
        transient long bid;
        transient String number;

        public MultiVersionBo(List<T> timeSeqVersions) {
            this.timeSeqVersions = timeSeqVersions;
        }

        @Override
        public long getBid() {
            if (this.bid == 0L) {
                this.bid = WTCCollectionIndexUtil.getEleFromList(this.timeSeqVersions, (int)0).isPresent() ? ((TimeSeqVersion)WTCCollectionIndexUtil.getEleFromList(this.timeSeqVersions, (int)0).get()).getBid() : 0L;
            }
            return this.bid;
        }

        @Override
        public String getNumber() {
            if (this.number == null) {
                this.number = WTCCollectionIndexUtil.getEleFromList(this.timeSeqVersions, (int)0).isPresent() ? ((TimeSeqVersion)WTCCollectionIndexUtil.getEleFromList(this.timeSeqVersions, (int)0).get()).getNumber() : "";
            }
            return this.number;
        }

        @Override
        public T getBoVersion() {
            return TimeSeqSupport.sliceVersionByDate(this.timeSeqVersions, LocalDate.now());
        }

        @Override
        public List<T> getVersions() {
            return this.timeSeqVersions;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isTimeSeq() {
            return true;
        }
    }

    private static class EmptyBo<T extends TimeSeqVersion>
    extends AbstractTimeSeqBo<T>
    implements Serializable {
        private static final long serialVersionUID = 4566247984490152471L;

        private EmptyBo() {
        }

        @Override
        public List<T> getVersions() {
            return Collections.emptyList();
        }

        @Override
        public long getBid() {
            return 0L;
        }

        @Override
        public String getNumber() {
            return "";
        }

        @Override
        public T getBoVersion() {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof TimeSeqBo && ((TimeSeqBo)obj).isEmpty();
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public String toString() {
            return super.toString();
        }

        @Override
        public boolean isTimeSeq() {
            return false;
        }

        @Override
        public T getVersionByDate(LocalDate inDate) {
            return null;
        }

        @Override
        public List<T> getVersionsBetweenDate(LocalDate fromDate, LocalDate toDate) {
            return Collections.emptyList();
        }

        private Object readResolve() {
            return EMPTY;
        }
    }
}

