/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.upgrade;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.wtc.wtbs.business.upgrade.OrgBdUpgradeParam;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class OrgUpgradeHelper {
    private static final Log logger = LogFactory.getLog(OrgUpgradeHelper.class);
    private static final ExecutorService ORG_UPGRADE_EXECUTOR_SERVICE = ThreadPools.newExecutorService((String)"OrgBdDataUpgradeService", (int)8);

    public static UpgradeResult getUpgradeResult(String dbKey, List<OrgBdUpgradeParam> list, Function<OrgBdUpgradeParam, UpgradeResult> function) {
        boolean isFail = false;
        UpgradeResult resultFail = null;
        UpgradeResult resultSuccess = null;
        ExecutorCompletionService<UpgradeResult> completionService = new ExecutorCompletionService<UpgradeResult>(ORG_UPGRADE_EXECUTOR_SERVICE);
        ArrayList futureList = Lists.newArrayListWithExpectedSize((int)list.size());
        for (OrgBdUpgradeParam bdUpgradeParam : list) {
            Callable<UpgradeResult> callable = () -> OrgUpgradeHelper.doUpgrade(dbKey, bdUpgradeParam, function);
            Future<UpgradeResult> future = completionService.submit(callable);
            futureList.add(future);
        }
        for (Future future : futureList) {
            UpgradeResult result = null;
            try {
                result = (UpgradeResult)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                logger.error("future get error", (Throwable)e);
            }
            if (result != null) {
                if (result.isSuccess()) {
                    resultSuccess = result;
                    continue;
                }
                isFail = true;
                resultFail = result;
                continue;
            }
            isFail = true;
            resultFail = OrgUpgradeHelper.result(false, "error", "has error,please check log");
        }
        if (isFail) {
            return resultFail;
        }
        return resultSuccess;
    }

    private static UpgradeResult doUpgrade(String dbKey, OrgBdUpgradeParam bdUpgradeParam, Function<OrgBdUpgradeParam, UpgradeResult> function) {
        Map<Long, Long> map = OrgUpgradeHelper.getCreateOrgAndCheck(bdUpgradeParam.getDataOrgMap(), bdUpgradeParam.getTableName(), dbKey);
        if (map.isEmpty()) {
            return OrgUpgradeHelper.result(true, "success", null);
        }
        bdUpgradeParam.setDataOrgMap(map);
        return function.apply(bdUpgradeParam);
    }

    /*
     * Loose catch block
     */
    private static Map<Long, Long> getCreateOrgAndCheck(Map<Long, Long> dataOrgMap, String tableName, String dbKey) {
        DBRoute dbRoute = new DBRoute(dbKey);
        ArrayList strList = new ArrayList(dataOrgMap.size());
        dataOrgMap.keySet().forEach(key -> strList.add("?"));
        String inStr = "(" + String.join((CharSequence)",", strList) + ");";
        String sql = "select fid,fcreateorgid from  " + tableName + " where  fid in " + inStr;
        try (DataSet dataSet = null;){
            try (TXHandle tx = TX.requiresNew();){
                Map resultMap;
                try {
                    dataSet = HRDBUtil.queryDataSet((String)"getCreateOrgAndCheck", (DBRoute)dbRoute, (String)sql, (Object[])dataOrgMap.keySet().toArray());
                }
                catch (Exception ex) {
                    logger.warn("getCreateOrgAndCheck error", (Throwable)ex);
                    Map map = Collections.EMPTY_MAP;
                    if (tx != null) {
                        if (var9_9 != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable) {
                                var9_9.addSuppressed(throwable);
                            }
                        } else {
                            tx.close();
                        }
                    }
                    if (dataSet != null) {
                        dataSet.close();
                    }
                    return map;
                }
                if (dataSet.isEmpty()) {
                    resultMap = Collections.EMPTY_MAP;
                } else {
                    Iterator iterator = dataSet.iterator();
                    resultMap = Maps.newHashMapWithExpectedSize((int)16);
                    while (iterator.hasNext()) {
                        Row row = (Row)iterator.next();
                        Long fid = row.getLong("fid");
                        Long fcreateorgid = row.getLong("fcreateorgid");
                        resultMap.put(fid, fcreateorgid);
                    }
                }
                Map map = resultMap;
                return map;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    private static UpgradeResult result(boolean success, String el, String errorInfo) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(success);
        result.setEl(el);
        if (StringUtils.isNotBlank((CharSequence)errorInfo)) {
            result.setErrorInfo(errorInfo);
        }
        return result;
    }
}

