/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.upgrade;

import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.hr.hbp.common.util.HRDBUtil;

public abstract class WTCUpgradeService
implements IUpgradeService {
    private static final Log LOG = LogFactory.getLog(WTCUpgradeService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        LOG.info("Start WTCUpgradeService, ver: {}, iteration: {}, dbKey: {}, sqlFileName: {}", new Object[]{ver, iteration, dbKey, sqlFileName});
        UpgradeResult result = new UpgradeResult();
        boolean flag = true;
        this.beforeUpgradeAction(ver, iteration, dbKey, sqlFileName);
        try (TXHandle required = TX.required();){
            this.upgradeAction(ver, iteration, dbKey, sqlFileName);
        }
        LOG.info("End Start WTCUpgradeService");
        result.setEl("warning");
        if (flag) {
            result.setLog("WTCUpgradeService Success");
        } else {
            result.setLog("WTCUpgradeService Fail");
        }
        result.setSuccess(flag);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isDeploy(String sqlFileName) {
        try (DataSet dataSet = null;){
            DBRoute dbRoute = new DBRoute("wtc");
            String sql = "select fnumber from  t_wtbs_upgradechecklist where  fnumber = ?;";
            dataSet = HRDBUtil.queryDataSet((String)"WTCUpgradeService", (DBRoute)dbRoute, (String)sql, (Object[])new Object[]{sqlFileName});
            if (dataSet.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            int fid = dataSet.count("fnumber", true);
            boolean bl = fid != 0;
            return bl;
        }
    }

    protected void addDeploy(String sqlFileName) {
        DBRoute dbRoute = new DBRoute("wtc");
        String sql = "INSERT INTO t_wtbs_upgradechecklist(FEXCUTEDATE,FNUMBER) VALUES (?,?);";
        HRDBUtil.execute((DBRoute)dbRoute, (String)sql, (Object[])new Object[]{new Date(), sqlFileName});
    }

    public void beforeUpgradeAction(String ver, String iteration, String dbKey, String sqlFileName) {
    }

    public abstract void upgradeAction(String var1, String var2, String var3, String var4);
}

