/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.upgrade.originalid;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class BillOriginalIdUpgradeService {
    private static Set<String> ENTRY_SET = new HashSet<String>(2);
    private static final Log LOG;
    private static final Integer CUT_LIMIT;

    public void upgrade(String billType) {
        if (!ENTRY_SET.contains(billType)) {
            return;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(billType);
        String parent = "parent";
        if (StringUtils.equals((CharSequence)"wtabm_vaapply", (CharSequence)billType)) {
            parent = "parentid";
        }
        String selectProperties = "id,originalid";
        QFilter qFilter = new QFilter("ischange", "=", (Object)Boolean.FALSE).and(new QFilter(parent, "!=", (Object)"id", true).and(new QFilter("originalid", "is null", null).or(new QFilter("originalid", "=", (Object)0))));
        String orderBy = "id";
        int originalBillCount = serviceHelper.count(billType, qFilter.toArray());
        int batchSize = originalBillCount / CUT_LIMIT;
        if (originalBillCount % CUT_LIMIT > 0) {
            ++batchSize;
        }
        for (int index = 0; index < batchSize; ++index) {
            DynamicObject[] originalBills;
            for (DynamicObject originalBill : originalBills = serviceHelper.query(selectProperties, qFilter.toArray(), orderBy, CUT_LIMIT.intValue())) {
                originalBill.set("originalid", originalBill.get("id"));
            }
            serviceHelper.update(originalBills);
            this.recursionUpgrade(serviceHelper, originalBills);
        }
    }

    private void recursionUpgrade(HRBaseServiceHelper serviceHelper, DynamicObject[] dys) {
        String parent = "parent";
        if (StringUtils.equals((CharSequence)"wtabm_vaapply", (CharSequence)serviceHelper.getEntityName())) {
            parent = "parentid";
        }
        if (dys == null || dys.length <= 0) {
            return;
        }
        HashMap parentDyMap = new HashMap(dys.length);
        Arrays.stream(dys).forEach(dy -> parentDyMap.put(dy.getLong("id"), dy));
        DynamicObject[] changeBills = serviceHelper.query("id,originalid," + parent, new QFilter(parent, "in", parentDyMap.keySet()).and(new QFilter(parent, "!=", (Object)"id", true).and(new QFilter("originalid", "is null", null).or(new QFilter("originalid", "=", (Object)0)))).toArray());
        if (changeBills != null && changeBills.length > 0) {
            for (DynamicObject changeBill : changeBills) {
                long parentId = changeBill.getLong(parent);
                DynamicObject parentDy = (DynamicObject)parentDyMap.get(parentId);
                if (parentDy == null) continue;
                changeBill.set("originalid", parentDy.get("originalid"));
            }
            serviceHelper.update(changeBills);
        }
        this.recursionUpgrade(serviceHelper, changeBills);
    }

    static {
        ENTRY_SET.add("wtam_busitripbill");
        ENTRY_SET.add("wtom_overtimeapplybill");
        ENTRY_SET.add("wtabm_vaapply");
        LOG = LogFactory.getLog(BillOriginalIdUpgradeService.class);
        CUT_LIMIT = 10000;
    }
}

