/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.util;

import com.alibaba.fastjson.JSON;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.model.takecardrule.ShiftDateVo;
import kd.wtc.wtbs.business.web.applybill.ruleengine.PlanRuleEngineHelper;
import kd.wtc.wtbs.business.web.billservice.plan.BillPlanService;
import kd.wtc.wtbs.business.web.evaluation.EvaluationServiceHelper;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtbs.business.web.takecardrule.TakeCardRuleService;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.attfile.AttFileScheduleQueryParam;
import kd.wtc.wtbs.common.model.bill.PlanRuleEngineOutParam;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.model.evaluation.DutyShiftResponse;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.model.evaluation.ShiftDetail;
import kd.wtc.wtbs.common.model.shift.RefDateType;
import kd.wtc.wtbs.common.util.Tuples;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class ApplyUtil {
    private static final Log log = LogFactory.getLog(ApplyUtil.class);
    public static final int DAY_SECOND = 86400;

    private ApplyUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static DutyShiftResponse getShift(List<Long> attFileBoIdList, Date startDate, Date endDate) {
        if (CollectionUtils.isEmpty(attFileBoIdList) || startDate == null || endDate == null) {
            log.info("\u6392\u73ed\u63a5\u53e3\u5165\u53c2 attFileBoIdList = {}\uff0cstartDate= {}\uff0cendDate= {}", new Object[]{JSON.toJSON(attFileBoIdList), startDate, endDate});
            return null;
        }
        Date preDate = HRDateTimeUtils.addDay((Date)startDate, (long)-1L);
        Date nextEndDate = HRDateTimeUtils.addDay((Date)endDate, (long)1L);
        Date otStartDateTime = WTCDateUtils.getDayStart((Date)preDate);
        Date otEndDateTime = WTCDateUtils.getDayEnd((Date)nextEndDate);
        log.info("ApplyUtil.DutyShiftResponse invoke attFileBoIdList = {}\uff0cstartDate= {}\uff0cendDate= {}", new Object[]{JSON.toJSON(attFileBoIdList), otStartDateTime, otEndDateTime});
        return EvaluationServiceHelper.getDutyShiftsByAttFileBoId(attFileBoIdList, otStartDateTime, otEndDateTime);
    }

    @Deprecated
    public static Map<Date, ShiftDateVo> getTackCardRangeMap(List<Tuple<DutyShift, Shift>> dutyShiftRangeList) {
        if (CollectionUtils.isEmpty(dutyShiftRangeList)) {
            return Collections.emptyMap();
        }
        List<ShiftDateVo> shiftDateVoList = ApplyUtil.getShiftDateVos(dutyShiftRangeList);
        HashMap tackCardRangeHashMap = Maps.newHashMapWithExpectedSize((int)shiftDateVoList.size());
        for (ShiftDateVo shiftDateVo : shiftDateVoList) {
            Date rosterDate = shiftDateVo.getBelongDate();
            tackCardRangeHashMap.put(rosterDate, shiftDateVo);
        }
        return tackCardRangeHashMap;
    }

    private static List<ShiftDateVo> getShiftDateVos(List<Tuple<DutyShift, Shift>> dutyShiftRangeList) {
        if (WTCCollections.isEmpty(dutyShiftRangeList)) {
            return Collections.emptyList();
        }
        ArrayList shiftDateVoList = Lists.newArrayListWithExpectedSize((int)dutyShiftRangeList.size());
        dutyShiftRangeList.forEach(dutyShiftRange -> {
            Shift shift = (Shift)dutyShiftRange.item2;
            DutyShift dutyShift = (DutyShift)dutyShiftRange.item1;
            if (shift != null) {
                ShiftDateVo shiftDateVo = new ShiftDateVo();
                shiftDateVo.setAttFileBoId(dutyShift.getAttFileBaseBoId());
                Long takeCardRulesId = shift.getClockRuleId();
                if (takeCardRulesId == null || takeCardRulesId == 0L) {
                    log.warn("ApplyUtil_getTackCardRangeMap ,shift.id = {},shift={}", (Object)shift.getId(), (Object)shift);
                }
                shiftDateVo.setRuleBid(takeCardRulesId);
                if (shift.getOffNonPlan()) {
                    shiftDateVo.setOffNonPlan("true");
                } else {
                    shiftDateVo.setOffNonPlan("false");
                    List shiftDetailList = shift.getShiftDetailList();
                    if (!CollectionUtils.isEmpty((Collection)shiftDetailList)) {
                        ShiftDetail firstShiftDetail = (ShiftDetail)shiftDetailList.get(0);
                        ShiftDetail lastShiftDetail = (ShiftDetail)shiftDetailList.get(shiftDetailList.size() - 1);
                        firstShiftDetail.setCheckDate(dutyShift.getRosterDate());
                        Date absoluteShiftStartDate = firstShiftDetail.getAbsoluteShiftStartDate();
                        shiftDateVo.setWorkStartDate(absoluteShiftStartDate);
                        lastShiftDetail.setCheckDate(dutyShift.getRosterDate());
                        Date absoluteShiftEndDate = lastShiftDetail.getAbsoluteShiftEndDate();
                        shiftDateVo.setWorkEndDate(absoluteShiftEndDate);
                        if (absoluteShiftStartDate == null || absoluteShiftEndDate == null) {
                            log.warn("ApplyUtil.DutyShiftResponse absoluteShiftStartDate or absoluteShiftEndDate is null\u3002id = {}", (Object)shift.getId());
                            String tip = ResManager.loadKDString((String)"\u6392\u73ed\u6570\u636e\u73ed\u6b21\u5b9a\u4e49\u6570\u636e\u95ee\u9898,\u73ed\u6b21\u65e5\u671f\u4e3a\uff1a{0}", (String)"ApplyUtil_2", (String)"wtc-wtbs-business", (Object[])new Object[0]);
                            throw new KDBizException(MessageFormat.format(tip, shift.getName()));
                        }
                    }
                }
                shiftDateVo.setBelongDate(dutyShift.getRosterDate());
                shiftDateVo.setSplitDate(dutyShift.getRosterDate());
                shiftDateVoList.add(shiftDateVo);
            }
        });
        TakeCardRuleService.setTakeCardScope(shiftDateVoList);
        return shiftDateVoList;
    }

    public static Map<Long, Map<Date, ShiftDateVo>> getTackCardRangeMapGroupByAttFileBoId(List<Tuple<DutyShift, Shift>> dutyShiftRangeList) {
        if (CollectionUtils.isEmpty(dutyShiftRangeList)) {
            return Collections.emptyMap();
        }
        List<ShiftDateVo> shiftDateVoList = ApplyUtil.getShiftDateVos(dutyShiftRangeList);
        HashMap<Long, Map<Date, ShiftDateVo>> attFileBoIdAndShiftInfo = new HashMap<Long, Map<Date, ShiftDateVo>>(16);
        for (ShiftDateVo shiftDateVo : shiftDateVoList) {
            long attFileBoId = shiftDateVo.getAttFileBoId();
            Map dateShiftDateVoMap = attFileBoIdAndShiftInfo.computeIfAbsent(attFileBoId, k -> new HashMap(16));
            Date rosterDate = shiftDateVo.getBelongDate();
            rosterDate = rosterDate == null ? WTCDateUtils.getMaxEndDate() : rosterDate;
            dateShiftDateVoMap.put(rosterDate, shiftDateVo);
        }
        return attFileBoIdAndShiftInfo;
    }

    public static boolean timeInRange(Date currTime, Date startTime, Date endTime) {
        return currTime != null && startTime != null && endTime != null && currTime.getTime() >= startTime.getTime() && currTime.getTime() < endTime.getTime();
    }

    public static boolean timeInShiftRange(Date startTime, Date endTime, ShiftDateVo shiftDateVo) {
        return shiftDateVo != null && !HRStringUtils.equals((String)shiftDateVo.getOffNonPlan(), (String)"true") && startTime.getTime() < shiftDateVo.getWorkEndDate().getTime() && endTime.getTime() > shiftDateVo.getWorkStartDate().getTime();
    }

    public static Map<Long, DynamicObject> getLatestTypeAndRuleCalDy(long attFileBoId, UnifyBillEnum unifyBillEnum) {
        List<DynamicObject> attFileScheduleDyList = ApplyUtil.getAttFileScheduleDy(attFileBoId, unifyBillEnum);
        if (CollectionUtils.isEmpty(attFileScheduleDyList)) {
            return Collections.emptyMap();
        }
        List<DynamicObject> planDys = ApplyUtil.getPlanDy(attFileScheduleDyList, unifyBillEnum);
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        attFileQueryParam.setBoId(attFileBoId);
        attFileQueryParam.setBeCurrent(Boolean.TRUE);
        attFileQueryParam.setAttStatus(null);
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setqFilter(new QFilter("id", "=", (Object)attFileBoId));
        List<DynamicObject> attFiles = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        if (CollectionUtils.isEmpty(attFiles)) {
            log.warn("ApplyUtil.getLatestTypeAndRuleCalDy can not find attFileDy , boid :{}", JSON.toJSON((Object)attFileBoId));
            return Collections.emptyMap();
        }
        List<DynamicObject> ruleDys = ApplyUtil.getRuleDy(attFiles.get(0), planDys, unifyBillEnum);
        List<DynamicObject> ruleCalDys = ApplyUtil.getRuleCalDy(ruleDys, unifyBillEnum);
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>(16);
        String type = unifyBillEnum.getUnifyPlanEnum().getRuleEnum().getUnifyRuleCalEntryEnum().getType();
        for (DynamicObject ruleCalDy : ruleCalDys) {
            long typeId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)ruleCalDy, (String)type);
            result.put(typeId, ruleCalDy);
        }
        return result;
    }

    private static List<DynamicObject> getRuleCalDy(List<DynamicObject> ruleDyList, UnifyBillEnum unifyBillEnum) {
        String calEntry = unifyBillEnum.getUnifyPlanEnum().getRuleEnum().getCalEntry();
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        for (DynamicObject ruleDy : ruleDyList) {
            result.addAll((Collection<DynamicObject>)ruleDy.getDynamicObjectCollection(calEntry));
        }
        return result;
    }

    private static List<DynamicObject> getRuleDy(DynamicObject attFileBoDy, List<DynamicObject> planDyList, UnifyBillEnum unifyBillEnum) {
        Set<Long> ruleBoIds = planDyList.stream().map(dy -> HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dy, (String)unifyBillEnum.getUnifyPlanEnum().getFieldRuleInPlan())).collect(Collectors.toSet());
        BillPlanService planService = new BillPlanService();
        HashMap<Long, List<DynamicObject>> attFileBoIdAndPlanDyMap = new HashMap<Long, List<DynamicObject>>(1);
        HashMap<Long, List<DynamicObject>> attFileBoIdAndDy = new HashMap<Long, List<DynamicObject>>(1);
        HashMap<Long, List<LocalDate>> attFileBoIdAndQueryEngineDate = new HashMap<Long, List<LocalDate>>(1);
        attFileBoIdAndPlanDyMap.put(attFileBoDy.getLong("boid"), planDyList);
        attFileBoIdAndDy.put(attFileBoDy.getLong("boid"), Lists.newArrayList((Object[])new DynamicObject[]{attFileBoDy}));
        attFileBoIdAndQueryEngineDate.put(attFileBoDy.getLong("boid"), Lists.newArrayList((Object[])new LocalDate[]{LocalDate.now()}));
        List<PlanRuleEngineOutParam> ruleDyInEngine = planService.getRuleDyInEngine(attFileBoIdAndPlanDyMap, attFileBoIdAndDy, attFileBoIdAndQueryEngineDate, unifyBillEnum.getPlanSceneEnum());
        ArrayList engineRuleDyList = new ArrayList(10);
        ruleDyInEngine.forEach(re -> {
            if (re.getRule() != null) {
                engineRuleDyList.add(re.getRule());
            }
        });
        if (!CollectionUtils.isEmpty(engineRuleDyList)) {
            engineRuleDyList.forEach(el -> ruleBoIds.add(el.getLong("boid")));
        }
        Map<Long, List<DynamicObject>> andSortByBoId = ApplyUtil.getAndSortByBoId(ruleBoIds, unifyBillEnum.getUnifyPlanEnum().getRuleEnum().getEntityNumber());
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        Set policyByPlanIds = PlanRuleEngineHelper.getPolicyByPlanIds(planDyList.stream().map(pd -> pd.getLong("id")).collect(Collectors.toList())).stream().map(dynamicObject -> dynamicObject.getLong("planid")).collect(Collectors.toSet());
        for (DynamicObject planDy : planDyList) {
            List<DynamicObject> ruleDys;
            Long ruleBoId = 0L;
            if (!policyByPlanIds.contains(planDy.getLong("id"))) {
                ruleBoId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)planDy, (String)unifyBillEnum.getUnifyPlanEnum().getFieldRuleInPlan());
            } else {
                for (PlanRuleEngineOutParam planRuleEngineOutParam : ruleDyInEngine) {
                    DynamicObject rule;
                    if (planRuleEngineOutParam == null || planDy.getLong("id") != planRuleEngineOutParam.getPlan().getLong("id") || (rule = planRuleEngineOutParam.getRule()) == null) continue;
                    ruleBoId = rule.getLong("boid");
                    break;
                }
            }
            if (CollectionUtils.isEmpty(ruleDys = andSortByBoId.get(ruleBoId))) continue;
            result.addAll(ruleDys);
        }
        return result;
    }

    private static List<DynamicObject> getPlanDy(List<DynamicObject> attFileScheduleDyList, UnifyBillEnum unifyBillEnum) {
        HashSet planBoIds = Sets.newHashSetWithExpectedSize((int)attFileScheduleDyList.size());
        for (DynamicObject filePlanDy : attFileScheduleDyList) {
            Long boIdObj = filePlanDy.getLong(WTCStringUtils.joinStr((String[])new String[]{unifyBillEnum.getAttFileScheduleEnum().getKey(), ".", "id"}));
            planBoIds.add(boIdObj);
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        Map<Long, List<DynamicObject>> andSortByBoId = ApplyUtil.getAndSortByBoId(planBoIds, unifyBillEnum.getUnifyPlanEnum().getEntityNumber());
        for (DynamicObject attFileScheduleDy : attFileScheduleDyList) {
            Long boIdObj = attFileScheduleDy.getLong(WTCStringUtils.joinStr((String[])new String[]{unifyBillEnum.getAttFileScheduleEnum().getKey(), ".", "id"}));
            List<DynamicObject> planDys = andSortByBoId.get(boIdObj);
            if (CollectionUtils.isEmpty(planDys)) continue;
            result.addAll(planDys);
        }
        return result;
    }

    private static Map<Long, List<DynamicObject>> getAndSortByBoId(Set<Long> boIds, String entity) {
        Map<Long, List<DynamicObject>> boIdAndDys = ApplyUtil.getDyGroupByBoId(boIds, entity);
        boIdAndDys.forEach((boId, val) -> ApplyUtil.sortByDy(val));
        return boIdAndDys;
    }

    private static Map<Long, List<DynamicObject>> getDyGroupByBoId(Set<Long> boIds, String entity) {
        HRBaseServiceHelper service = new HRBaseServiceHelper(entity);
        QFilter planEffect = new QFilter("iscurrentversion", "=", (Object)Boolean.FALSE);
        QFilter dataStatus = new QFilter("datastatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"1", "2", "0"}));
        QFilter pkEffect = new QFilter("boid", "in", boIds);
        DynamicObject[] plans = service.loadDynamicObjectArray(new QFilter[]{planEffect, pkEffect, dataStatus});
        HashMap boIdAndDys = Maps.newHashMapWithExpectedSize((int)boIds.size());
        for (DynamicObject plan : plans) {
            Long planBoId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)plan, (String)"boid");
            List planDys = boIdAndDys.computeIfAbsent(planBoId, k -> new ArrayList(10));
            planDys.add(plan);
        }
        return boIdAndDys;
    }

    private static void sortByDy(List<DynamicObject> val) {
        Date minDate;
        try {
            minDate = HRDateTimeUtils.parseDate((String)"1900-01-01", (String)"yyyy-MM-dd");
        }
        catch (Exception e) {
            log.error("ApplyUtil.getPlanDy parse date error", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u9519\u8bef", (String)"ApplyUtil_0", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        Date finalMinDate = minDate;
        val.sort((o1, o2) -> {
            Date date1 = o1.getDate("firstbsed");
            Date date2 = o2.getDate("firstbsed");
            date1 = date1 == null ? finalMinDate : date1;
            date2 = date2 == null ? finalMinDate : date2;
            return date1.compareTo(date2);
        });
    }

    private static List<DynamicObject> getAttFileScheduleDy(long attFileBoId, UnifyBillEnum unifyBillEnum) {
        AttFileScheduleQueryParam queryParam = new AttFileScheduleQueryParam();
        queryParam.setBoId(attFileBoId);
        queryParam.setBusyStatus((Set)Sets.newHashSet((Object[])new String[]{"1"}));
        AttFileScheduleServiceImpl attFileImpl = new AttFileScheduleServiceImpl();
        Map<Long, List<DynamicObject>> attFilePlanDysMap = attFileImpl.queryAttFileSchedule(unifyBillEnum.getAttFileScheduleEnum(), queryParam);
        List<DynamicObject> dynamicObjects = attFilePlanDysMap.get(attFileBoId);
        if (dynamicObjects == null) {
            return Collections.emptyList();
        }
        Date minDate = null;
        try {
            minDate = HRDateTimeUtils.parseDate((String)"1900-01-01", (String)"yyyy-MM-dd");
        }
        catch (Exception e) {
            log.error("ApplyUtil.getAttFileScheduleDy parse date error", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u9519\u8bef", (String)"ApplyUtil_1", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        final Date finalMinDate = minDate;
        dynamicObjects.sort(new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                Date date1 = o1.getDate("startdate");
                Date date2 = o2.getDate("startdate");
                date1 = date1 == null ? finalMinDate : date1;
                date2 = date2 == null ? finalMinDate : date2;
                return date1.compareTo(date2);
            }
        });
        return dynamicObjects;
    }

    public static List<Tuples.Tuple3<String, Date, Date>> getShiftDetailAbsoluteTime(DutyShift dutyShift, Shift shift) {
        if (dutyShift == null || shift == null) {
            log.warn("ApplyUtil_getShiftDetailAbsoluteTime \u6392\u73ed\u6216\u73ed\u6b21\u4e3a\u7a7a");
            return Collections.emptyList();
        }
        List shiftDetailList = shift.getShiftDetailList();
        Date dutyDate = WTCDateUtils.getDayStartTime((Date)dutyShift.getRosterDate());
        ArrayList timeDetail = Lists.newArrayListWithExpectedSize((int)shiftDetailList.size());
        for (ShiftDetail shiftDetail : shiftDetailList) {
            int shiftStartDate = shiftDetail.getShiftStartDate();
            Date startTime = null;
            if (HRStringUtils.equalsIgnoreCase((String)RefDateType.TODAY.code, (String)shiftDetail.getRefStartDay())) {
                startTime = HRDateTimeUtils.addSecond((Date)dutyDate, (long)shiftStartDate);
            } else if (HRStringUtils.equalsIgnoreCase((String)RefDateType.NEXTDAY.code, (String)shiftDetail.getRefStartDay())) {
                startTime = HRDateTimeUtils.addSecond((Date)HRDateTimeUtils.addDay((Date)dutyDate, (long)1L), (long)shiftStartDate);
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u73ed\u6b21\u53c2\u8003\u65e5\u671f\u5339\u914d\u9519\u8bef\u3002", (String)"ApplyUtil_3", (String)"wtc-wtbs-business", (Object[])new Object[0]));
            }
            Date endTime = null;
            int shiftEndDate = shiftDetail.getShiftEndDate();
            if (HRStringUtils.equals((String)RefDateType.TODAY.code, (String)shiftDetail.getRefEndDay())) {
                endTime = HRDateTimeUtils.addSecond((Date)dutyDate, (long)shiftEndDate);
            } else if (HRStringUtils.equals((String)RefDateType.NEXTDAY.code, (String)shiftDetail.getRefEndDay())) {
                endTime = HRDateTimeUtils.addSecond((Date)HRDateTimeUtils.addDay((Date)dutyDate, (long)1L), (long)shiftEndDate);
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u73ed\u6b21\u53c2\u8003\u65e5\u671f\u5339\u914d\u9519\u8bef\u3002", (String)"ApplyUtil_3", (String)"wtc-wtbs-business", (Object[])new Object[0]));
            }
            timeDetail.add(new Tuples.Tuple3((Object)shiftDetail.getOutWorkType(), (Object)startTime, (Object)endTime));
        }
        return timeDetail;
    }
}

