/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.model.worktimebucket.OtTimeBucket;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.util.ArrayUtils;

public class OtApplyUtil {
    private static List<OtTimeBucket> queryOtTime(Date belongDate, Long userId) {
        QFilter[] scFilter;
        Object[] scDy;
        HRBaseServiceHelper workServiceHelper = new HRBaseServiceHelper("wtom_overtimeapplybill");
        QFilter[] sdFilter = OtApplyUtil.getWorkCondition(Collections.singleton(userId), belongDate, "sdentry.otdutydate");
        Object[] sdDy = workServiceHelper.loadDynamicObjectArray(sdFilter);
        DynamicObject[] dynamicObjects = (DynamicObject[])ArrayUtils.addAll((Object[])sdDy, (Object[])(scDy = workServiceHelper.loadDynamicObjectArray(scFilter = OtApplyUtil.getWorkCondition(Collections.singleton(userId), belongDate, "scentry.dutydate"))));
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return Collections.emptyList();
        }
        ArrayList extraWorkVoList = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObjectCollection pentry = dynamicObject.getDynamicObjectCollection("scentry");
            extraWorkVoList.addAll(OtApplyUtil.setOtTime(belongDate, pentry, true));
            DynamicObjectCollection dentry = dynamicObject.getDynamicObjectCollection("sdentry");
            extraWorkVoList.addAll(OtApplyUtil.setOtTime(belongDate, dentry, false));
        }
        return extraWorkVoList;
    }

    public static Optional<OtTimeBucket> queryMinStartDate(Date belongDate, Long userId) {
        return OtApplyUtil.queryOtTime(belongDate, userId).stream().filter(ob -> ob.getStartTime() != null).min(Comparator.comparing(OtTimeBucket::getStartTime));
    }

    public static Optional<OtTimeBucket> queryMaxStartDate(Date belongDate, Long userId) {
        return OtApplyUtil.queryOtTime(belongDate, userId).stream().filter(ob -> ob.getEndTime() != null).min(Comparator.comparing(OtTimeBucket::getEndTime));
    }

    private static QFilter[] getWorkCondition(Collection<Long> attPersonId, Date belongDate, String belongDateKey) {
        QFilter attPersonIdsFilter = new QFilter("personid", "in", attPersonId);
        QFilter dentryDateFilter = new QFilter(belongDateKey, "=", (Object)belongDate);
        QFilter auditPass = new QFilter("billstatus", "=", (Object)"C");
        return new QFilter[]{attPersonIdsFilter, dentryDateFilter, auditPass};
    }

    private static List<OtTimeBucket> setOtTime(Date belongDate, DynamicObjectCollection entry, boolean isPentry) {
        String dutyDateStr;
        ArrayList extraWorkVoList = Lists.newArrayListWithExpectedSize((int)16);
        String string = dutyDateStr = isPentry ? "otdate" : "otdutydate";
        if (!CollectionUtils.isEmpty((Collection)entry)) {
            List<DynamicObject> susPentry = entry.stream().filter(element -> element.getDate(dutyDateStr) != null && element.getDate(dutyDateStr).compareTo(belongDate) == 0).collect(Collectors.toList());
            susPentry.forEach(element -> {
                OtTimeBucket extraWorkVo = new OtTimeBucket();
                extraWorkVo.setStartTime(WTCDateUtils.toLocalDateTime((Date)element.getDate(isPentry ? "otdstarttime" : "otstartdate")));
                extraWorkVo.setEndTime(WTCDateUtils.toLocalDateTime((Date)element.getDate(isPentry ? "otdendtime" : "otenddate")));
                extraWorkVoList.add(extraWorkVo);
            });
        }
        return extraWorkVoList;
    }
}

