/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.util;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class QTAccountModeHelper {
    public static final String ACCOUNT_MODE = "accountmode";
    public static final String ACCOUNT_MODE_DEDUCT = "B";
    public static final String ACCOUNT_MODE_FULL = "C";

    @Deprecated
    public static boolean isGenChain(String accountMode) {
        return false;
    }

    public static boolean isFullChain(String accountMode) {
        return ACCOUNT_MODE_FULL.equals(accountMode);
    }

    public static boolean isDeductChain(String accountMode) {
        return ACCOUNT_MODE_DEDUCT.equals(accountMode);
    }

    public static DynamicObject queryDyn(long taskId) {
        DynamicObject dyn = QTAccountModeHelper.getFullChainDao().loadDynamicObject(new QFilter("id", "=", (Object)taskId));
        if (dyn != null) {
            return dyn;
        }
        return QTAccountModeHelper.getDeductChainDao().loadDynamicObject(new QFilter("id", "=", (Object)taskId));
    }

    public static String judgeAccountModeByVersion(String version, long taskId) {
        if (QTAccountModeHelper.getFullChainDao().isExists(new QFilter("version", "=", (Object)version).and("id", "=", (Object)taskId))) {
            return ACCOUNT_MODE_FULL;
        }
        if (QTAccountModeHelper.getDeductChainDao().isExists(new QFilter("version", "=", (Object)version).and("id", "=", (Object)taskId))) {
            return ACCOUNT_MODE_DEDUCT;
        }
        throw new IllegalArgumentException("can not find task by version:" + version + ",task:" + taskId);
    }

    public static String judgeAccountModeByTaskId(long taskId) {
        if (QTAccountModeHelper.getFullChainDao().isExists(new QFilter("id", "=", (Object)taskId))) {
            return ACCOUNT_MODE_FULL;
        }
        if (QTAccountModeHelper.getDeductChainDao().isExists(new QFilter("id", "=", (Object)taskId))) {
            return ACCOUNT_MODE_DEDUCT;
        }
        throw new IllegalArgumentException("can not find task by taskId:" + taskId);
    }

    public static HRBaseServiceHelper getDaoByAccountMode(String accountMode) {
        if (QTAccountModeHelper.isFullChain(accountMode) || QTAccountModeHelper.isGenChain(accountMode)) {
            return QTAccountModeHelper.getFullChainDao();
        }
        if (QTAccountModeHelper.isDeductChain(accountMode)) {
            return QTAccountModeHelper.getDeductChainDao();
        }
        throw new IllegalArgumentException("accountMode:" + accountMode);
    }

    public static HRBaseServiceHelper getDeductChainDao() {
        return new HRBaseServiceHelper("wtte_qtdccalculate");
    }

    public static HRBaseServiceHelper getFullChainDao() {
        return new HRBaseServiceHelper("wtte_qtcalculate");
    }

    public static DynamicObject getEmptyDynByAccountMode(String accountMode) {
        if (QTAccountModeHelper.isFullChain(accountMode) || QTAccountModeHelper.isGenChain(accountMode)) {
            return new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"wtte_qtcalculate"));
        }
        if (QTAccountModeHelper.isDeductChain(accountMode)) {
            return new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"wtte_qtdccalculate"));
        }
        throw new IllegalArgumentException("accountMode:" + accountMode);
    }
}

