/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.util;

import java.util.Date;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.model.evaluation.ShiftDetail;
import kd.wtc.wtbs.common.model.evaluation.ShiftMiddleRule;
import kd.wtc.wtbs.common.model.shift.RefDateType;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.util.DateUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class ShiftParseUtil {
    public static Date getRosterStartDate(ShiftDetail detail, Date rosterDate) {
        Date date = rosterDate;
        String refStartDay = detail.getRefStartDay();
        if (StringUtils.equals((CharSequence)RefDateType.NEXTDAY.code, (CharSequence)refStartDay)) {
            date = DateUtils.addDays((Date)rosterDate, (int)1);
        }
        int shiftStartDate = detail.getShiftStartDate();
        date = WTCDateUtils.getDate((Date)date, (Integer)shiftStartDate);
        return date;
    }

    public static Date getRosterStartDate(Shift shift, Date rosterDate, Date prevShiftEnd) {
        Date date = rosterDate;
        if (shift == null || shift.getOffNonPlan()) {
            return WTCDateUtils.getLatestDate((Date[])new Date[]{prevShiftEnd, rosterDate});
        }
        String refStartDay = shift.getLastRefStartDay();
        if (StringUtils.equals((CharSequence)RefDateType.NEXTDAY.code, (CharSequence)refStartDay)) {
            date = DateUtils.addDays((Date)rosterDate, (int)1);
        }
        int shiftStartDate = shift.getLastShiftStartDate();
        date = WTCDateUtils.getDate((Date)date, (Integer)shiftStartDate);
        return date;
    }

    public static Date getRosterDetailEndDate(ShiftDetail shiftDetail, Date rosterDate) {
        Date rosterShiftEndDate = WTCDateUtils.getDate((Date)rosterDate, (Integer)shiftDetail.getShiftEndDate());
        if (StringUtils.equals((CharSequence)shiftDetail.getRefEndDay(), (CharSequence)RefDateType.NEXTDAY.code)) {
            rosterShiftEndDate = DateUtils.addDays((Date)rosterShiftEndDate, (int)1);
        }
        return rosterShiftEndDate;
    }

    public static Date getRosterEndDate(Shift shift, Date rosterDate) {
        if (shift == null) {
            return WTCDateUtils.addDays((Date)rosterDate, (int)1);
        }
        if (shift.getOffNonPlan()) {
            return rosterDate;
        }
        Date rosterShiftEndDate = WTCDateUtils.getDate((Date)rosterDate, (Integer)shift.getLastShiftEndDate());
        if (StringUtils.equals((CharSequence)shift.getLastRefEndDay(), (CharSequence)RefDateType.NEXTDAY.code)) {
            rosterShiftEndDate = DateUtils.addDays((Date)rosterShiftEndDate, (int)1);
        }
        return rosterShiftEndDate;
    }

    public static Date getRosterEndDate(Shift shift, Date rosterDate, boolean expandOffNonPlan) {
        if (shift == null) {
            return WTCDateUtils.addDays((Date)rosterDate, (int)1);
        }
        if (expandOffNonPlan && shift.getOffNonPlan()) {
            return WTCDateUtils.addDays((Date)rosterDate, (int)1);
        }
        return ShiftParseUtil.getRosterEndDate(shift, rosterDate);
    }

    public static Date getMiddleDate(Shift shift, Date rosterDate) {
        Date middleDate = rosterDate;
        if (shift == null) {
            return middleDate;
        }
        if (shift.getOffNonPlan()) {
            return middleDate;
        }
        ShiftMiddleRule shiftMiddleRule = shift.getShiftMiddleRule();
        int middlepoint = shiftMiddleRule.getMiddlepoint();
        middleDate = WTCDateUtils.getDate((Date)rosterDate, (Integer)middlepoint);
        RefDateType middleRefDate = shiftMiddleRule.getMiddleRefDate();
        if (RefDateType.NEXTDAY == middleRefDate) {
            middleDate = WTCDateUtils.addDays((Date)middleDate, (int)1);
        }
        return middleDate;
    }

    public static Date getMiddleDateEnd(Shift shift, Date rosterDate) {
        Date middleDate = WTCDateUtils.addDays((Date)rosterDate, (int)1);
        if (shift == null) {
            return middleDate;
        }
        if (shift.getOffNonPlan()) {
            return middleDate;
        }
        ShiftMiddleRule shiftMiddleRule = shift.getShiftMiddleRule();
        int middlepoint = shiftMiddleRule.getMiddlepoint();
        middleDate = WTCDateUtils.getDate((Date)rosterDate, (Integer)middlepoint);
        RefDateType middleRefDate = shiftMiddleRule.getMiddleRefDate();
        if (RefDateType.NEXTDAY == middleRefDate) {
            middleDate = WTCDateUtils.addDays((Date)middleDate, (int)1);
        }
        return middleDate;
    }
}

