/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.util;

import com.kingdee.bos.qing.util.AesCryptTools;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.PriorityQueue;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.report.TieReportSaveRequest;
import kd.wtc.wtbs.business.report.calreport.Label;
import kd.wtc.wtbs.business.report.calreport.ReportNode;
import kd.wtc.wtbs.business.report.service.CalculateReportLabelServiceImpl;
import kd.wtc.wtbs.common.MultiLangEnumBridge;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.wtes.common.calreport.CalcReportConstants;

public class TieCalReportUtil {
    private static final Log logger = LogFactory.getLog(TieCalReportUtil.class);
    private static final String[] COLOR_ARR = new String[]{"#DC143C", "#FF8000", "#FFD52E"};

    public static Label newLabel(String key, Object value) {
        return TieCalReportUtil.newLabel(key, value, null);
    }

    public static Label newLabel(String key, Object value, String color) {
        return new Label(key, value, color);
    }

    public static ReportNode newReportNode(String group) {
        return new ReportNode(group);
    }

    public static ReportNode startReportNode(String group) {
        ReportNode reportNode = new ReportNode(group);
        reportNode.setStartTime(System.currentTimeMillis());
        reportNode.appendLabel(TieCalReportUtil.newLabel(CalcReportConstants.START_TIME, new SimpleDateFormat("HH:mm:ss").format(reportNode.getStartTime())));
        return reportNode;
    }

    public static ReportNode startReportNode(ReportNode parentNode, String group) {
        ReportNode reportNode = new ReportNode(group);
        reportNode.setStartTime(System.currentTimeMillis());
        reportNode.appendLabel(TieCalReportUtil.newLabel(CalcReportConstants.START_TIME, new SimpleDateFormat("HH:mm:ss").format(reportNode.getStartTime())));
        parentNode.appendChildren(reportNode);
        return reportNode;
    }

    public static ReportNode startReportNode(ReportNode parentNode, MultiLangEnumBridge kdStr) {
        return TieCalReportUtil.startReportNode(parentNode, kdStr.loadKDString());
    }

    public static Long saveLabel(String labelText) {
        CalculateReportLabelServiceImpl labelService = new CalculateReportLabelServiceImpl();
        return labelService.saveLabel(labelText);
    }

    public static String queryLabel(Long fid) {
        CalculateReportLabelServiceImpl labelService = new CalculateReportLabelServiceImpl();
        return labelService.queryLabelOne(fid);
    }

    public static Long saveCalculateReport(TieReportSaveRequest reportSaveRequest) {
        CalculateReportLabelServiceImpl reportService = new CalculateReportLabelServiceImpl();
        return reportService.saveCalculateReport(reportSaveRequest);
    }

    public static String encrypt(String json) {
        try {
            return AesCryptTools.encrypt((String)json, (String)"f3ae0e44f14bcac62fd5f89d7b086633");
        }
        catch (Exception e) {
            logger.error("CalculateReportLabelUtil_encrypt ", (Throwable)e);
            return null;
        }
    }

    public static String decrypt(String enJson) {
        try {
            return AesCryptTools.decrypt((String)enJson, (String)"f3ae0e44f14bcac62fd5f89d7b086633");
        }
        catch (Exception e) {
            logger.error("CalculateReportLabelUtil_decrypt ", (Throwable)e);
            return null;
        }
    }

    public static Label generalElapsedLabel(long elapsedMilliSec) {
        if (elapsedMilliSec >= 1000L) {
            return new Label(CalcReportConstants.ELAPSED, WTCDateUtils.secondToTime((long)(elapsedMilliSec / 1000L), (String)"h : m : s"), null);
        }
        return TieCalReportUtil.newLabel(CalcReportConstants.ELAPSED_MILLISECOND, elapsedMilliSec, null);
    }

    public static void markElapsedTop(ReportNode reportNode, int topNum) {
        ReportNode poll;
        if (topNum <= 0) {
            return;
        }
        List<ReportNode> children = reportNode.getChildren();
        if (children.isEmpty()) {
            return;
        }
        PriorityQueue<ReportNode> queue = new PriorityQueue<ReportNode>((o1, o2) -> (int)(o1.getElapsedMilliSecond() - o2.getElapsedMilliSecond()));
        for (ReportNode child : children) {
            Long elapsedMilliSecond = child.getElapsedMilliSecond();
            if (null == elapsedMilliSecond) continue;
            if (queue.size() < topNum) {
                queue.offer(child);
            } else {
                ReportNode peek = (ReportNode)queue.peek();
                if (null != peek && peek.getElapsedMilliSecond() < elapsedMilliSecond) {
                    queue.remove();
                    queue.offer(child);
                }
            }
            TieCalReportUtil.markElapsedTop(child, topNum);
        }
        int size = queue.size();
        if (size > COLOR_ARR.length) {
            size = COLOR_ARR.length;
        }
        for (int i = size - 1; i >= 0 && (poll = (ReportNode)queue.poll()) != null; --i) {
            poll.setColor(COLOR_ARR[i]);
        }
    }
}

