/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.util;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.common.enums.HisDataStatus;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;

public class TimeSeqEntityGenerateUtils {
    private static List<String> usableDataStatusList = Collections.unmodifiableList(Arrays.asList(HisDataStatus.EXPIRATION.code, HisDataStatus.EFFECTIVE.code, HisDataStatus.SCHEDULE_EFFECTIVE.code));

    public static DynamicObject[] getHisDyArr(String number, Set<Long> planIdSet, LocalDate startDate, LocalDate endDate) {
        Set newSet = planIdSet.stream().filter(key -> key != 0L).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(newSet)) {
            return new DynamicObject[0];
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(number);
        QFilter[] qFilters = TimeSeqEntityGenerateUtils.getQueryCondition(planIdSet, startDate, endDate);
        return serviceHelper.loadDynamicObjectArray(qFilters);
    }

    private static QFilter[] getQueryCondition(Collection<Long> fIds, LocalDate startDate, LocalDate endDate) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        QFilter qFilter5 = new QFilter("iscurrentversion", "=", (Object)Boolean.FALSE);
        qFilters.add(qFilter5);
        if (fIds != null) {
            qFilters.add(WTCHisServiceHelper.validQFilterByBoNoStatus(fIds));
        }
        if (startDate == null || endDate == null) {
            return qFilters.toArray(new QFilter[0]);
        }
        QFilter qFilter1 = new QFilter("boid", "in", fIds);
        QFilter qFilter2 = new QFilter("datastatus", "in", usableDataStatusList);
        QFilter qFilter3 = new QFilter("bsed", "<=", (Object)endDate);
        QFilter qFilter4 = new QFilter("bsled", ">=", (Object)startDate);
        qFilters.add(qFilter1);
        qFilters.add(qFilter2);
        qFilters.add(qFilter3);
        qFilters.add(qFilter4);
        qFilters.add(qFilter5);
        return qFilters.toArray(new QFilter[0]);
    }
}

