/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.wtc.wtbs.business.mobilescheme.ISchemeMatchPlugin;
import kd.sdk.wtc.wtbs.business.mobilescheme.SchemeIsFullMatchEvent;
import kd.sdk.wtc.wtbs.business.mobilescheme.SchemeMatchEvent;
import kd.sdk.wtc.wtbs.business.mobilescheme.SchemeMatchExtDto;
import kd.wtc.wtbs.business.daterange.access.AccessDto;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.util.ext.AccessDtoExtBridge;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCMaps;

public class WTCBrmSceneHelper {
    public static final Log LOGGER = LogFactory.getLog(WTCBrmSceneHelper.class);

    public static Map<Long, Long> matchSchemeExt(WTCPluginProxy<ISchemeMatchPlugin> pluginProxy, Map<Long, List<Long>> attFileJudgeResults, String sceneNumber, LinkedHashMap<Long, String> allSchemeCondStrMap) {
        if (!pluginProxy.hasPlugin() || WTCCollections.isEmpty(attFileJudgeResults)) {
            return Collections.EMPTY_MAP;
        }
        HashMap schemeAccessDtoMap = new HashMap(allSchemeCondStrMap.size());
        allSchemeCondStrMap.forEach((schemeId, schemeConditionStr) -> schemeAccessDtoMap.put(schemeId, new AccessDtoExtBridge((AccessDto)SerializationUtils.fromJsonString((String)schemeConditionStr, AccessDto.class))));
        SchemeIsFullMatchEvent chooseFullMatchEvent = new SchemeIsFullMatchEvent();
        pluginProxy.invokeReplace(locationService -> locationService.fullMatch(chooseFullMatchEvent));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("WTCBrmSceneHelper.matchSchemeExt.fullExt:{}", (Object)chooseFullMatchEvent.isFull());
        }
        if (chooseFullMatchEvent.isFull()) {
            List matchExtDto = attFileJudgeResults.keySet().stream().map(attFileId -> new SchemeMatchExtDto(attFileId, schemeAccessDtoMap)).collect(Collectors.toList());
            SchemeMatchEvent matchEvent = new SchemeMatchEvent(matchExtDto, sceneNumber);
            pluginProxy.invokeReplace(locationService -> locationService.matchScheme(matchEvent));
            if (WTCMaps.isEmpty((Map)matchEvent.getResultSchemeIdMap())) {
                return Collections.EMPTY_MAP;
            }
            return matchEvent.getResultSchemeIdMap();
        }
        ArrayList matchExtDto = new ArrayList(attFileJudgeResults.size());
        HashMap judgeResultMap = new HashMap(attFileJudgeResults.size());
        attFileJudgeResults.forEach((attFileId, judgeResult) -> {
            if (judgeResult != null) {
                Map<Long, AccessDtoExtBridge> map = judgeResult.stream().filter(id -> schemeAccessDtoMap.containsKey(id)).collect(Collectors.toMap(id -> id, id -> (AccessDtoExtBridge)schemeAccessDtoMap.get(id)));
                matchExtDto.add(new SchemeMatchExtDto(attFileId, map));
                judgeResultMap.put(attFileId, judgeResult.stream().filter(id -> schemeAccessDtoMap.containsKey(id)).collect(Collectors.toSet()));
            }
        });
        SchemeMatchEvent matchEvent = new SchemeMatchEvent(matchExtDto, sceneNumber);
        pluginProxy.invokeReplace(locationService -> locationService.matchScheme(matchEvent));
        Map extResultMap = matchEvent.getResultSchemeIdMap();
        if (WTCMaps.isEmpty((Map)extResultMap)) {
            return Collections.EMPTY_MAP;
        }
        HashMap<Long, Long> resultMap = new HashMap<Long, Long>(extResultMap.size());
        extResultMap.forEach((attFileId, extSchemeId) -> {
            Set judgeResultIds = (Set)judgeResultMap.get(attFileId);
            if (!judgeResultIds.contains(extSchemeId)) {
                extSchemeId = 0L;
            }
            resultMap.put((Long)attFileId, (Long)extSchemeId);
        });
        return resultMap;
    }
}

