/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class WTCDynamicObjectUtils {
    public static long getBaseDataId(DynamicObject dynamicObject, String baseDataKey) {
        Object obj = dynamicObject.get(baseDataKey);
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof DynamicObject) {
            return ((DynamicObject)obj).getLong("id");
        }
        return 0L;
    }

    public static Map<Long, String> queryIdNameMap(String pageNumber, Collection<Long> baseDataIds) {
        DynamicObjectCollection adminOrgDys = QueryServiceHelper.query((String)pageNumber, (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", baseDataIds)});
        return adminOrgDys.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("name")));
    }

    public static Map<Long, Tuple<String, String>> queryIdNumberMap(String pageNumber, Collection<Long> baseDataIds) {
        DynamicObjectCollection adminOrgDys = QueryServiceHelper.query((String)pageNumber, (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", baseDataIds)});
        return adminOrgDys.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> new Tuple((Object)dy.getString("number"), (Object)dy.getString("name"))));
    }

    public static Map<String, Object> convertDynamicObjectToMap(DynamicObject dataEntity) {
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(dataEntity.getDynamicObjectType());
        binder.setOnlyDbProperty(false);
        binder.setSerializeDefaultValue(true);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        return jser.serializeToMap((Object)dataEntity, null);
    }

    public static DynamicObject getDy(String entityName, Long id) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityName);
        DynamicObject dy = hrBaseServiceHelper.generateEmptyDynamicObject();
        dy.set("id", (Object)id);
        return dy;
    }

    public static boolean metaEntityIsExpand(String entityNumber) {
        String entityId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form);
        if (HRStringUtils.isNotEmpty((String)entityId)) {
            String tableName = "T_META_FORMDESIGN";
            String currentAppGroup = AppGroupUtils.getCurrentAppGroup();
            String grayTableName = !StringUtils.isBlank((CharSequence)currentAppGroup) && !"defaultGroup".equals(currentAppGroup) ? String.format("%s_%s", tableName, currentAppGroup) : tableName;
            String sql = String.format("select 1 from %s where FMasterId = ? ", grayTableName);
            return (Boolean)HRDBUtil.query((DBRoute)DBRoute.meta, (String)sql, (Object[])new Object[]{entityId}, rs -> rs.next() && rs.getInt(1) > 0);
        }
        return false;
    }

    public static Map<String, Object> convertDy2Map(DynamicObject dynamicObject) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)dynamicObject.getDynamicObjectType().getProperties().size());
        for (IDataEntityProperty property : dynamicObject.getDynamicObjectType().getProperties()) {
            Object valueObj = property.getValueFast((Object)dynamicObject);
            if (valueObj instanceof DynamicObject) {
                map.put(property.getName(), ((DynamicObject)valueObj).getPkValue());
                continue;
            }
            if (valueObj instanceof DynamicObjectCollection) {
                if (!(property instanceof MulBasedataProp)) continue;
                DynamicObjectCollection objColl = (DynamicObjectCollection)valueObj;
                map.put(property.getName(), objColl.stream().filter(dy -> dy.containsProperty("fbasedataid")).map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toList()));
                continue;
            }
            map.put(property.getName(), valueObj);
        }
        return map;
    }
}

