/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.util;

import java.util.Collections;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.entity.filter.FilterKeyValue;
import kd.bos.entity.filter.FilterKeyValueCollection;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterContainerFilterValues;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class WTCOrgUtils {
    private static final Log LOG = LogFactory.getLog(WTCOrgUtils.class);
    public static final String ATT_ORG_VIEW_NUMBER = "26";

    public static long getOrgId() {
        return RequestContext.get().getOrgId();
    }

    public static List<Long> getAllPermOrgs(String formId, String appId) {
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)ATT_ORG_VIEW_NUMBER, (String)appId, (String)formId, (String)"47150e89000000ac");
        if (!allPermOrgs.hasAllOrgPerm()) {
            allPermOrgs.getHasPermOrgs().sort(Long::compareTo);
            return allPermOrgs.getHasPermOrgs();
        }
        List allOrgs = OrgUnitServiceHelper.getAllOrg((String)ATT_ORG_VIEW_NUMBER);
        Collections.sort(allOrgs);
        return allOrgs;
    }

    public static long getDefaultOrgIdOfList(ListView listView) {
        long orgId;
        String checkRightAppId = listView.getFormShowParameter().getCheckRightAppId();
        String entityId = listView.getEntityTypeId();
        List<Long> allPermOrgs = WTCOrgUtils.getAllPermOrgs(entityId, checkRightAppId);
        if (allPermOrgs.contains(orgId = WTCOrgUtils.getOrgId())) {
            return orgId;
        }
        return allPermOrgs.isEmpty() ? 0L : allPermOrgs.get(0);
    }

    public static long getDefaultSelectOrgIds(ListView listView, String orgField) {
        String orgFieldId = orgField + "." + "id";
        FilterContainer filterContainer = (FilterContainer)listView.getControl("filtercontainerap");
        FilterContainerFilterValues cachedFilterValues = filterContainer.getCachedFilterValues();
        if (cachedFilterValues != null && cachedFilterValues.getOtherFilterValues() != null) {
            for (FilterKeyValueCollection filterKeyValueCollection : cachedFilterValues.getOtherFilterValues().getFilterValueCollection()) {
                for (FilterKeyValue filterKeyValue : filterKeyValueCollection.getFilterKeyValues()) {
                    if (!"FieldName".equals(filterKeyValue.getKey()) || !orgFieldId.equals(filterKeyValue.getValue().get(0))) continue;
                    for (FilterKeyValue keyValue : filterKeyValueCollection.getFilterKeyValues()) {
                        if (!"Value".equals(keyValue.getKey())) continue;
                        if (keyValue.getValue().size() == 1 && "".equals(keyValue.getValue().get(0))) {
                            return WTCOrgUtils.getDefaultOrgIdOfList(listView);
                        }
                        return keyValue.getValue().stream().map(Object::toString).map(Long::parseLong).sorted().findFirst().orElse(0L);
                    }
                }
            }
        }
        return WTCOrgUtils.getDefaultOrgIdOfList(listView);
    }
}

