/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.auth.WTCDataPermissionServiceImpl;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.util.WtbsBusinessUtils;
import kd.wtc.wtbs.business.web.WTCInvokeServiceHelper;

public class WTCPermUtils {
    private static final Log LOGGER = LogFactory.getLog(WTCPermUtils.class);

    public static List<Long> getPermAdminOrgIds(String appId, String entityId, String permKey, String permItemId, boolean isAdminOrgFilterEnable) {
        if (WtbsBusinessUtils.isSuperUser()) {
            return WTCInvokeServiceHelper.getAllAdminOrgIds(isAdminOrgFilterEnable);
        }
        AuthorizedOrgResult authorizedOrgResult = WTCInvokeServiceHelper.getAuthorizedAdminOrgSet(appId, entityId, permItemId, permKey);
        return authorizedOrgResult.getHasPermOrgs();
    }

    public static QFilter getPermAdminOrgIdsQFilter(String appId, String entityId, String permKey, String permItemId, String adminOrgIdField) {
        if (WtbsBusinessUtils.isSuperUser()) {
            return new QFilter(adminOrgIdField, "<>", (Object)0L);
        }
        AuthorizedOrgResult authorizedOrgResult = WTCInvokeServiceHelper.getAuthorizedAdminOrgSet(appId, entityId, permItemId, permKey);
        List hasPermOrgs = authorizedOrgResult.getHasPermOrgs();
        LOGGER.info("WTCPermUtils.getPermAdminOrgIds authorizedOrgResult.isHasAllOrgPerm: {}, hasPermOrgs.size: {}", (Object)authorizedOrgResult.isHasAllOrgPerm(), (Object)(hasPermOrgs != null ? hasPermOrgs.size() : 0));
        return authorizedOrgResult.isHasAllOrgPerm() ? new QFilter(adminOrgIdField, "<>", (Object)0L) : new QFilter(adminOrgIdField, "in", (Object)authorizedOrgResult.getHasPermOrgs());
    }

    @Deprecated
    public static HasPermOrgResult getAllPermOrgs(String appId, String entityNum, String permItemId) {
        Long userId = RequestContext.get().getCurrUserId();
        return PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entityNum, (String)permItemId);
    }

    @Deprecated
    public static HasPermOrgResult getAllPermOrgs(String appId, String entityNum) {
        return WTCPermUtils.getAllPermOrgs(appId, entityNum, "47150e89000000ac");
    }

    @Deprecated
    public static String getEntityNumber(IFormView view) {
        String entity = view.getEntityId();
        entity = FormMetadataCache.getFormConfig((String)entity).getEntityTypeId();
        return entity;
    }

    @Deprecated
    public static String getAppId(IFormView view) {
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)WTCPermUtils.getEntityNumber(view));
        String appNumber = view.getFormShowParameter().getAppId();
        String appid = null;
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception var5) {
                appid = met.getAppId();
            }
        }
        return appid;
    }

    @Deprecated
    public static QFilter getDataRule(long userId, String appId, String entityNum, String permItemId, Map<String, Object> customParam) {
        return (QFilter)WTCServiceHelper.invokeBizService("hrmp", "hrcs", "IHRCSDataPermissionService", "getDataRule", userId, appId, entityNum, permItemId, customParam);
    }

    public static boolean isViewAuthChanged(IFormView authView, IFormView showView) {
        if (null == authView) {
            return false;
        }
        boolean isChanged = authView.getFormShowParameter().isCancelDataRight();
        if (isChanged) {
            showView.showConfirm(ResManager.loadKDString((String)"\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\u3002\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"WTCPermUtils_0", (String)"wtc-wtbs-business", (Object[])new Object[0]), MessageBoxOptions.OK);
        }
        return isChanged;
    }

    public static boolean noDataPermission(long dataPkId, String entityNumber, String appId, IFormView showView, String permItemId) {
        HRBaseServiceHelper helper;
        DynamicObject data;
        if (dataPkId <= 0L || HRStringUtils.isEmpty((String)entityNumber)) {
            return false;
        }
        if (PermissionServiceHelper.isSuperUser((long)RequestContext.get().getCurrUserId())) {
            return false;
        }
        permItemId = HRStringUtils.isEmpty((String)permItemId) ? "47150e89000000ac" : permItemId;
        QFilter filter = new QFilter("id", "=", (Object)dataPkId);
        QFilter permFilter = WTCDataPermissionServiceImpl.getInstance().getDataRule(RequestContext.get().getCurrUserId(), appId, entityNumber, permItemId, (Map<String, Object>)new HashMap<String, Object>(0));
        if (permFilter != null) {
            filter.and(permFilter);
            LOGGER.info("WTCPermUtils.getNoDataPermissionQFilter:{}", (Object)permFilter.toString());
        }
        if (null == (data = (helper = new HRBaseServiceHelper(entityNumber)).queryOne("id", new QFilter[]{filter}))) {
            if (null != showView) {
                showView.showConfirm(ResManager.loadKDString((String)"\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\u3002\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"WTCPermUtils_0", (String)"wtc-wtbs-business", (Object[])new Object[0]), MessageBoxOptions.OK);
            }
            return true;
        }
        return false;
    }
}

