/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.util;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.FieldEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.wtc.wtbs.common.enums.WTCBaseLocalString;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public abstract class WtbsBusinessUtils {
    private static final Log logger = LogFactory.getLog(WtbsBusinessUtils.class);

    public static String loadKDString(String description, String resourceID, Object ... args) {
        return ResManager.loadKDString((String)description, (String)resourceID, (String)"wtc-wtbs-business", (Object[])args);
    }

    public static String getMainEntityDisplayName(String entityNumber) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        return dataEntityType.getDisplayName().toString();
    }

    public static String getFormCaption(String entityNumber, OperationStatus operationStatus, Supplier<String> targetEntityNameSupplier) {
        if (OperationStatus.VIEW == operationStatus) {
            String mainEntityDisplayName = WtbsBusinessUtils.getMainEntityDisplayName(entityNumber);
            String targetEntityName = targetEntityNameSupplier.get();
            return String.format("%s%s-%s", WTCBaseLocalString.VIEW.getName(), mainEntityDisplayName, targetEntityName);
        }
        if (OperationStatus.EDIT == operationStatus) {
            String mainEntityDisplayName = WtbsBusinessUtils.getMainEntityDisplayName(entityNumber);
            String targetEntityName = targetEntityNameSupplier.get();
            return String.format("%s%s-%s", WTCBaseLocalString.EDIT.getName(), mainEntityDisplayName, targetEntityName);
        }
        if (OperationStatus.ADDNEW == operationStatus) {
            String mainEntityDisplayName = WtbsBusinessUtils.getMainEntityDisplayName(entityNumber);
            return String.format("%s%s", WTCBaseLocalString.ADDNEW.getName(), mainEntityDisplayName);
        }
        return WtbsBusinessUtils.getMainEntityDisplayName(entityNumber);
    }

    public static String getFormCaption(String entityNumber, OperationStatus operationStatus, String targetEntityName) {
        return WtbsBusinessUtils.getFormCaption(entityNumber, operationStatus, () -> targetEntityName);
    }

    public static String getFormCaption(String entityNumber, Supplier<String> targetEntityNameSupplier) {
        String mainEntityDisplayName = WtbsBusinessUtils.getMainEntityDisplayName(entityNumber);
        String targetEntityName = targetEntityNameSupplier.get();
        return String.format("%s-%s", mainEntityDisplayName, targetEntityName);
    }

    public static String getFormCaption(Supplier<String> entityNameSupplier, Supplier<String> targetEntityNameSupplier) {
        String entityName = entityNameSupplier.get();
        String targetEntityName = targetEntityNameSupplier.get();
        return String.format("%s-%s", entityName, targetEntityName);
    }

    public static void setFieldsMustInput(IFormView view, boolean flag, String ... fieldNames) {
        for (String fieldName : fieldNames) {
            ((FieldEdit)view.getControl(fieldName)).setMustInput(flag);
        }
    }

    public static void setFieldsSetNull(IFormView view, String ... fieldNames) {
        for (String fieldName : fieldNames) {
            view.getModel().setValue(fieldName, null);
        }
    }

    public static void setMustInputByTime(String ctrl, IFormView view) {
        HashMap<String, Serializable> prop = new HashMap<String, Serializable>(1);
        prop.put("mi", Boolean.FALSE);
        HashMap<String, String> editor = new HashMap<String, String>(1);
        editor.put("mi", "*");
        prop.put("item", editor);
        view.updateControlMetadata(ctrl, prop);
    }

    public static boolean isSuperUser() {
        long userId = RequestContext.get().getCurrUserId();
        return PermissionServiceHelper.isSuperUser((long)userId);
    }

    public static void openMenu(IFormView view, String entityNumber, String appNumber) {
        WtbsBusinessUtils.openMenu(view, entityNumber, appNumber, null);
    }

    public static void openMenu(IFormView view, String entityNumber, String appNumber, Map<String, Object> customParameters) {
        AppInfo appInfo = AppMetadataCache.getAppInfoByNumber((String)appNumber);
        if (null == appInfo) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u5e94\u7528\u3002", (String)"WtbsBusinessUtils_0", (String)"wtc-wtbs-business", (Object[])new Object[0]));
            return;
        }
        Optional<AppMenuInfo> appMenuInfo = AppMetadataCache.getAppMenusInfoByAppId((String)appNumber).stream().filter(aa -> entityNumber.equals(aa.getEntityNumber()) || entityNumber.equals(aa.getFormId())).findFirst();
        if (!appMenuInfo.isPresent()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u83dc\u5355\u3002", (String)"WtbsBusinessUtils_1", (String)"wtc-wtbs-business", (Object[])new Object[0]));
            return;
        }
        OpenPageUtils.openMenu((IFormView)view, (String)appMenuInfo.get().getId(), (String)appInfo.getId(), customParameters);
    }

    public static long getBaseDataId(DynamicObject dynamicObject, String baseDataKey) {
        Object obj = dynamicObject.get(baseDataKey);
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof DynamicObject) {
            return ((DynamicObject)obj).getLong("id");
        }
        return 0L;
    }

    public static Map<Long, String> queryIdNameMap(String pageNumber, Collection<Long> baseDataIds) {
        DynamicObjectCollection adminOrgDys = QueryServiceHelper.query((String)pageNumber, (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", baseDataIds)});
        return adminOrgDys.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("name")));
    }

    public static Map<Long, Tuple<String, String>> queryIdNumberMap(String pageNumber, Collection<Long> baseDataIds) {
        DynamicObjectCollection adminOrgDys = QueryServiceHelper.query((String)pageNumber, (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", baseDataIds)});
        return adminOrgDys.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> new Tuple((Object)dy.getString("number"), (Object)dy.getString("name"))));
    }

    public static String getAppId(IFormView view) {
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)WtbsBusinessUtils.getEntityNumber(view));
        String appNumber = view.getFormShowParameter().getAppId();
        String appid = null;
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception var5) {
                appid = met.getAppId();
            }
        }
        return appid;
    }

    public static String getEntityNumber(IFormView view) {
        String entity = view.getEntityId();
        entity = FormMetadataCache.getFormConfig((String)entity).getEntityTypeId();
        return entity;
    }

    public static List<String> propertyCopyToDynamicObject(Object object, DynamicObject dynamicObject) {
        Field[] fields;
        ArrayList<String> errorFieldList = new ArrayList<String>();
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            String fieldName = field.getName();
            try {
                if (WtbsBusinessUtils.getFilterSet().contains(fieldName)) continue;
                Method method = object.getClass().getMethod("get" + WtbsBusinessUtils.getMethodName(fieldName), new Class[0]);
                MainEntityType mainEntityType = (MainEntityType)dynamicObject.getDynamicObjectType();
                String property = fieldName == null ? null : fieldName.toLowerCase(Locale.ROOT);
                Map fieldMap = mainEntityType.getAllFields();
                if (fieldMap.get(property) == null) continue;
                dynamicObject.set(property, method.invoke(object, new Object[0]));
            }
            catch (Exception e) {
                errorFieldList.add(fieldName);
            }
        }
        if (!CollectionUtils.isEmpty(errorFieldList)) {
            logger.info("dynamicObject property error{}", (Object)JSON.toJSONString(errorFieldList));
        }
        return errorFieldList;
    }

    private static String getMethodName(String fieldName) {
        char[] carr = fieldName.toCharArray();
        char firstChar = carr[0];
        if (firstChar >= 'a' && firstChar <= 'z') {
            carr[0] = (char)(firstChar - 97 + 65);
        }
        return new String(carr);
    }

    private static Set<String> getFilterSet() {
        HashSet set = Sets.newHashSet();
        set.add("serialVersionUID");
        return set;
    }

    public static List<DynamicObject> getEntryEntityDynamicObjects(IFormView view, String entityName) {
        EntryGrid entryGrid = (EntryGrid)view.getControl(entityName);
        EntryData entryData = entryGrid.getEntryData();
        DynamicObject[] dataEntity = entryData.getDataEntitys();
        return Arrays.asList(dataEntity);
    }

    private static void openApp(IFormView view, Map<String, Object> customParameters, String appNumber) {
        AppInfo appInfo = AppMetadataCache.getAppInfoByNumber((String)appNumber);
        if (null == appInfo) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u5e94\u7528\u3002", (String)"WtbsBusinessUtils_0", (String)"wtc-wtbs-business", (Object[])new Object[0]));
            return;
        }
        OpenPageUtils.openApp((String)appInfo.getNumber(), null, customParameters, (IFormView)view);
    }

    public static void openTargetFormView(IFormView view, FormShowParameter formShowParameter, String appNumber) {
        WtbsBusinessUtils.openApp(view, null, appNumber);
        formShowParameter.setAppId(appNumber);
        view.showForm(formShowParameter);
    }

    public static void openTargetListFormView(IFormView view, ListShowParameter listShowParameter, String appNumber) {
        WtbsBusinessUtils.openApp(view, null, appNumber);
        listShowParameter.setAppId(appNumber);
        view.showForm((FormShowParameter)listShowParameter);
    }

    public static List<QFilter> getQFilters(List<QFilter> qFilters) {
        ArrayList<QFilter> res = new ArrayList<QFilter>(qFilters.size());
        for (QFilter qFilter : qFilters) {
            List qFiltersa = qFilter.getNests(true).stream().map(nest -> nest.getFilter()).collect(Collectors.toList());
            res.addAll(qFiltersa);
        }
        return res;
    }
}

