/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.util.attfilef7;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtbs.business.model.attfile.AttFileF7DateScope;
import kd.wtc.wtbs.business.web.WTCAttFileService;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.attfileauth.AttFileAuth;
import kd.wtc.wtbs.common.model.attfileauth.AttFileInfo;
import kd.wtc.wtbs.common.util.WTCPageCache;

public class AttFileF7Utils {
    private static final Log logger = LogFactory.getLog(AttFileF7Utils.class);
    private static final String MULTI_TYPE = "multiType";
    private static final String WTC_WTP_COMMON = "wtc-wtp-common";

    private AttFileF7Utils() {
    }

    public static void openAttFileAuthCommon(Boolean isMultiSelect, IFormView view, Class<?> aClass, QFilter[] qFilters, Object[] pkIds, String callbackKey, String customPopWindowPageId, String title, AttFileF7DateScope attFileF7DateScope, int percentage) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (pkIds != null && pkIds.length > 0) {
            listShowParameter.setSelectedRows(pkIds);
        }
        AttFileF7Utils.setF7Att(listShowParameter);
        listShowParameter.setCaption(title == null ? ResManager.loadKDString((String)"\u9009\u62e9\u4eba\u5458", (String)"AttFileF7Utils_0", (String)"wtc-wtbs-business", (Object[])new Object[0]) : title);
        listShowParameter.setShowTitle(false);
        listShowParameter.setMultiSelect(isMultiSelect.booleanValue());
        listShowParameter.setCloseCallBack(new CloseCallBack(aClass.getName(), callbackKey));
        listShowParameter.setCustomParam(MULTI_TYPE, (Object)isMultiSelect);
        if (qFilters != null) {
            ListFilterParameter filterList = new ListFilterParameter(Arrays.asList(qFilters), null);
            listShowParameter.setListFilterParameter(filterList);
        }
        if (attFileF7DateScope == null) {
            String dateScope = view.getPageCache().get("dateScope");
            listShowParameter.setCustomParam("dateScope", (Object)dateScope);
        } else {
            listShowParameter.setCustomParam("dateScope", (Object)JSON.toJSONString((Object)attFileF7DateScope));
        }
        listShowParameter.setHasRight(true);
        listShowParameter.setAppId("wtam");
        view.showForm((FormShowParameter)listShowParameter);
    }

    public static void openAttFileAuthCommon(Boolean isMultiSelect, IFormView view, Class<?> aClass, QFilter[] qFilters, Object[] pkIds, String callbackKey, String customPopWindowPageId, String title, AttFileF7DateScope attFileF7DateScope) {
        AttFileF7Utils.openAttFileAuthCommon(isMultiSelect, view, aClass, qFilters, pkIds, callbackKey, customPopWindowPageId, title, attFileF7DateScope, 0);
    }

    public static void dealCallbackSetSelectRows(IDataModel dataModel, Object returnData, String fieldName) {
        if (returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection selectRows = (ListSelectedRowCollection)returnData;
            Object[] selectIdArr = selectRows.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
            dataModel.setValue(fieldName, (Object)selectIdArr);
        }
    }

    private static void setF7Att(ListShowParameter listShowParameter) {
        StyleCss style = new StyleCss();
        style.setWidth("960");
        style.setHeight("580");
        listShowParameter.getOpenStyle().setInlineStyleCss(style);
        listShowParameter.setFormId("wtp_attfileorgtreelistf7");
        listShowParameter.setBillFormId("wtp_attfilebase");
        listShowParameter.setLookUp(true);
    }

    public static Integer getRowIndex(IFormView view) {
        WTCPageCache cache = new WTCPageCache(view);
        return (Integer)cache.get("rowIndex", Integer.class);
    }

    public static List<AttFileAuth> getAttFileAuthList(List<Long> primaryIds) {
        List<AttFileInfo> attFileInfoList;
        if (CollectionUtils.isEmpty(primaryIds)) {
            return Collections.emptyList();
        }
        if (primaryIds.size() > 1000) {
            logger.info("getAttFileAuthList primaryIds size {}", (Object)primaryIds.size());
        }
        if (CollectionUtils.isEmpty(attFileInfoList = WTCAttFileService.queryAttFileInfoByIds(primaryIds))) {
            return Collections.emptyList();
        }
        ArrayList<AttFileAuth> attFileAuthList = new ArrayList<AttFileAuth>(primaryIds.size());
        for (AttFileInfo attFileInfo : attFileInfoList) {
            AttFileAuth attFileAuth = new AttFileAuth();
            attFileAuth.setBoid(attFileInfo.getAttFile().getBoid());
            attFileAuth.setAttFile(attFileInfo.getAttFile());
            attFileAuth.setAttPerson(attFileInfo.getAttPerson());
            attFileAuth.setAssign(attFileInfo.getAssign());
            attFileAuth.setCmpEmp(attFileInfo.getCmpEmp());
            attFileAuth.setComputeCheck(attFileInfo.getComputeCheck());
            attFileAuthList.add(attFileAuth);
        }
        return attFileAuthList;
    }

    public static List<Long> batchQueryAttFileBoidByVid(List<Object> attFileVidList) {
        AttFileQueryServiceImpl instance = AttFileQueryServiceImpl.getInstance();
        List<DynamicObject> dys = instance.queryAttFileByIds("boid", attFileVidList);
        return dys.stream().map(dy -> dy.getLong("boid")).collect(Collectors.toList());
    }
}

