/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.util.duringcycle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.cirenum.AssignTypeEnum;
import kd.wtc.wtbs.business.cirenum.AssignUnitEnum;
import kd.wtc.wtbs.business.cirenum.ChangeDayEnum;
import kd.wtc.wtbs.business.cirenum.ChangeMonthEnum;
import kd.wtc.wtbs.business.cirenum.ChangeTypeEnum;
import kd.wtc.wtbs.business.cirenum.CircleBeginDateTypeEnum;
import kd.wtc.wtbs.business.cirenum.CircleTypeEnum;
import kd.wtc.wtbs.business.cirenum.CircleUnitEnum;
import kd.wtc.wtbs.business.cirenum.WeekLoopDayEnum;
import kd.wtc.wtbs.business.model.CircleConfigVo;
import kd.wtc.wtbs.business.model.CircleRestVo;
import kd.wtc.wtbs.common.constants.CircleConstants;
import kd.wtc.wtbs.common.enums.circle.CycRefDateEnum;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class CircleCalHelper
implements CircleConstants {
    protected static final Log log = LogFactory.getLog(CircleCalHelper.class);

    @Deprecated
    public static List<CircleRestVo> getCircle(DynamicObject cycSet, DynamicObject cycDateSet, Map<Long, Date> attPerInf) {
        return CircleCalHelper.getCircle(cycSet, cycDateSet, attPerInf, attPerInf.get(-1L));
    }

    public static List<CircleRestVo> getCircle(DynamicObject cycSet, DynamicObject cycDateSet, Map<Long, Date> attPerInf, Date calEndDate) {
        CircleConfigVo config = CircleCalHelper.getAndCheckConfig(cycSet, cycDateSet, attPerInf, calEndDate);
        return CircleCalHelper.getCircleByConfig(config);
    }

    public static CircleConfigVo getAndCheckConfig(DynamicObject cycSet, DynamicObject cycDateSet, Map<Long, Date> attPerInf, Date calEndDate) {
        CircleConfigVo config = CircleCalHelper.getConfig(cycSet, cycDateSet);
        if (config == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u671f\u95f4\u5faa\u73af\u914d\u7f6e\u672a\u627e\u5230", (String)"CircleCalHelper_11", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        config.setQtCalCall(true);
        config.setQtCalEndDate(calEndDate);
        CircleCalHelper.setConfigBeginDate(attPerInf, config);
        config.checkParam();
        return config;
    }

    public static List<CircleRestVo> getCircle(Long id, Date startDate, Long attPersonId) {
        CircleConfigVo config = CircleCalHelper.getConfig(CircleCalHelper.getConfigDy(id), null);
        if (config == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u671f\u95f4\u5faa\u73af\u914d\u7f6e\u672a\u627e\u5230", (String)"CircleCalHelper_11", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        config.setCycDateByQuery();
        CircleCalHelper.setConfigBeginDate(startDate, config);
        config.setAttPeronId(attPersonId);
        config.checkParam();
        return CircleCalHelper.getCircleByConfig(config);
    }

    public static List<CircleRestVo> getCircleByConfig(CircleConfigVo config) {
        ArrayList restVos = Lists.newArrayList();
        if (null == config) {
            return restVos;
        }
        if (CircleUnitEnum.CIRCLE_UNIT_PERIOD == config.getCircleUnit()) {
            CircleCalHelper.circlePeriod(config, restVos);
        } else {
            CircleCalHelper.circle(config, restVos);
        }
        return restVos;
    }

    private static void circle(CircleConfigVo config, List<CircleRestVo> restVos) {
        int index = 1;
        int cirIndex = 0;
        Integer interIndex = 0;
        List<Integer> cirValueList = config.getCirValue();
        int cirSize = cirValueList.size();
        Date endDate = CircleCalHelper.setDayMax(config.getEndDate());
        Integer count = config.getCount();
        Calendar seqBegin = Calendar.getInstance();
        Calendar seqEnd = Calendar.getInstance();
        Calendar sqlDate = Calendar.getInstance();
        seqBegin.setTime(config.getBeginDate());
        seqEnd.setTime(config.getBeginDate());
        boolean isStopGenCir = false;
        while (CircleCalHelper.maxCondition(count, index, endDate, seqEnd)) {
            sqlDate.setTime(seqBegin.getTime());
            if (null != endDate && sqlDate.getTimeInMillis() > endDate.getTime()) {
                return;
            }
            CircleCalHelper.getCirDay(config, cirValueList.get(cirIndex), sqlDate);
            seqEnd.setTime(sqlDate.getTime());
            CircleCalHelper.appointDate(config, seqBegin, seqEnd, index);
            if (null != endDate && seqEnd.getTimeInMillis() > endDate.getTime()) {
                seqEnd.setTime(endDate);
            }
            CircleCalHelper.setMax(seqEnd);
            restVos.add(CircleCalHelper.buildRestVo(seqBegin, seqEnd, config, index, cirIndex, interIndex));
            if (config.isQtCalCall() && null != config.getQtCalEndDate()) {
                if (isStopGenCir) {
                    return;
                }
                if (config.getQtCalEndDate().getTime() < seqEnd.getTime().getTime()) {
                    isStopGenCir = true;
                }
            }
            interIndex = CircleCalHelper.intervalCal(interIndex, seqBegin, sqlDate, seqEnd, config);
            cirIndex = cirIndex >= cirSize - 1 ? 0 : ++cirIndex;
            ++index;
            CircleCalHelper.setBeginDate(seqBegin, sqlDate);
        }
    }

    private static void circlePeriod(CircleConfigVo config, List<CircleRestVo> restVos) {
        int cirIndex = 0;
        int index = 1;
        List<Integer> cirValueList = config.getCirValue();
        int cirSize = cirValueList.size();
        Integer interIndex = 0;
        Date endDate = CircleCalHelper.setDayMax(config.getEndDate());
        Integer count = config.getCount();
        Calendar seqBegin = Calendar.getInstance();
        Calendar seqEnd = Calendar.getInstance();
        seqBegin.setTime(config.getBeginDate());
        seqEnd.setTime(config.getBeginDate());
        List<PerAttPeriod> perAttPeriods = config.getPerAttPeriods();
        if (WTCCollections.isEmpty(perAttPeriods)) {
            return;
        }
        int size = perAttPeriods.size();
        Date perAttEndDate = perAttPeriods.get(size - 1).getPerAttEndDate();
        int periodIndex = -1;
        while (CircleCalHelper.maxPeriodCondition(count, index, endDate)) {
            PerAttPeriod perAttPeriod;
            if ((periodIndex += cirValueList.get(cirIndex).intValue()) > size - 1) {
                if (null != endDate && seqBegin.getTime().getTime() > endDate.getTime()) {
                    return;
                }
                seqEnd.setTime(CircleCalHelper.getMinEndDate(perAttEndDate, endDate));
            } else {
                perAttPeriod = perAttPeriods.get(periodIndex);
                seqEnd.setTime(perAttPeriod.getPerAttEndDate());
            }
            if (null != endDate && seqEnd.getTimeInMillis() > endDate.getTime()) {
                seqEnd.setTime(endDate);
            }
            CircleCalHelper.setMax(seqEnd);
            restVos.add(CircleCalHelper.buildRestVo(seqBegin, seqEnd, config, index, cirIndex, interIndex));
            interIndex = CircleCalHelper.intervalCal(interIndex, config);
            if (CollectionUtils.isEmpty(config.getInterval())) {
                periodIndex += interIndex.intValue();
            } else {
                List<Integer> interval = config.getInterval();
                periodIndex += interval.get(interIndex) + 1;
            }
            if (periodIndex > size - 1) {
                return;
            }
            perAttPeriod = perAttPeriods.get(periodIndex);
            seqBegin.setTime(perAttPeriod.getPerAttBeginDate());
            seqEnd.setTime(perAttPeriod.getPerAttEndDate());
            --periodIndex;
            CircleCalHelper.setZero(seqBegin);
            cirIndex = cirIndex >= cirSize - 1 ? 0 : ++cirIndex;
            ++index;
        }
    }

    private static void appointDate(CircleConfigVo config, Calendar seqBegin, Calendar sqlEnd, int index) {
        if (!config.getAppointDate()) {
            return;
        }
        CircleUnitEnum circleUnit = config.getCircleUnit();
        if (CircleUnitEnum.CIRCLE_UNIT_WEEK == circleUnit) {
            CircleCalHelper.appointWeek(config, seqBegin, sqlEnd, index);
        } else if (CircleUnitEnum.CIRCLE_UNIT_MONTH == circleUnit) {
            CircleCalHelper.appointMonth(config, seqBegin, sqlEnd, index);
        } else if (CircleUnitEnum.CIRCLE_UNIT_YEAR == circleUnit) {
            CircleCalHelper.appointYear(config, seqBegin, sqlEnd, index);
        }
    }

    private static void appointYear(CircleConfigVo config, Calendar seqBegin, Calendar sqlEnd, int index) {
        Integer month = config.getMonth();
        Integer date = config.getDate();
        Calendar calendar = Calendar.getInstance();
        if (index == 1) {
            calendar.setTime(sqlEnd.getTime());
            calendar.set(2, month - 1);
            calendar.set(5, date);
            if (sqlEnd.getTimeInMillis() <= calendar.getTimeInMillis()) {
                calendar.add(1, -1);
                sqlEnd.setTime(calendar.getTime());
            } else {
                sqlEnd.setTime(calendar.getTime());
            }
        } else {
            calendar.setTime(sqlEnd.getTime());
            if (12 == month && 31 == date) {
                int endMonth = sqlEnd.get(2) + 1;
                int endMonthDay = sqlEnd.get(5);
                if (month != endMonth || date != endMonthDay) {
                    calendar.add(1, -1);
                }
            }
            calendar.set(2, month - 1);
            calendar.set(5, date);
            sqlEnd.setTime(calendar.getTime());
        }
    }

    private static void appointMonth(CircleConfigVo config, Calendar seqBegin, Calendar sqlEnd, int index) {
        Integer monthDate = config.getMonthDate();
        int endMonthDay = sqlEnd.get(5);
        Calendar calendar = Calendar.getInstance();
        if (index == 1) {
            if (monthDate >= endMonthDay) {
                calendar.setTime(sqlEnd.getTime());
                calendar.add(2, -1);
                calendar.set(5, monthDate);
                sqlEnd.setTime(calendar.getTime());
            } else if (-1 == monthDate) {
                calendar.setTime(sqlEnd.getTime());
                calendar.add(2, -1);
                int actualMaximumDay = calendar.getActualMaximum(5);
                calendar.set(5, actualMaximumDay);
                sqlEnd.setTime(calendar.getTime());
            } else {
                calendar.setTime(sqlEnd.getTime());
                calendar.set(5, monthDate);
                sqlEnd.setTime(calendar.getTime());
            }
        } else {
            if (monthDate == -1) {
                int endMaxDay = sqlEnd.getActualMaximum(5);
                calendar.setTime(sqlEnd.getTime());
                if (endMaxDay != endMonthDay) {
                    calendar.add(2, -1);
                }
                endMaxDay = calendar.getActualMaximum(5);
                calendar.set(5, endMaxDay);
            } else {
                calendar.setTime(sqlEnd.getTime());
                calendar.set(5, monthDate);
            }
            sqlEnd.setTime(calendar.getTime());
        }
    }

    private static void appointWeek(CircleConfigVo config, Calendar seqBegin, Calendar sqlEnd, int index) {
        int endDateWeek;
        Integer weekDate = config.getWeekDate();
        int n = endDateWeek = sqlEnd.getFirstDayOfWeek() == 1 ? sqlEnd.get(7) - 1 : sqlEnd.get(7);
        if (endDateWeek == 0) {
            endDateWeek = 7;
        }
        Calendar calendar = Calendar.getInstance();
        if (index == 1) {
            if (weekDate != endDateWeek) {
                if (weekDate > endDateWeek) {
                    calendar.setTime(sqlEnd.getTime());
                    calendar.add(5, -7);
                    calendar.add(5, weekDate - endDateWeek);
                    sqlEnd.setTime(calendar.getTime());
                } else {
                    calendar.setTime(sqlEnd.getTime());
                    calendar.add(5, -(endDateWeek - weekDate));
                    sqlEnd.setTime(calendar.getTime());
                }
            }
        } else {
            calendar.setTime(sqlEnd.getTime());
            if (endDateWeek > weekDate) {
                calendar.add(5, -(endDateWeek - weekDate));
            } else {
                calendar.add(5, weekDate - endDateWeek);
            }
            sqlEnd.setTime(calendar.getTime());
        }
    }

    private static CircleRestVo buildRestVo(Calendar seqBegin, Calendar seqEnd, CircleConfigVo config, int index, int cirIndex, Integer interIndex) {
        CircleRestVo vo = new CircleRestVo();
        vo.setCycSetId(config.getId());
        vo.setIndex(index);
        vo.setNumber(config.getName());
        vo.setStartDate(seqBegin.getTime());
        vo.setEndDate(seqEnd.getTime());
        CircleCalHelper.setZero(seqEnd);
        vo.setCirDay((seqEnd.getTimeInMillis() - seqBegin.getTimeInMillis()) / 86400000L + 1L);
        vo.setCircleUnit(config.getCircleUnit().getNameCode());
        vo.setCirValue(config.getCirValue().get(cirIndex));
        if (config.getAppointDate()) {
            if (CircleUnitEnum.CIRCLE_UNIT_WEEK == config.getCircleUnit()) {
                vo.setAppointEndDate(WeekLoopDayEnum.getByKey(config.getWeekDate()).getName());
            } else if (CircleUnitEnum.CIRCLE_UNIT_MONTH == config.getCircleUnit()) {
                String monthDate = config.getMonthDate() == -1 ? ResManager.loadKDString((String)"\u6700\u540e\u4e00\u65e5", (String)"CircleCalHelper_0", (String)"wtc-wtbs-business", (Object[])new Object[0]) : config.getMonthDate() + "";
                vo.setAppointEndDate(monthDate);
            } else if (CircleUnitEnum.CIRCLE_UNIT_YEAR == config.getCircleUnit()) {
                vo.setAppointEndDate(config.getYearDate());
            }
        }
        if (CircleTypeEnum.CIRCLE_TYPE_B == config.getCircleType() || CircleTypeEnum.CIRCLE_TYPE_D == config.getCircleType()) {
            if (!CollectionUtils.isEmpty(config.getInterval())) {
                vo.setInterval(config.getInterval().get(interIndex));
            }
            vo.setIntervalUnit(config.getIntervalUnit().getNameCode());
        }
        vo.setAssign(config.getAssign());
        if (config.getAssign()) {
            vo.setAssignType(config.getAssignType().getNameCode());
            vo.setAssignUnit(config.getAssignUnit().getNameCode());
            Calendar calendar = AssignTypeEnum.getDateByType(config.getAssignType(), seqBegin, seqEnd);
            vo.setAssignDate(AssignUnitEnum.getAssignDate(calendar, config.getAssignUnit()));
        }
        return vo;
    }

    private static Integer intervalCal(Integer interIndex, Calendar seqBegin, Calendar sqlDate, Calendar seqEnd, CircleConfigVo config) {
        sqlDate.setTime(seqEnd.getTime());
        sqlDate.add(CircleUnitEnum.CIRCLE_UNIT_DAY.getCircle(), 1);
        if (CollectionUtils.isEmpty(config.getInterval())) {
            return 0;
        }
        List<Integer> interval = config.getInterval();
        sqlDate.add(config.getIntervalUnit().getCircle(), interval.get(interIndex));
        seqBegin.setTime(sqlDate.getTime());
        if (interIndex >= interval.size() - 1) {
            return 0;
        }
        interIndex = interIndex + 1;
        return interIndex;
    }

    private static Integer intervalCal(Integer interIndex, CircleConfigVo config) {
        if (CollectionUtils.isEmpty(config.getInterval())) {
            return 1;
        }
        if (interIndex >= config.getInterval().size() - 1) {
            return 0;
        }
        interIndex = interIndex + 1;
        return interIndex;
    }

    private static boolean maxCondition(Integer count, int index, Date endDate, Calendar seqEnd) {
        if (index > count) {
            return false;
        }
        if (null == endDate) {
            return true;
        }
        return true;
    }

    private static boolean maxPeriodCondition(Integer count, int index, Date endDate) {
        if (index > count) {
            return false;
        }
        if (null == endDate) {
            return true;
        }
        return true;
    }

    public static Date getRefBeginDate(CircleConfigVo circleConfigVo, Date startDate) {
        DynamicObject dy = circleConfigVo.getCycDate();
        ChangeTypeEnum changeType = ChangeTypeEnum.getByNameCode(dy.getString("adjusttype"));
        if (ChangeTypeEnum.CHANGE_TYPE_A == changeType) {
            return ChangeMonthEnum.getChangeDate(ChangeMonthEnum.getByNameCode(dy.getString("adjustmonth")), startDate, dy.getString("distanceequal"), dy.getInt("adjustdate"));
        }
        if (ChangeTypeEnum.CHANGE_TYPE_B == changeType) {
            return ChangeDayEnum.getChangeDate(ChangeDayEnum.getByNameCode(dy.getString("adjustdic")), startDate, dy.getString("adjustunit"), dy.getInt("adjustvalue"));
        }
        if (ChangeTypeEnum.CHANGE_TYPE_C == changeType) {
            return startDate;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u7167\u65e5\u671f\u8c03\u6574\u65b9\u5f0f\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CircleCalHelper_8", (String)"wtc-wtbs-business", (Object[])new Object[0]));
    }

    public static Date getRefBeginDateByAttPer(CircleConfigVo circleConfigVo, Map<Long, Date> attPerInf) {
        Date startDate = CircleCalHelper.getDate(circleConfigVo.getCycDate().getLong("cycrefdate.id"), attPerInf, circleConfigVo);
        return CircleCalHelper.getRefBeginDate(circleConfigVo, startDate);
    }

    private static void setConfigBeginDate(Date startDate, @NotNull CircleConfigVo circleConfigVo) {
        if (CircleBeginDateTypeEnum.BEGIN_DATE_TYPE_A == circleConfigVo.getBeginDateType()) {
            circleConfigVo.setBeginDate(CircleCalHelper.getRefBeginDate(circleConfigVo, startDate));
        } else {
            circleConfigVo.setBeginDate(circleConfigVo.getSelDate());
        }
    }

    private static void setConfigBeginDate(Map<Long, Date> attPerInf, CircleConfigVo circleConfigVo) {
        if (CircleBeginDateTypeEnum.BEGIN_DATE_TYPE_A == circleConfigVo.getBeginDateType()) {
            circleConfigVo.setBeginDate(CircleCalHelper.getRefBeginDateByAttPer(circleConfigVo, attPerInf));
        } else {
            circleConfigVo.setBeginDate(circleConfigVo.getSelDate());
        }
    }

    private static CircleConfigVo getConfig(DynamicObject config, DynamicObject cycDateSet) {
        if (config == null) {
            return null;
        }
        CircleConfigVo circleConfigVo = new CircleConfigVo();
        circleConfigVo.setId(config.getLong("id"));
        circleConfigVo.setName(config.getString("name"));
        circleConfigVo.setBeginDateType(CircleBeginDateTypeEnum.getByNameCode(config.getString("prostartdate")));
        circleConfigVo.setBeginDateId(config.getLong("cycrefdate.id"));
        circleConfigVo.setCycDate(cycDateSet);
        circleConfigVo.setEndDate(config.getDate("proenddate"));
        circleConfigVo.setSelDate(config.getDate("selfdate"));
        circleConfigVo.setCircleType(CircleTypeEnum.getByNameCode(config.getString("cyctype")));
        circleConfigVo.setCircleUnit(CircleUnitEnum.getByNameCode(config.getString("cycunit")));
        List<Integer> cirValues = Arrays.stream(config.getString("cycvalues").split(",")).map(Integer::valueOf).collect(Collectors.toList());
        circleConfigVo.setCirValue(cirValues);
        circleConfigVo.setCirValueStr(config.getString("cycvalues"));
        circleConfigVo.setAppointDate(config.getBoolean("iscyctodata"));
        if (config.getBoolean("iscyctodata")) {
            if (CircleUnitEnum.CIRCLE_UNIT_WEEK == circleConfigVo.getCircleUnit()) {
                circleConfigVo.setWeekDate(config.getInt("cycselec"));
            } else if (CircleUnitEnum.CIRCLE_UNIT_MONTH == circleConfigVo.getCircleUnit()) {
                circleConfigVo.setMonthDate(config.getInt("cycselec"));
            } else if (CircleUnitEnum.CIRCLE_UNIT_YEAR == circleConfigVo.getCircleUnit()) {
                Date date = config.getDate("cycdate");
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                circleConfigVo.setMonth(calendar.get(2) + 1);
                circleConfigVo.setDate(calendar.get(5));
                circleConfigVo.setYearDate(String.format(ResManager.loadKDString((String)"%1$s\u6708%2$s", (String)"CircleCalHelper_9", (String)"wtc-wtbs-business", (Object[])new Object[0]), circleConfigVo.getMonth(), circleConfigVo.getDate()));
            }
        }
        if (CircleTypeEnum.CIRCLE_TYPE_B == circleConfigVo.getCircleType() || CircleTypeEnum.CIRCLE_TYPE_D == circleConfigVo.getCircleType()) {
            if (CircleTypeEnum.CIRCLE_TYPE_B == circleConfigVo.getCircleType()) {
                circleConfigVo.setIntervalUnit(circleConfigVo.getCircleUnit());
            } else {
                circleConfigVo.setIntervalUnit(CircleUnitEnum.getByNameCode(config.getString("unit")));
            }
            List<Integer> interValues = Arrays.stream(config.getString("gapint").split(",")).map(Integer::valueOf).collect(Collectors.toList());
            circleConfigVo.setInterval(interValues);
            circleConfigVo.setIntervalStr(config.getString("gapint"));
        }
        circleConfigVo.setCount(config.getInt("cyccount"));
        circleConfigVo.setAssign(config.getBoolean("ischeckcycass"));
        if (circleConfigVo.getAssign()) {
            circleConfigVo.setAssignType(AssignTypeEnum.getByNameCode(config.getString("attachtype")));
            circleConfigVo.setAssignUnit(AssignUnitEnum.getByNameCode(config.getString("attachunit")));
        }
        return circleConfigVo;
    }

    public static DynamicObject getConfigDy(Long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbd_cycset");
        DynamicObject config = serviceHelper.queryOne((Object)id);
        if (null == config) {
            return null;
        }
        return config;
    }

    private static void setBeginDate(Calendar seqBegin, Calendar sqlDate) {
        seqBegin.setTime(sqlDate.getTime());
        CircleCalHelper.setZero(seqBegin);
    }

    private static void setZero(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    private static void setMax(Calendar calendar) {
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
    }

    private static Date setDayMax(Date date) {
        if (null == date) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        CircleCalHelper.setMax(calendar);
        return calendar.getTime();
    }

    private static Date getDate(Long refDateId, Map<Long, Date> attPerInf, CircleConfigVo circleConfigVo) {
        Date date = attPerInf.get(refDateId);
        if (null == date) {
            CycRefDateEnum cycRefDateEnum = CycRefDateEnum.getById((Long)refDateId);
            String msg = String.format(ResManager.loadKDString((String)"\u5b9a\u989d\u6838\u7b97\u53c2\u7167\u65e5\u671f\u7f3a\u5931\u3002\u5728\u201c%1$s\u201d\u671f\u95f4\u5faa\u73af\u4e2d\uff0c\u672a\u7ef4\u62a4\u201c%2$s\u201d\u3002\u8bf7\u524d\u5f80\u7cfb\u7edf\u7ef4\u62a4\u3002", (String)"CircleCalHelper_12", (String)"wtc-wtbs-business", (Object[])new Object[0]), circleConfigVo.getName(), cycRefDateEnum.getName());
            throw new KDBizException(msg);
        }
        return date;
    }

    private static Date getMinEndDate(Date perAttEndDate, Date endDate) {
        if (null == endDate) {
            return perAttEndDate;
        }
        return perAttEndDate.getTime() > endDate.getTime() ? endDate : perAttEndDate;
    }

    private static void getCirDay(CircleConfigVo config, Integer cirValue, Calendar seqDate) {
        CircleUnitEnum unitEnum = config.getCircleUnit();
        Integer cirDays = 0;
        if (CircleUnitEnum.CIRCLE_UNIT_MONTH == unitEnum) {
            Calendar cirDate = Calendar.getInstance();
            if (config.getAppointDate()) {
                seqDate.add(2, cirValue);
            } else {
                cirDate.setTime(seqDate.getTime());
                for (int i = 1; i <= cirValue; ++i) {
                    int monthDay = cirDate.getActualMaximum(5);
                    cirDays = cirDays + monthDay;
                    cirDate.add(5, monthDay);
                }
                seqDate.add(5, cirDays - 1);
            }
        } else if (CircleUnitEnum.CIRCLE_UNIT_YEAR == unitEnum) {
            if (config.getAppointDate()) {
                seqDate.add(1, cirValue);
            } else {
                Date beginDate = config.getBeginDate();
                beginDate = WTCDateUtils.getZeroDate((Date)beginDate);
                Calendar beginDateCalendar = Calendar.getInstance();
                beginDateCalendar.setTime(beginDate);
                int month = beginDateCalendar.get(2);
                Date lastDay = WTCDateUtils.getEndDayOfMonth((Date)beginDate);
                lastDay = WTCDateUtils.getZeroDate((Date)lastDay);
                seqDate.add(1, cirValue);
                if (month == 1 && lastDay.compareTo(beginDate) == 0) {
                    Date monthLastDay = WTCDateUtils.getEndDayOfMonth((Date)seqDate.getTime());
                    seqDate.setTime(monthLastDay);
                }
                seqDate.add(5, -1);
            }
        } else if (CircleUnitEnum.CIRCLE_UNIT_WEEK == unitEnum) {
            for (int i = 1; i <= cirValue; ++i) {
                cirDays = cirDays + 7;
            }
            seqDate.add(5, cirDays - 1);
        } else if (CircleUnitEnum.CIRCLE_UNIT_DAY == unitEnum) {
            seqDate.add(5, cirValue - 1);
        }
    }
}

