/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web;

import java.util.Date;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class DataBaseEditService {
    public static boolean isPkIdGen(DynamicObject entity) {
        if (HRObjectUtils.isEmpty((Object)entity)) {
            return false;
        }
        Long pkId = entity.getLong("id");
        return !pkId.equals(0L);
    }

    public static void isUpdateOperate(FormOperate operate, DynamicObject entity) {
        String operateKey = operate.getOperateKey();
        if (("save".equals(operateKey) || "submit".equals(operateKey)) && DataBaseEditService.isPkIdGen(entity)) {
            operate.getOption().setVariableValue("isupdate", "1");
        }
    }

    public static void setSysField(DynamicObject dy, Date date) {
        Long userId = RequestContext.get().getCurrUserId();
        dy.set("creator", (Object)userId);
        dy.set("createtime", (Object)date);
        dy.set("modifier", (Object)userId);
        dy.set("modifytime", (Object)date);
    }

    public static ListShowParameter getListShowParameter(String billFormId, String formId, ShowType showType) {
        ListShowParameter list = new ListShowParameter();
        list.setBillFormId(billFormId);
        if (HRStringUtils.isNotEmpty((String)formId)) {
            list.setFormId(formId);
        }
        list.getOpenStyle().setShowType(showType);
        list.setShowTitle(false);
        return list;
    }

    public static void setListDefaultWidthAndHeight(FormShowParameter formShowParameter) {
        OpenStyle style = new OpenStyle();
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("900px");
        cssValue.setHeight("600px");
        style.setInlineStyleCss(cssValue);
        style.setShowType(ShowType.Modal);
        formShowParameter.setOpenStyle(style);
    }

    public static FormShowParameter getFormShowParameter(String formId, ShowType showType) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.getOpenStyle().setShowType(showType);
        return formShowParameter;
    }

    public static BillShowParameter getBillShowParameter(String formId, ShowType showType, Object pkId) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId(formId);
        billShowParameter.setPkId(pkId);
        billShowParameter.getOpenStyle().setShowType(showType);
        return billShowParameter;
    }

    public static void showErrorNotification(IFormView view, String msg) {
        if (HRStringUtils.isNotEmpty((String)msg)) {
            view.showErrorNotification(msg);
        }
    }
}

