/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web;

import java.util.List;
import java.util.Map;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.report.IReportView;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;

public interface ICustomForm {
    default public void showCustomForm(IFormPlugin plugin, IFormView formView, Map<String, Object> customMap, List<Map<String, String>> errorList, int allnum, String operateKey) {
        if (errorList.isEmpty()) {
            if (allnum == 1) {
                this.showNotification(formView, this.msg(operateKey, allnum, true), "success");
            } else {
                this.showNotification(formView, this.msg(operateKey, allnum, false), "success");
            }
            return;
        }
        if (errorList.size() == allnum) {
            this.showCustomOperErrorsForm(plugin, formView, errorList, allnum, operateKey);
            return;
        }
        FormShowParameter parameters = new FormShowParameter();
        parameters.setFormId("wtc_operconfirm");
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setShowTitle(false);
        parameters.setCustomParam("operatename", (Object)this.operateName(operateKey));
        parameters.setCustomParam("allnum", (Object)String.valueOf(allnum));
        parameters.setCustomParam("oknum", (Object)String.valueOf(allnum - errorList.size()));
        parameters.setCustomParam("failnum", (Object)String.valueOf(errorList.size()));
        parameters.setCustomParam("failList", errorList);
        parameters.setCustomParam("operatetype", (Object)operateKey);
        parameters.setCustomParam("customParam", customMap);
        parameters.setCloseCallBack(new CloseCallBack(plugin, operateKey));
        formView.showForm(parameters);
    }

    default public void showCustomOperErrorsForm(IFormPlugin plugin, IFormView formView, List<Map<String, String>> errorList, int allnum, String operateKey) {
        if (errorList.size() == 1) {
            this.showNotification(formView, WTCCollectionIndexUtil.getEleFromList(errorList, (int)0).isPresent() ? (String)((Map)WTCCollectionIndexUtil.getEleFromList(errorList, (int)0).get()).get("message") : null, "fail");
            return;
        }
        FormShowParameter parameters = new FormShowParameter();
        parameters.setFormId("wtc_operationresult");
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setShowTitle(false);
        parameters.setCustomParam("operatename", (Object)this.operateName(operateKey));
        parameters.setCustomParam("allnum", (Object)String.valueOf(allnum));
        parameters.setCustomParam("failnum", (Object)String.valueOf(errorList.size()));
        parameters.setCustomParam("oknum", (Object)String.valueOf(allnum - errorList.size()));
        parameters.setCustomParam("failList", errorList);
        parameters.setCustomParam("operatetype", (Object)operateKey);
        parameters.setCloseCallBack(new CloseCallBack(plugin, operateKey));
        formView.showForm(parameters);
    }

    default public void closedCallBack(IFormView formView, ClosedCallBackEvent event) {
        Map returnData;
        Object returnObj = event.getReturnData();
        if (returnObj instanceof Map && (returnData = (Map)returnObj) != null && "ok".equals(returnData.get("res"))) {
            Map map = (Map)returnData.get("customParam");
            int oknum = this.okOperate(map, event);
            int allNum = this.allNumOperate(map, event);
            if (allNum > 1) {
                this.showNotification(formView, this.msg(event.getActionId(), oknum, false), "success");
            } else {
                this.showNotification(formView, this.msg(event.getActionId(), oknum, true), "success");
            }
            if (formView instanceof IReportView) {
                ((IReportView)formView).refresh();
            }
        }
    }

    public int okOperate(Map<String, Object> var1, ClosedCallBackEvent var2);

    public int allNumOperate(Map<String, Object> var1, ClosedCallBackEvent var2);

    public String operateName(String var1);

    public String msg(String var1, int var2, boolean var3);

    default public void showNotification(IFormView formView, String msg, String type) {
        if ("success".equals(type)) {
            formView.showSuccessNotification(msg);
        } else {
            formView.showErrorNotification(msg);
        }
    }
}

