/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.control.QRCode;
import kd.hr.hbp.business.domain.util.HisModelEditAuditTool;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.enums.SummaryLabelType;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;

public class SummaryServiceHelper {
    private static final Integer maxShowLong = 100;

    public static void showHisSummary(IFormView view, SummaryLabelType tagType) {
        DynamicObject dataEntity = view.getModel().getDataEntity();
        FormShowParameter formShowParameter = SummaryServiceHelper.setSummaryFormParam(view, tagType, "wtbs_basesummary2");
        Date startDate = dataEntity.getDate("startdate");
        formShowParameter.setCustomParam("startdate", (Object)WTCDateUtils.date2Str((Date)startDate, (String)WTCInteDateUtil.getUserDateFormat()));
        view.showForm(formShowParameter);
    }

    private static FormShowParameter setSummaryFormParam(IFormView view, SummaryLabelType tagType, String formId) {
        DynamicObject dataEntity = view.getModel().getDataEntity();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("basesummary");
        Date createDate = dataEntity.getDate("createtime");
        String creator = dataEntity.getString("creator.name");
        formShowParameter.setFormId(formId);
        String summaryName = dataEntity.getString("name");
        if (HRStringUtils.isNotEmpty((String)summaryName) && summaryName.trim().length() > maxShowLong) {
            summaryName = summaryName.trim().substring(0, maxShowLong) + "...";
        }
        formShowParameter.setCustomParam("name", (Object)summaryName);
        formShowParameter.setCustomParam("creator", (Object)creator);
        formShowParameter.setCustomParam("createdate", (Object)WTCInteDateUtil.formatByUserTzAndFmt((Date)createDate));
        if (tagType.isShowStatusLabel()) {
            formShowParameter.setCustomParam("status", (Object)dataEntity.getString("status"));
        }
        if (tagType.isShowEnableLabel()) {
            formShowParameter.setCustomParam("enable", (Object)dataEntity.getString("enable"));
        }
        if (dataEntity.getDataEntityType().getProperties().containsKey((Object)"datastatus")) {
            formShowParameter.setCustomParam("datastatus", (Object)dataEntity.getString("datastatus"));
        }
        formShowParameter.setCustomParam("param_tag_type", (Object)tagType);
        return formShowParameter;
    }

    public static void showAddSummary(IFormView view, String summaryName) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("basesummary");
        formShowParameter.setFormId("wtbs_basesummary");
        if (HRStringUtils.isNotEmpty((String)summaryName) && summaryName.trim().length() > maxShowLong) {
            summaryName = summaryName.trim().substring(0, maxShowLong) + "...";
        }
        formShowParameter.setCustomParam("name", (Object)summaryName);
        formShowParameter.setCustomParam("creator", (Object)RequestContext.get().getUserName());
        formShowParameter.setCustomParam("createdate", (Object)WTCInteDateUtil.formatByUserTzAndFmt((Date)new Date()));
        view.showForm(formShowParameter);
    }

    public static String showAddBillSummary(IFormView view, String summaryName) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("basesummary");
        formShowParameter.setFormId("wtbs_billbasesummary");
        if (HRStringUtils.isNotEmpty((String)summaryName) && summaryName.trim().length() > maxShowLong) {
            summaryName = summaryName.trim().substring(0, maxShowLong) + "...";
        }
        Date date = view.getModel().getDataEntity().getDate("createtime");
        OperationStatus status = view.getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW != status) {
            formShowParameter.setCustomParam("billstatus", (Object)view.getModel().getDataEntity().getString("billstatus"));
        }
        String num = view.getModel().getDataEntity().getString("billno");
        formShowParameter.setCustomParam("name", (Object)summaryName);
        formShowParameter.setCustomParam("creator", (Object)RequestContext.get().getUserName());
        formShowParameter.setCustomParam("createdate", (Object)WTCInteDateUtil.formatByUserTzAndFmt((Date)date));
        formShowParameter.setCustomParam("number", (Object)num);
        view.showForm(formShowParameter);
        return formShowParameter.getPageId();
    }

    public static void showViewSummary(IFormView view, SummaryLabelType tagType) {
        FormShowParameter formShowParameter = SummaryServiceHelper.setSummaryFormParam(view, tagType, "wtbs_baseviewsummary");
        view.showForm(formShowParameter);
    }

    public static void showAuditedViewSummary(IFormView view, SummaryLabelType tagType) {
        FormShowParameter formShowParameter = SummaryServiceHelper.setSummaryFormParam(view, tagType, "wtbs_basesummary2");
        DynamicObject dy = view.getModel().getDataEntity();
        Date date = null;
        if (dy.getBoolean("iscurrentversion")) {
            date = dy.getDate("firstbsed");
        } else {
            Long boId = dy.getLong("boid");
            if (boId != 0L) {
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(view.getFormShowParameter().getFormId());
                DynamicObject firstDy = serviceHelper.queryOne("firstbsed", (Object)boId);
                date = firstDy.getDate("firstbsed");
            }
        }
        String format = "";
        if (date != null) {
            format = WTCDateUtils.date2Str((Date)date, (String)WTCInteDateUtil.getUserDateFormat());
        }
        formShowParameter.setCustomParam("startdate", (Object)format);
        Map customParams = view.getFormShowParameter().getCustomParams();
        if ("insertdata_his".equals(customParams.get("option")) && !customParams.containsKey("his_action")) {
            formShowParameter.setCustomParam("name", (Object)view.getFormShowParameter().getFormName().replace(ResManager.loadKDString((String)"\u65b0\u589e\u6570\u636e\u7248\u672c-", (String)"SummaryServiceHelper_0", (String)"wtc-wtbs-business", (Object[])new Object[0]), ""));
        }
        view.showForm(formShowParameter);
    }

    public static void showViewDetailSummary(IFormView view, String summaryName) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("basesummary");
        formShowParameter.setFormId("wtbs_basesummary3");
        if (HRStringUtils.isNotEmpty((String)summaryName) && summaryName.trim().length() > maxShowLong) {
            summaryName = summaryName.trim().substring(0, maxShowLong) + "...";
        }
        if (HisModelEditAuditTool.getNeedAuditForBillEdit((IDataModel)view.getModel(), (IFormView)view)) {
            formShowParameter.setCustomParam("status", (Object)view.getModel().getDataEntity().getString("status"));
        } else {
            formShowParameter.setCustomParam("status", (Object)"status");
        }
        formShowParameter.setCustomParam("name", (Object)summaryName);
        formShowParameter.setCustomParam("enable", (Object)view.getModel().getDataEntity().getString("enable"));
        if (!HRObjectUtils.isEmpty((Object)view.getModel().getDataEntity().getDynamicObject("creator"))) {
            formShowParameter.setCustomParam("creator", (Object)view.getModel().getDataEntity().getDynamicObject("creator").getString("name"));
        }
        formShowParameter.setCustomParam("createdate", (Object)WTCInteDateUtil.formatByUserTzAndFmt((Date)view.getModel().getDataEntity().getDate("createtime")));
        view.showForm(formShowParameter);
    }

    public static String showBillDetailSummary(IFormView view, String summaryName) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("basesummary");
        if (HRStringUtils.isNotEmpty((String)summaryName) && summaryName.trim().length() > maxShowLong) {
            summaryName = summaryName.trim().substring(0, maxShowLong) + "...";
        }
        Boolean isSelfApply = Boolean.FALSE;
        Boolean showQrcode = Boolean.TRUE;
        String applyType = "1";
        DynamicObject dataEntity = view.getModel().getDataEntity();
        if (dataEntity.containsProperty("applytyperadio")) {
            String applytyperadio = dataEntity.getString("applytyperadio");
            isSelfApply = HRStringUtils.equals((String)applytyperadio, (String)"0") ? Boolean.TRUE : Boolean.FALSE;
            String formId = view.getFormShowParameter().getFormId();
            if (HRStringUtils.equals((String)"wtom_otbillchange", (String)formId) || HRStringUtils.equals((String)"wtam_busibillchange", (String)formId) || HRStringUtils.equals((String)"wtabm_vaupdate", (String)formId)) {
                isSelfApply = Boolean.FALSE;
            }
            formShowParameter.setFormId("wtbs_billdetailsummary");
            applyType = applytyperadio;
        } else if (dataEntity.containsProperty("applytype")) {
            applyType = dataEntity.getString("applytype");
            showQrcode = Boolean.FALSE;
            formShowParameter.setFormId("wtbs_billdetailsummary");
        } else {
            formShowParameter.setFormId("wtbs_batchbillsummary");
        }
        String billno = dataEntity.getString("billno");
        String billStatus = dataEntity.getString("billstatus");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", summaryName);
        map.put("isselfapply", isSelfApply);
        map.put("billno", billno);
        map.put("billstatus", billStatus);
        map.put("creator", dataEntity.getString("creator.name"));
        map.put("createdate", WTCInteDateUtil.formatByUserTzAndFmt((Date)dataEntity.getDate("createtime")));
        map.put("applytype", applyType);
        map.put("showQrcode", showQrcode);
        formShowParameter.setCustomParam("showMap", map);
        view.showForm(formShowParameter);
        return formShowParameter.getPageId();
    }

    public static String showBatchBillDetailSummary(IFormView view, String summaryName) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("basesummary");
        if (HRStringUtils.isNotEmpty((String)summaryName) && summaryName.trim().length() > maxShowLong) {
            summaryName = summaryName.trim().substring(0, maxShowLong) + "...";
        }
        Boolean isSelfApply = Boolean.FALSE;
        formShowParameter.setFormId("wtbs_batchbillsummary");
        DynamicObject dataEntity = view.getModel().getDataEntity();
        String billno = dataEntity.getString("billno");
        String billStatus = dataEntity.getString("billstatus");
        if (dataEntity.containsProperty("org")) {
            formShowParameter.setCustomParam("org", dataEntity.get("org.id"));
        }
        String entityId = view.getEntityId();
        String appId = view.getFormShowParameter().getCheckRightAppId();
        formShowParameter.setCustomParam("parentPageId", (Object)view.getPageId());
        formShowParameter.setCustomParam("parentEntityId", (Object)entityId);
        formShowParameter.setCustomParam("checkRightAppId", (Object)appId);
        formShowParameter.setStatus(view.getFormShowParameter().getStatus());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", summaryName);
        map.put("isselfapply", isSelfApply);
        map.put("billno", billno);
        map.put("billstatus", billStatus);
        map.put("creator", dataEntity.getString("creator.name"));
        map.put("createdate", WTCInteDateUtil.formatByUserTzAndFmt((Date)dataEntity.getDate("createtime")));
        formShowParameter.setCustomParam("showMap", map);
        view.showForm(formShowParameter);
        return formShowParameter.getPageId();
    }

    public static void updateSummaryBillStatus(IFormView view, String billStatus, String billNo) {
        Label label = (Label)view.getControl("auditstatus");
        if (label == null) {
            return;
        }
        String statusColor = null;
        String backColor = null;
        String borderColor = null;
        if ("A".equals(billStatus)) {
            statusColor = "#666666";
            backColor = "#F5F5F5";
            borderColor = "#CCCCCC";
            label.setText(ResManager.loadKDString((String)"\u6682\u5b58", (String)"SummaryServiceHelper_1", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        } else if ("B".equals(billStatus)) {
            statusColor = "#276FF5";
            backColor = "#F2F9FF";
            borderColor = statusColor;
            label.setText(ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4", (String)"SummaryServiceHelper_2", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        } else if ("C".equals(billStatus)) {
            statusColor = "#1BAB54";
            backColor = "#F2FFF5";
            borderColor = statusColor;
            label.setText(ResManager.loadKDString((String)"\u5ba1\u6279\u901a\u8fc7", (String)"SummaryServiceHelper_3", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        } else if ("D".equals(billStatus)) {
            statusColor = "#276FF5";
            backColor = "#F2F9FF";
            borderColor = statusColor;
            label.setText(ResManager.loadKDString((String)"\u5ba1\u6279\u4e2d", (String)"SummaryServiceHelper_4", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        } else if ("E".equals(billStatus)) {
            statusColor = "#FB2323";
            backColor = "#FFF2F4";
            borderColor = statusColor;
            label.setText(ResManager.loadKDString((String)"\u5ba1\u6279\u4e0d\u901a\u8fc7", (String)"SummaryServiceHelper_5", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        } else if ("F".equals(billStatus)) {
            statusColor = "#999999";
            backColor = "#FAFAFA";
            borderColor = statusColor;
            label.setText(ResManager.loadKDString((String)"\u5df2\u5e9f\u5f03", (String)"SummaryServiceHelper_6", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        } else if ("G".equals(billStatus)) {
            statusColor = "#FF991C";
            backColor = "#FFFBF2";
            borderColor = statusColor;
            label.setText(ResManager.loadKDString((String)"\u5f85\u91cd\u65b0\u63d0\u4ea4", (String)"SummaryServiceHelper_7", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        String lineStyle = "1px_solid_" + borderColor;
        HashMap style = new HashMap(16);
        HashMap<String, String> border = new HashMap<String, String>(16);
        border.put("r", lineStyle);
        border.put("l", lineStyle);
        border.put("t", lineStyle);
        border.put("b", lineStyle);
        style.put("b", border);
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("s", style);
        map.put("fc", statusColor);
        map.put("bc", backColor);
        view.updateControlMetadata("auditstatus", map);
        view.updateView("auditstatus");
        view.getModel().setValue("number", (Object)billNo);
        QRCode qrCode = (QRCode)view.getControl("qrcode");
        if (null == qrCode) {
            return;
        }
        qrCode.setUrl(billNo);
        view.updateView("qrcode");
    }
}

