/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web;

import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.auth.WTCBizDataPermissionServiceImpl;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.model.attendperson.HRPIEntityPropertyConst;
import kd.wtc.wtbs.business.util.WTCPermUtils;
import kd.wtc.wtbs.business.util.WtbsBusinessUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryHelper;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRCSMServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRPIMServiceImpl;
import kd.wtc.wtbs.common.enums.AttFilePlanEnum;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.enums.file.FileTypeEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileF7QueryParam;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.attfileauth.AgreedLocation;
import kd.wtc.wtbs.common.model.attfileauth.Assign;
import kd.wtc.wtbs.common.model.attfileauth.AttFile;
import kd.wtc.wtbs.common.model.attfileauth.AttFileAuthBase;
import kd.wtc.wtbs.common.model.attfileauth.AttFileInfo;
import kd.wtc.wtbs.common.model.attfileauth.AttPerson;
import kd.wtc.wtbs.common.model.attfileauth.AttTagBase;
import kd.wtc.wtbs.common.model.attfileauth.CmpEmp;
import kd.wtc.wtbs.common.model.attfileauth.ComputeCheck;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class WTCAttFileService {
    private static final HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_attfilebase");
    private static final Log logger = LogFactory.getLog(WTCAttFileService.class);

    public static QFilter getAttFileStatusQFilter(Boolean isCurrent) {
        QFilter statusQFilter = WTCHisServiceHelper.statusInQFilter("datastatus", "0", "1", "2");
        statusQFilter.and(WTCHisServiceHelper.isCurrentVersion(isCurrent));
        statusQFilter.and(new QFilter("filetype", "=", (Object)"A"));
        return statusQFilter;
    }

    @Deprecated
    public static DynamicObject queryAttFilePlan(Long personID, Date date, String plan) {
        Date date1;
        try {
            date1 = HRDateTimeUtils.parseDate((String)HRDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
        }
        catch (Exception e) {
            return null;
        }
        QFilter attFileQFilter = new QFilter("attperson", "=", (Object)personID);
        attFileQFilter.and("bsed", "<=", (Object)date1);
        attFileQFilter.and("bsled", ">=", (Object)date1);
        DynamicObject attFileDy = helper.queryOriginalOne("boid", new QFilter[]{attFileQFilter});
        if (attFileDy == null) {
            return null;
        }
        Long attFileBoId = attFileDy.getLong("boid");
        return WTCAttFileService.getAttFilePlan(plan, date1, attFileBoId);
    }

    public static DynamicObject getAttFilePlan(String plan, Date date, Long fileBoId) {
        AttFileScheduleEnum scheduleEnum = AttFileScheduleEnum.getAttFileScheduleEnumByKey((String)plan);
        if (scheduleEnum == null || scheduleEnum.isTimeHis()) {
            return null;
        }
        Long planID = WTCAttFileService.getAttFilePlanId(scheduleEnum, date, fileBoId);
        if (planID == 0L) {
            return null;
        }
        HRBaseServiceHelper planHelper = new HRBaseServiceHelper(AttFilePlanEnum.getVal((String)plan));
        QFilter planFilter = WTCHisServiceHelper.dataStatusValidQFilter();
        planFilter.and("id", "=", (Object)planID);
        return planHelper.loadDynamicObject(planFilter);
    }

    @Deprecated
    public static Map<Long, List<DynamicObject>> queryAttFilePlan(AttFileScheduleEnum attFileScheduleEnum, Date startDate, Date endDate, List<Long> fileBoIdList) {
        if (attFileScheduleEnum.isTimeHis()) {
            return Collections.emptyMap();
        }
        HRBaseServiceHelper fileScheduleHelper = new HRBaseServiceHelper(attFileScheduleEnum.getPageId());
        QFilter qFilter = WTCHisServiceHelper.dataStatusValidQFilter();
        qFilter.and("attfileid", "in", fileBoIdList);
        QFilter dateQFilter = AttFileQueryHelper.getDateQFilter(startDate, endDate, false);
        qFilter.and(dateQFilter);
        qFilter.and(WTCHisServiceHelper.isCurrentVersion(true));
        qFilter.and("busistatus", "=", (Object)"1");
        String queryField = WTCStringUtils.joinStr((String[])new String[]{attFileScheduleEnum.getKey(), ".", "id"});
        DynamicObject[] fileScheduleDysArr = fileScheduleHelper.queryOriginalArray(WTCStringUtils.joinStr((String[])new String[]{queryField, ",", "attfileid"}), new QFilter[]{qFilter});
        if (fileScheduleDysArr == null || fileScheduleDysArr.length == 0) {
            return Collections.emptyMap();
        }
        HashMap resMap = Maps.newHashMapWithExpectedSize((int)fileScheduleDysArr.length);
        HRBaseServiceHelper planHelper = new HRBaseServiceHelper(AttFilePlanEnum.getVal((String)attFileScheduleEnum.getKey()));
        QFilter planFilter = WTCHisServiceHelper.dataStatusValidQFilter();
        planFilter.and("id", "in", Arrays.stream(fileScheduleDysArr).map(fileSchedule -> fileSchedule.getLong(queryField)).collect(Collectors.toList()));
        Map planMap = Arrays.stream(planHelper.loadDynamicObjectArray(new QFilter[]{planFilter})).collect(Collectors.toMap(plan -> plan.getLong("id"), Function.identity()));
        for (DynamicObject fileSchedule2 : fileScheduleDysArr) {
            long attFileBoId = fileSchedule2.getLong("attfileid");
            long planBoId = fileSchedule2.getLong(queryField);
            List listPlan = (List)resMap.get(attFileBoId);
            if (listPlan != null) {
                listPlan.add(planMap.get(planBoId));
                continue;
            }
            listPlan = Lists.newArrayListWithExpectedSize((int)16);
            listPlan.add(planMap.get(planBoId));
            resMap.put(attFileBoId, listPlan);
        }
        return resMap;
    }

    @Deprecated
    public static Map<Long, List<DynamicObject>> queryAttFileSchedule(AttFileScheduleEnum attFileScheduleEnum, Date startDate, Date endDate, List<Long> fileBoIdList) {
        if (attFileScheduleEnum.isTimeHis()) {
            return Collections.emptyMap();
        }
        HRBaseServiceHelper fileScheduleHelper = new HRBaseServiceHelper(attFileScheduleEnum.getPageId());
        QFilter qFilter = WTCHisServiceHelper.dataStatusValidQFilter();
        qFilter.and("attfileid", "in", fileBoIdList);
        QFilter dateQFilter = AttFileQueryHelper.getDateQFilter(startDate, endDate, false);
        qFilter.and(dateQFilter);
        qFilter.and(WTCHisServiceHelper.isCurrentVersion(true));
        qFilter.and("busistatus", "=", (Object)"1");
        String queryField = WTCStringUtils.joinStr((String[])new String[]{attFileScheduleEnum.getKey(), ".", "id"});
        String dateField = WTCStringUtils.joinStr((String[])new String[]{"startdate", ",", "enddate"});
        DynamicObject[] fileScheduleDysArr = fileScheduleHelper.queryOriginalArray(WTCStringUtils.joinStr((String[])new String[]{queryField, ",", dateField, ",", "attfileid", ",", "busistatus"}), new QFilter[]{qFilter});
        return Arrays.stream(fileScheduleDysArr).collect(Collectors.groupingBy(fileSchedule -> fileSchedule.getLong("attfileid")));
    }

    public static Long getAttFilePlanId(AttFileScheduleEnum scheduleEnum, Date date, Long fileBoId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(scheduleEnum.getPageId());
        QFilter qFilter = WTCHisServiceHelper.dataStatusValidQFilter();
        qFilter.and("attfileid", "=", (Object)fileBoId);
        qFilter.and("startdate", "<=", (Object)date);
        qFilter.and("enddate", ">=", (Object)date);
        qFilter.and(WTCHisServiceHelper.isCurrentVersion(true));
        if (!scheduleEnum.isTimeHis()) {
            qFilter.and("busistatus", "=", (Object)"1");
        }
        String queryField = WTCStringUtils.joinStr((String[])new String[]{scheduleEnum.getKey(), ".", "id"});
        DynamicObject scheduleDy = helper.queryOriginalOne(queryField, new QFilter[]{qFilter});
        if (scheduleDy == null) {
            return 0L;
        }
        return scheduleDy.getLong(queryField);
    }

    @Deprecated
    public static DynamicObjectCollection queryAttFiles(List<Long> attPersonIds, Date startDate, Date endDate) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(startDate, endDate);
        attFileQueryParam.setAttPersonSetIds(new HashSet<Long>(attPersonIds));
        attFileQueryParam.setAttStatus(null);
        attFileQueryParam.setProperties(AttFileQueryParam.attCalProperties);
        List<DynamicObject> attFiles = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        dynamicObjectCollection.addAll(attFiles);
        return dynamicObjectCollection;
    }

    public static DynamicObjectCollection queryAttFilesWithOutAuthCheck(List<Long> attPersonIds, Date startDate, Date endDate) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(startDate, endDate);
        attFileQueryParam.setAttPersonSetIds(new HashSet<Long>(attPersonIds));
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setAttStatus(null);
        attFileQueryParam.setProperties(AttFileQueryParam.attCalProperties);
        List<DynamicObject> attFiles = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        dynamicObjectCollection.addAll(attFiles);
        return dynamicObjectCollection;
    }

    private static List<DynamicObject> getAttFilesDyList(AttFileQueryParam attFileQueryParam, QFilter fileFilter) {
        QFilter statusQFilter = WTCAttFileService.getAttFileStatusQFilter(attFileQueryParam.getBeCurrent() == null ? Boolean.FALSE : attFileQueryParam.getBeCurrent());
        QFilter qFilter = attFileQueryParam.getqFilter();
        QFilter[] qFilters = new QFilter[]{statusQFilter, fileFilter, qFilter};
        return WTCAttFileService.baseQueryAttFile(attFileQueryParam, qFilters);
    }

    private static List<DynamicObject> baseQueryAttFile(AttFileQueryParam attFileQueryParam, QFilter[] qFilters) {
        QFilter[] targetFilter;
        if (qFilters == null) {
            targetFilter = (QFilter[])Array.newInstance(QFilter.class, 1);
            targetFilter[0] = AttFileQueryHelper.getAttFileAuthQFilter();
        } else {
            targetFilter = Arrays.copyOf(qFilters, qFilters.length + 1);
            targetFilter[qFilters.length] = AttFileQueryHelper.getAttFileAuthQFilter();
        }
        if (HRStringUtils.isNotEmpty((String)attFileQueryParam.getProperties())) {
            DynamicObject[] objects = helper.queryOriginalArray(attFileQueryParam.getProperties(), targetFilter);
            return Arrays.stream(objects).collect(Collectors.toList());
        }
        DynamicObject[] mainFile = helper.loadDynamicObjectArray(targetFilter);
        return Arrays.stream(mainFile).collect(Collectors.toList());
    }

    @Deprecated
    public static List<DynamicObject> queryAttFilesByFileQFilter(QFilter qFilter) {
        return WTCAttFileService.getAttFilesDyList(new AttFileQueryParam(), qFilter);
    }

    @Deprecated
    public static List<DynamicObject> queryAttFiles(Collection<Long> attPersonIds, Date enddate) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setAttPersonSetIds(new HashSet<Long>(attPersonIds));
        attFileQueryParam.setAttStatus(null);
        attFileQueryParam.setEndDate(enddate);
        return AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
    }

    public static List<DynamicObject> queryAttFilesByAttFileBoIds(Collection<Long> attFileBoIds, Date enddate) {
        AttFileF7QueryParam param = new AttFileF7QueryParam();
        param.setProperties(AttFileQueryParam.attCalProperties);
        param.setAppId("wtte");
        param.setFormId("wtte_tietaskdetail");
        param.setPermField("attfile");
        param.setOrgAuthCheck(Boolean.TRUE.booleanValue());
        param.setAttStatus(null);
        param.setSetBoIds(new HashSet<Long>(attFileBoIds));
        param.setEndDate(enddate);
        return AttFileQueryServiceImpl.getInstance().queryAttFilesByCustomAuth(param);
    }

    public static List<DynamicObject> queryAttFilesWithOutAuthCheck(Collection<Long> attPersonIds, Date endDate) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setAttPersonSetIds(new HashSet<Long>(attPersonIds));
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setAttStatus(null);
        attFileQueryParam.setEndDate(endDate);
        attFileQueryParam.setProperties(AttFileQueryParam.QT_CAL_PROPERTIES);
        return AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
    }

    public static List<DynamicObject> queryAttFilesByAttFileBoIdsWithOutAuthCheck(Collection<Long> attFileBoIds, Date endDate) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setSetBoIds(new HashSet<Long>(attFileBoIds));
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setAttStatus(null);
        attFileQueryParam.setEndDate(endDate);
        attFileQueryParam.setProperties(AttFileQueryParam.attCalProperties);
        return AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
    }

    public static QFilter getPermRuleQFilter() {
        HRCSMServiceImpl instance = HRCSMServiceImpl.getInstance();
        QFilter dataRuleQFilter = instance.getDataRuleForBdProp(RequestContext.get().getCurrUserId(), "wtte", "wtte_tietaskdetail", "attfile", "47150e89000000ac", new HashMap<String, Object>(1));
        QFilter authOrgQFilter = WTCBizDataPermissionServiceImpl.getInstance().getAllPermOrgsWithOrgKey("wtte", "wtte_tietaskdetail", "org");
        if (dataRuleQFilter != null) {
            dataRuleQFilter.and(authOrgQFilter);
            return dataRuleQFilter;
        }
        return authOrgQFilter;
    }

    @Deprecated
    public static Date queryEarliestStartDate(Long personId) {
        QFilter statusQFilter = WTCAttFileService.getAttFileStatusQFilter(Boolean.FALSE);
        QFilter qFilter = new QFilter("attperson.id", "=", (Object)personId);
        DynamicObject mainFile = helper.queryOriginalOne("bsed", new QFilter[]{statusQFilter, qFilter}, "bsed");
        if (mainFile != null) {
            return mainFile.getDate("bsed");
        }
        return null;
    }

    @Deprecated
    public static Map<Long, List<DynamicObject>> queryAttFileScheduleByFileId(Collection<Long> fileIds, String scheduleSign) {
        AttFileScheduleEnum attFileScheduleEnum = AttFileScheduleEnum.valueOf((String)scheduleSign.toUpperCase());
        return AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(fileIds, attFileScheduleEnum, false);
    }

    @Deprecated
    public static Map<Long, List<DynamicObject>> loadAttFileScheduleByFileId(Collection<Long> fileIds, String scheduleSign) {
        AttFileScheduleEnum attFileScheduleEnum = AttFileScheduleEnum.valueOf((String)scheduleSign.toUpperCase());
        return AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(fileIds, attFileScheduleEnum, true);
    }

    public static Map<String, Object> getAttFileDetailParamMap(DynamicObject dynamicObject, Object pkId) {
        HashMap customVariablesMap = Maps.newHashMapWithExpectedSize((int)16);
        customVariablesMap.put("empposorgrel", dynamicObject.getLong("empposorgrel.id"));
        customVariablesMap.put("attfileid", pkId);
        customVariablesMap.put("attperson.id", dynamicObject.getLong("attperson.id"));
        customVariablesMap.put("attperson.name", dynamicObject.getString("attperson.name"));
        customVariablesMap.put("boid", dynamicObject.getLong("boid"));
        return customVariablesMap;
    }

    @Deprecated
    public static FormShowParameter getFileDetailForm(Object pkId, IFormPlugin plugin, String actionId) {
        return WTCAttFileService.getFileDetailForm(pkId, plugin, actionId, FileTypeEnum.ATTFILE.getFileType());
    }

    public static FormShowParameter getFileDetailForm(Object pkId, IFormPlugin plugin, String actionId, String fileType) {
        DynamicObject dynamicObject = AttFileQueryServiceImpl.getInstance().queryOneAttFile("id,boid,empposorgrel,empposorgrel.id,attperson,attperson.id,attperson.name,type", pkId);
        if (HRStringUtils.isEmpty((String)fileType)) {
            fileType = dynamicObject.getString("type");
        }
        Map<String, Object> attFileDetailParamMap = WTCAttFileService.getAttFileDetailParamMap(dynamicObject, pkId);
        return WTCAttFileService.getFileDetailForm(attFileDetailParamMap, plugin, actionId, fileType);
    }

    @Deprecated
    public static FormShowParameter getFileDetailForm(Map<String, Object> customVariablesMap, IFormPlugin plugin, String actionId) {
        return WTCAttFileService.getFileDetailForm(customVariablesMap, plugin, actionId, FileTypeEnum.ATTFILE.getFileType());
    }

    public static String getAppName(String billFormId) {
        String app = "";
        if ("wtp_vafilebase".equals(billFormId)) {
            app = "wtabm";
        } else if ("wtp_attfilebase".equals(billFormId)) {
            app = "wtam";
        }
        return app;
    }

    public static FormShowParameter getFileDetailForm(Map<String, Object> customVariablesMap, IFormPlugin plugin, String actionId, String fileType) {
        FormShowParameter formShowParameter = new FormShowParameter();
        Object attFileIdObj = customVariablesMap.get("attfileid");
        if (attFileIdObj != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(RequestContext.getOrCreate().getGlobalSessionId());
            sb.append(attFileIdObj);
            formShowParameter.setPageId(sb.toString());
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setFormId("wtp_attfiledetail");
        formShowParameter.setCustomParam("attfileid", customVariablesMap.get("attfileid"));
        formShowParameter.setCustomParam("currentObjectPKId", (Object)String.valueOf(customVariablesMap.get("attfileid")));
        if (FileTypeEnum.ALLFILE.getFileType().equals(fileType)) {
            formShowParameter.setCustomParam("wtbs_entitytype_id", (Object)"1381998876562612224");
            formShowParameter.setCustomParam("filetype", (Object)FileTypeEnum.ALLFILE.getFileType());
            formShowParameter.setCustomParam("appName", (Object)"wtam");
        } else if (FileTypeEnum.VCFILE.getFileType().equals(fileType)) {
            formShowParameter.setCustomParam("wtbs_entitytype_id", (Object)"1570286861933346816");
            formShowParameter.setCustomParam("filetype", (Object)FileTypeEnum.VCFILE.getFileType());
            formShowParameter.setCustomParam("appName", (Object)"wtabm");
        } else {
            formShowParameter.setCustomParam("wtbs_entitytype_id", (Object)"1381998876562612224");
        }
        formShowParameter.setCustomParam("dateScope", customVariablesMap.get("dateScope"));
        formShowParameter.setCustomParam("customvariables", customVariablesMap);
        formShowParameter.setCloseCallBack(new CloseCallBack(plugin, actionId));
        String captionString = "";
        if (FileTypeEnum.ALLFILE.getFileType().equals(fileType)) {
            captionString = WtbsBusinessUtils.getFormCaption("wtp_attfilebase", () -> (String)customVariablesMap.get("attperson.name"));
        } else if (FileTypeEnum.VCFILE.getFileType().equals(fileType)) {
            captionString = WtbsBusinessUtils.getFormCaption("wtp_vafilebase", () -> (String)customVariablesMap.get("attperson.name"));
        }
        formShowParameter.setCustomParam("filetype", (Object)fileType);
        formShowParameter.setCaption(captionString);
        formShowParameter.setHasRight(true);
        return formShowParameter;
    }

    public static List<AttFileInfo> queryAttFileInfoByIds(List<Long> pkIdList) {
        if (CollectionUtils.isEmpty(pkIdList)) {
            return Collections.emptyList();
        }
        List<DynamicObject> dynamicObjectList = AttFileQueryServiceImpl.getInstance().queryAttFileByIds(null, new ArrayList<Object>(pkIdList));
        ArrayList<AttFileInfo> attFileInfoList = new ArrayList<AttFileInfo>(pkIdList.size());
        Map<Long, AttPerson> attPersons = WTCAttFileService.getAttPersons(dynamicObjectList);
        for (DynamicObject dynamicObject : dynamicObjectList) {
            AttFileInfo attFileInfo = new AttFileInfo();
            attFileInfo.setAssign(WTCAttFileService.getAssign(dynamicObject));
            attFileInfo.setAttFile(WTCAttFileService.getAttFile(dynamicObject));
            attFileInfo.setCmpEmp(WTCAttFileService.getCmpEmp(dynamicObject));
            attFileInfo.setAttPerson(attPersons.get(dynamicObject.getLong("id")));
            attFileInfo.setComputeCheck(WTCAttFileService.getComputeCheck(dynamicObject));
            attFileInfoList.add(attFileInfo);
        }
        return attFileInfoList;
    }

    public static Set<Long> queryFilesWithPermissionByBoId(Set<Long> attFileBoIdList, boolean isCurrent) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setBeCurrent(Boolean.valueOf(isCurrent));
        attFileQueryParam.setSetBoIds(attFileBoIdList);
        List<DynamicObject> files = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        return WTCAttFileService.queryFilesWithPermission(files);
    }

    public static Set<Long> queryFilesWithPermission(List<DynamicObject> attFileList) {
        if (attFileList == null || attFileList.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet empGroupSet = Sets.newHashSetWithExpectedSize((int)attFileList.size());
        HashSet affiliateAdminOrg = Sets.newHashSetWithExpectedSize((int)attFileList.size());
        HashSet orgSet = Sets.newHashSetWithExpectedSize((int)attFileList.size());
        WTCAttFileService.setPermFilterSet(empGroupSet, affiliateAdminOrg);
        HasPermOrgResult allPermOrg = WTCPermUtils.getAllPermOrgs("wtam", "wtp_attfilebase");
        if (allPermOrg != null && !allPermOrg.hasAllOrgPerm() && !allPermOrg.getHasPermOrgs().isEmpty()) {
            orgSet.addAll(new ArrayList(allPermOrg.getHasPermOrgs()));
        }
        return attFileList.stream().filter(attFile -> {
            if (!empGroupSet.isEmpty() && !empGroupSet.contains(attFile.getLong("empgroup.id"))) {
                return false;
            }
            if (!orgSet.isEmpty() && !orgSet.contains(attFile.getLong("org.id"))) {
                return false;
            }
            return affiliateAdminOrg.isEmpty() || affiliateAdminOrg.contains(attFile.getLong("affiliateadminorg.id"));
        }).map(attFile -> attFile.getLong("id")).collect(Collectors.toSet());
    }

    private static void setPermFilterSet(Set<Long> empGroupSet, Set<Long> affiliateAdminOrg) {
        QFilter[] recombineQFilters;
        block8: for (QFilter recombineQFilter : recombineQFilters = AttFileQueryHelper.getAttFileAuthQFilter().recombine()) {
            String property;
            switch (property = recombineQFilter.getProperty()) {
                case "empgroup": {
                    WTCAttFileService.fillPermTargetSet(empGroupSet, recombineQFilter);
                    continue block8;
                }
                case "affiliateadminorg": {
                    WTCAttFileService.fillPermTargetSet(affiliateAdminOrg, recombineQFilter);
                    continue block8;
                }
            }
        }
    }

    private static void fillPermTargetSet(Set<Long> targetSet, QFilter recombineQFilter) {
        Object value = recombineQFilter.getValue();
        if (value == null) {
            return;
        }
        targetSet.addAll((Collection)recombineQFilter.getValue());
    }

    public static Assign getAssign(DynamicObject dynamicObject) {
        Assign assign = new Assign();
        assign.setBoid(Long.valueOf(dynamicObject.getLong("empposorgrel.id")));
        assign.setWorkplace(dynamicObject.getString("empposorgrel.workplace"));
        AttFileAuthBase adminOrg = new AttFileAuthBase();
        adminOrg.setBoid(Long.valueOf(dynamicObject.getLong("empposorgrel.adminorg.id")));
        adminOrg.setName(dynamicObject.getString("empposorgrel.adminorg.name"));
        assign.setAdminOrg(adminOrg);
        AttFileAuthBase compay = new AttFileAuthBase();
        compay.setBoid(Long.valueOf(dynamicObject.getLong("empposorgrel.company.id")));
        compay.setName(dynamicObject.getString("empposorgrel.company.name"));
        assign.setCompany(compay);
        AttFileAuthBase position = new AttFileAuthBase();
        position.setBoid(Long.valueOf(dynamicObject.getLong("empposorgrel.position.id")));
        position.setName(dynamicObject.getString("empposorgrel.position.name"));
        assign.setPosition(position);
        AttFileAuthBase job = new AttFileAuthBase();
        job.setBoid(Long.valueOf(dynamicObject.getLong("empposorgrel.job.id")));
        job.setName(dynamicObject.getString("empposorgrel.job.name"));
        assign.setJob(job);
        AttFileAuthBase cmpEmp = new AttFileAuthBase();
        cmpEmp.setBoid(Long.valueOf(dynamicObject.getLong("cmpemp.id")));
        cmpEmp.setName(dynamicObject.getString("cmpemp.managingscope.name"));
        assign.setCmpEmp(cmpEmp);
        AttFileAuthBase posStatus = new AttFileAuthBase();
        posStatus.setBoid(Long.valueOf(dynamicObject.getLong("empposorgrel.posstatus.id")));
        posStatus.setName(dynamicObject.getString("empposorgrel.posstatus.name"));
        assign.setPosStatus(posStatus);
        AttFileAuthBase posType = new AttFileAuthBase();
        posType.setBoid(Long.valueOf(dynamicObject.getLong("empposorgrel.postype.id")));
        posType.setName(dynamicObject.getString("empposorgrel.postype.name"));
        assign.setPosType(posType);
        return assign;
    }

    public static Map<Long, AttPerson> getAttPersons(List<DynamicObject> attFileDys) {
        if (kd.bos.orm.util.CollectionUtils.isEmpty(attFileDys)) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        Map<Long, String> personIdAndHeadPic = WTCAttFileService.getHeadInfoByAttFileDys(attFileDys);
        for (DynamicObject attFileDy : attFileDys) {
            AttPerson person = WTCAttFileService.getAttPerson(attFileDy);
            long attFileVid = attFileDy.getLong("id");
            person.setHeadsculpture(personIdAndHeadPic.get(attFileVid));
            result.put(attFileVid, person);
        }
        return result;
    }

    private static Map<Long, String> getHeadInfoByAttFileDys(List<DynamicObject> attFileDys) {
        List<Long> personIdList = attFileDys.stream().map(dy -> dy.getLong("person.id")).collect(Collectors.toList());
        List<DynamicObject> personBaseInfo = HRPIMServiceImpl.getInstance().listFieldsFilterInfoBatch("id", personIdList, StringUtils.join(Arrays.asList(HRPIEntityPropertyConst.PERSON_SELECT_FIELDS), (String)","), null, "hrpi_person");
        HashMap personIdAndPic = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dy2 : personBaseInfo) {
            personIdAndPic.put(dy2.getLong("id"), dy2.getString("headsculpture"));
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject attFileDy : attFileDys) {
            result.put(attFileDy.getLong("id"), personIdAndPic.get(attFileDy.getLong("attperson.id")));
        }
        return result;
    }

    public static AttPerson getAttPerson(DynamicObject dynamicObject) {
        AttPerson person = new AttPerson();
        person.setBoid(Long.valueOf(dynamicObject.getLong("attperson.id")));
        person.setNumber(dynamicObject.getString("attperson.number"));
        person.setName(dynamicObject.getString("attperson.name"));
        person.setGender(Long.valueOf(dynamicObject.getLong("attperson.gender.id")));
        person.setGenderName(dynamicObject.getString("attperson.gender.name"));
        AttFileAuthBase laborRelStatus = new AttFileAuthBase();
        laborRelStatus.setBoid(Long.valueOf(dynamicObject.getLong("attperson.laborrelstatus.id")));
        laborRelStatus.setName(dynamicObject.getString("attperson.laborrelstatus.name"));
        person.setLaborRelStatus(laborRelStatus);
        AttFileAuthBase laborRelType = new AttFileAuthBase();
        laborRelType.setBoid(Long.valueOf(dynamicObject.getLong("attperson.laborreltype.id")));
        laborRelType.setName(dynamicObject.getString("attperson.laborreltype.name"));
        person.setLaborRelType(laborRelType);
        AgreedLocation agreedLocation = new AgreedLocation();
        String agreedLocationPro = WTCStringUtils.joinStr((String[])new String[]{"attperson", ".", "agreedlocation", "."});
        agreedLocation.setId(Long.valueOf(dynamicObject.getLong(WTCStringUtils.joinStr((String[])new String[]{agreedLocationPro, "id"}))));
        agreedLocation.setName(dynamicObject.getString(WTCStringUtils.joinStr((String[])new String[]{agreedLocationPro, "name"})));
        agreedLocation.setNumber(dynamicObject.getString(WTCStringUtils.joinStr((String[])new String[]{agreedLocationPro, "number"})));
        person.setAgreedLocation(agreedLocation);
        return person;
    }

    public static AttFile getAttFile(DynamicObject dynamicObject) {
        AttFile attFile = new AttFile();
        attFile.setAffiliateAdminOrg(WTCAttFileService.getAffiliateAdminOrg(dynamicObject));
        attFile.setCard(dynamicObject.getString("card"));
        attFile.setDependency(WTCAttFileService.getDependency(dynamicObject));
        attFile.setDependencyType(WTCAttFileService.getDependencyType(dynamicObject));
        attFile.setEmpPosOrgRel(WTCAttFileService.getEmpPosOrgRel(dynamicObject));
        attFile.setEmpGroup(WTCAttFileService.getEmpGroup(dynamicObject));
        attFile.setFileType(dynamicObject.getString("filetype"));
        attFile.setWorkPlace(WTCAttFileService.getWorkPlace(dynamicObject));
        attFile.setOrg(WTCAttFileService.getOrg(dynamicObject));
        attFile.setVid(Long.valueOf(dynamicObject.getLong("id")));
        attFile.setBoid(Long.valueOf(dynamicObject.getLong("boid")));
        attFile.setFirstBsed(dynamicObject.getDate("firstbsed"));
        attFile.setBsed(dynamicObject.getDate("bsed"));
        attFile.setBsled(dynamicObject.getDate("bsled"));
        attFile.setNumber(dynamicObject.getString("number"));
        attFile.setAttTag(WTCAttFileService.getAttTag(dynamicObject));
        return attFile;
    }

    private static AttFileAuthBase getEmpPosOrgRel(DynamicObject dynamicObject) {
        AttFileAuthBase empPosOrgRel = new AttFileAuthBase();
        empPosOrgRel.setBoid(Long.valueOf(dynamicObject.getLong("empposorgrel.id")));
        return empPosOrgRel;
    }

    public static CmpEmp getCmpEmp(DynamicObject dynamicObject) {
        CmpEmp cmpEmp = new CmpEmp();
        cmpEmp.setBoId(Long.valueOf(dynamicObject.getLong(WTCStringUtils.joinStr((String[])new String[]{"cmpemp", ".", "id"}))));
        AttFileAuthBase manageScope = new AttFileAuthBase();
        String manageScopePro = WTCStringUtils.joinStr((String[])new String[]{"cmpemp", ".", "managingscope", "."});
        manageScope.setBoid(Long.valueOf(dynamicObject.getLong(WTCStringUtils.joinStr((String[])new String[]{manageScopePro, "id"}))));
        manageScope.setName(dynamicObject.getString(WTCStringUtils.joinStr((String[])new String[]{manageScopePro, "name"})));
        manageScope.setNumber(dynamicObject.getString(WTCStringUtils.joinStr((String[])new String[]{manageScopePro, "number"})));
        cmpEmp.setManageScope(manageScope);
        return cmpEmp;
    }

    private static AttFileAuthBase getOrg(DynamicObject dynamicObject) {
        AttFileAuthBase org = new AttFileAuthBase();
        org.setBoid(Long.valueOf(dynamicObject.getLong("org.id")));
        org.setName(dynamicObject.getString("org.name"));
        return org;
    }

    private static AttFileAuthBase getEmpGroup(DynamicObject dynamicObject) {
        AttFileAuthBase empGroup = new AttFileAuthBase();
        empGroup.setBoid(Long.valueOf(dynamicObject.getLong("empgroup.id")));
        empGroup.setName(dynamicObject.getString("empgroup.name"));
        return empGroup;
    }

    private static AttFileAuthBase getWorkPlace(DynamicObject dynamicObject) {
        AttFileAuthBase workPlace = new AttFileAuthBase();
        DynamicObject workPlaceDy = dynamicObject.getDynamicObject("workplace");
        if (workPlaceDy != null) {
            workPlace.setBoid(Long.valueOf(workPlaceDy.getLong("id")));
            workPlace.setName(workPlaceDy.getString("name"));
            workPlace.setNumber(workPlaceDy.getString("number"));
        }
        return workPlace;
    }

    private static AttFileAuthBase getAffiliateAdminOrg(DynamicObject dynamicObject) {
        AttFileAuthBase affiliateAdminOrg = new AttFileAuthBase();
        affiliateAdminOrg.setBoid(Long.valueOf(dynamicObject.getLong("affiliateadminorg.id")));
        affiliateAdminOrg.setName(dynamicObject.getString("affiliateadminorg.name"));
        return affiliateAdminOrg;
    }

    private static AttFileAuthBase getDependency(DynamicObject dynamicObject) {
        AttFileAuthBase dependency = new AttFileAuthBase();
        dependency.setBoid(Long.valueOf(dynamicObject.getLong("dependency.id")));
        dependency.setName(dynamicObject.getString("dependency.name"));
        return dependency;
    }

    private static AttFileAuthBase getDependencyType(DynamicObject dynamicObject) {
        AttFileAuthBase dependencyType = new AttFileAuthBase();
        dependencyType.setBoid(Long.valueOf(dynamicObject.getLong("dependencytype.id")));
        dependencyType.setName(dynamicObject.getString("dependencytype.name"));
        return dependencyType;
    }

    public static ComputeCheck getComputeCheck(DynamicObject dynamicObject) {
        ComputeCheck computeCheck = new ComputeCheck();
        computeCheck.setBoid(Long.valueOf(dynamicObject.getLong("wtteinfo.id")));
        computeCheck.setAccountTo(dynamicObject.getDate("wtteinfo.accountto"));
        computeCheck.setStorageto(dynamicObject.getDate("wtteinfo.storageto"));
        computeCheck.setLockTo(dynamicObject.getDate("wtteinfo.lockto"));
        return computeCheck;
    }

    private static AttTagBase getAttTag(DynamicObject dynamicObject) {
        AttTagBase attTagBase = new AttTagBase();
        attTagBase.setBoid(Long.valueOf(dynamicObject.getLong("atttag.id")));
        attTagBase.setName(dynamicObject.getString("atttag.name"));
        attTagBase.setAttendstatus(dynamicObject.getString("atttag.attendstatus"));
        return attTagBase;
    }

    public static Map<String, Object> checkAttfileAuth(Long attpersonid, Date startDate, Date endDate) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        startDate = WTCDateUtils.getZeroDate((Date)startDate);
        endDate = WTCDateUtils.getZeroDate((Date)endDate);
        Boolean success = Boolean.TRUE;
        String message = "";
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setAttPersonId(attpersonid.longValue());
        attFileQueryParam.setStartDate(startDate);
        attFileQueryParam.setEndDate(endDate);
        List<DynamicObject> attFiles = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        if (CollectionUtils.isEmpty(attFiles)) {
            resultMap.put("success", Boolean.FALSE);
            message = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u6240\u9009\u8303\u56f4\u5185\u7684\u6863\u6848\u7248\u672c\u6570\u636e\u3002", (String)"WTCAttFileService_1", (String)"wtc-wtbs-business", (Object[])new Object[0]), (String)"BusiTripInfoPlugin04", (String)"wtc-wtam-fromplugin", (Object[])new Object[0]);
            resultMap.put("message", message);
            return resultMap;
        }
        String personName = attFiles.get(0).getString("person.name");
        Set<Long> afftileIdset = WTCAttFileService.queryFilesWithPermission(attFiles);
        if (attFiles.size() == afftileIdset.size()) {
            success = Boolean.TRUE;
        } else if (CollectionUtils.isEmpty(afftileIdset)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            success = Boolean.FALSE;
            message = String.format(ResManager.loadKDString((String)"%1$s\u5728%2$s\u81f3%3$s\u7684\u8003\u52e4\u6863\u6848\u5728\u60a8\u7684\u63a7\u6743\u4e4b\u5916\uff0c\u65e0\u6cd5\u4ee3\u4e3a\u63d0\u5355\u3002", (String)"WTCAttFileService_2", (String)"wtc-wtbs-business", (Object[])new Object[0]), personName, simpleDateFormat.format(startDate), simpleDateFormat.format(endDate));
        } else {
            for (DynamicObject affFile : attFiles) {
                Long pkValue = (Long)affFile.getPkValue();
                if (afftileIdset.contains(pkValue)) continue;
                Date bsed = affFile.getDate("bsed");
                Date bsled = affFile.getDate("bsled");
                Date maxStartDate = startDate.compareTo(bsed) > 0 ? startDate : bsed;
                Date minEndDate = endDate.compareTo(bsled) > 0 ? bsled : endDate;
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                success = Boolean.FALSE;
                message = String.format(ResManager.loadKDString((String)"%1$s\u5b58\u5728\u90e8\u5206\u63d0\u5355\u65f6\u6bb5{%2$s\u81f3%3$s} \u7684\u8003\u52e4\u6863\u6848\u8d85\u51fa\u60a8\u7684\u63a7\u6743\uff0c\u65e0\u6cd5\u4ee3\u4e3a\u63d0\u5355\u3002", (String)"WTCAttFileService_3", (String)"wtc-wtbs-business", (Object[])new Object[0]), personName, simpleDateFormat.format(maxStartDate), simpleDateFormat.format(minEndDate));
                break;
            }
        }
        resultMap.put("success", success);
        resultMap.put("message", message);
        return resultMap;
    }

    public static List<DynamicObject> queryDiscardAttFilesByAttFileBoIds(Collection<Long> attFileBoIds, Date endDate) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setSetBoIds(new HashSet<Long>(attFileBoIds));
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setAttStatus(null);
        attFileQueryParam.setEndDate(endDate);
        attFileQueryParam.setProperties(AttFileQueryParam.attCalProperties);
        attFileQueryParam.setUsableStatus((Set)Sets.newHashSet((Object[])new String[]{"-1"}));
        return AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
    }
}

