/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.LabelAp;
import kd.hr.hbp.business.servicehelper.HRExportDataHelper;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class WTCTipsFormService {
    public static final String PROPERTIES = "wtc-wtbs-business";
    private static final Log logger = LogFactory.getLog(WTCTipsFormService.class);

    private WTCTipsFormService() {
    }

    public static LabelAp createLabel(String key, String name) {
        LabelAp lbl = new LabelAp();
        lbl.setKey(key);
        lbl.setName(new LocaleString(name));
        return lbl;
    }

    public static void doExport(IFormView view) {
        FormShowParameter formParam = view.getFormShowParameter();
        Map params = formParam.getCustomParams();
        List failList = (List)params.get("failList");
        if (WTCCollections.isEmpty((Collection)failList)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)"WTCTipsFormService_6", (String)PROPERTIES, (Object[])new Object[0]));
            return;
        }
        ArrayList data = Lists.newArrayListWithExpectedSize((int)failList.size());
        ArrayList head = Lists.newArrayListWithExpectedSize((int)10);
        WTCTipsFormService.setExportInfo(failList, data, head);
        String format = ResManager.loadKDString((String)"\u5bfc\u51faExcel\u6570\u636e_%s", (String)"WTCTipsFormService_0", (String)PROPERTIES, (Object[])new Object[0]);
        String nowStr = new SimpleDateFormat("MMdd-hhmmssSSS").format(new Date());
        String excelName = String.format(format, nowStr);
        String exportUrl = null;
        try {
            exportUrl = HRExportDataHelper.getExportExcelUrl((String)excelName, (List)data, (List)head);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        if (!StringUtils.isEmpty((CharSequence)exportUrl)) {
            IClientViewProxy clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
            clientViewProxy.addAction("download", (Object)exportUrl);
        }
    }

    public static void setExportInfo(List<Map<String, String>> failList, List<Map<String, Object>> data, List<HRExportHeadObject> head) {
        HRExportHeadObject headObj1 = new HRExportHeadObject();
        headObj1.setColumnId("number");
        headObj1.setColumnAlias(ResManager.loadKDString((String)"\u5bfc\u51faExcel\u6570\u636e_%s\u3002", (String)"WTCTipsFormService_1", (String)PROPERTIES, (Object[])new Object[0]));
        HRExportHeadObject headObj2 = new HRExportHeadObject();
        headObj2.setColumnId("name");
        headObj2.setColumnAlias(ResManager.loadKDString((String)"\u540d\u79f0", (String)"WTCTipsFormService_2", (String)PROPERTIES, (Object[])new Object[0]));
        HRExportHeadObject headObj3 = new HRExportHeadObject();
        headObj3.setColumnId("result");
        headObj3.setColumnAlias(ResManager.loadKDString((String)"\u6821\u9a8c\u7ed3\u679c", (String)"WTCTipsFormService_3", (String)PROPERTIES, (Object[])new Object[0]));
        HRExportHeadObject headObj4 = new HRExportHeadObject();
        headObj4.setColumnId("failInfo");
        headObj4.setColumnAlias(ResManager.loadKDString((String)"\u6821\u9a8c\u4e0d\u901a\u8fc7\u539f\u56e0", (String)"WTCTipsFormService_4", (String)PROPERTIES, (Object[])new Object[0]));
        head.add(headObj1);
        head.add(headObj2);
        head.add(headObj3);
        head.add(headObj4);
        HashMap map = null;
        for (Map<String, String> failInfo : failList) {
            map = Maps.newHashMapWithExpectedSize((int)16);
            map.put("number", failInfo.get("number"));
            map.put("name", failInfo.get("name"));
            map.put("result", ResManager.loadKDString((String)"\u4e0d\u901a\u8fc7", (String)"WTCTipsFormService_5", (String)PROPERTIES, (Object[])new Object[0]));
            map.put("failInfo", failInfo.get("message"));
            data.add(map);
        }
    }

    public static void showMore(IFormView view) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("ide_showoperationresult");
        WTCTipsFormService.setFailMessageToCache(view);
        view.getParentView().showForm(parameter);
        view.sendFormAction(view.getParentView());
        view.close();
    }

    public static void setFailMessageToCache(IFormView view) {
        FormShowParameter param = view.getFormShowParameter();
        Object operateName = param.getCustomParam("operatename");
        IPageCache pageCache = (IPageCache)view.getParentView().getService(IPageCache.class);
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        OperationResult operationResult = new OperationResult();
        List allErrorInfo = operationResult.getAllErrorInfo();
        List faiList = (List)param.getCustomParam("failList");
        for (Map failMap : faiList) {
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setMessage((String)failMap.get("message"));
            if (operateName != null) {
                errorInfo.setTitle(operateName.toString());
            }
            errorInfo.setErrorLevel(String.valueOf(ErrorLevel.Error));
            allErrorInfo.add(errorInfo);
        }
        String serialResult = DataEntitySerializer.serializerToString((Object)operationResult, (DataEntitySerializerOption)option);
        pageCache.put("operationresult", serialResult);
    }
}

