/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.commonhelper;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.web.applybill.commonhelper.UnifyBillCommonHelper;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.business.web.billservice.plan.BillPlanService;
import kd.wtc.wtbs.common.enums.bill.UnifyCallChainEnum;
import kd.wtc.wtbs.common.model.bill.PlanRuleEngineOutParam;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillDutyInfoResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillEntryResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillResult;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class UnifyApplyBillEngineHelper {
    private static final Log LOG = LogFactory.getLog(UnifyApplyBillEngineHelper.class);

    protected List<PlanRuleEngineOutParam> getRuleEngine(WtcAbstractUnityBillOperator operator) {
        if (operator.getInfoContext().getUnifyBillCommonInfo().getPlanRuleEngineOutParam() == null) {
            BillPlanService service = new BillPlanService();
            Map<Long, List<DynamicObject>> attFileVersionIdAndDy = UnifyBillCommonHelper.getAttFileVersionIdAndDy(operator);
            Map<Long, List<DynamicObject>> attFileVersionIdAndPlanDy = this.getContextAllPlan(operator);
            Map<Long, List<LocalDate>> attFileVersionIdAndQueryDate = this.getAttFileBoIdAndQueryDateMapping(operator);
            List<PlanRuleEngineOutParam> ruleDyInEngine = service.getRuleDyInEngine(attFileVersionIdAndPlanDy, attFileVersionIdAndDy, attFileVersionIdAndQueryDate, operator.getUnifyBillEnum().getPlanSceneEnum());
            operator.getInfoContext().getUnifyBillCommonInfo().setPlanRuleEngineOutParam(ruleDyInEngine);
        }
        return operator.getInfoContext().getUnifyBillCommonInfo().getPlanRuleEngineOutParam();
    }

    private Map<Long, List<LocalDate>> getAttFileBoIdAndQueryDateMapping(WtcAbstractUnityBillOperator operator) {
        HashMap<Long, List<LocalDate>> reqs = new HashMap<Long, List<LocalDate>>(16);
        for (UnifyBillResult unifyBillResult : operator.getInfoContext().getBillResult()) {
            long attFileBoId = unifyBillResult.getAttFileBoId();
            List queryDateInBo = reqs.computeIfAbsent(attFileBoId, k -> new ArrayList(10));
            queryDateInBo.add(LocalDate.now());
            List entryResultList = unifyBillResult.getEntryResultList();
            if (WTCCollections.isEmpty((Collection)entryResultList)) continue;
            for (UnifyBillEntryResult unifyBillEntryResult : entryResultList) {
                List dutyInfos = unifyBillEntryResult.getDutyInfos();
                if (WTCCollections.isEmpty((Collection)dutyInfos)) continue;
                for (UnifyBillDutyInfoResult dutyInfo : dutyInfos) {
                    Date entryMainDutyDate = dutyInfo.getEntryMainDutyDate();
                    entryMainDutyDate = entryMainDutyDate == null ? dutyInfo.getDutyDate() : entryMainDutyDate;
                    queryDateInBo.add(WTCDateUtils.toLocalDate((Date)entryMainDutyDate));
                }
            }
        }
        return reqs;
    }

    private Map<Long, List<DynamicObject>> getContextAllPlan(WtcAbstractUnityBillOperator operator) {
        if (!operator.getInfoContext().hasInvokeCall(UnifyCallChainEnum.matchAllPlan)) {
            operator.invokeEvent(Lists.newArrayList((Object[])new UnifyCallChainEnum[]{UnifyCallChainEnum.matchAllPlan}));
        }
        HashMap contextPlan = Maps.newHashMapWithExpectedSize((int)10);
        List billServiceInfoList = operator.getInfoContext().getBillResult();
        for (UnifyBillResult billServiceResult : billServiceInfoList) {
            contextPlan.put(billServiceResult.getAttFileBoId(), billServiceResult.getAllPlanInAttFile());
        }
        return contextPlan;
    }
}

