/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.commonhelper;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.bill.AttfileLimitScopeServiceImpl;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.rulecondition.RuleConditionRetrieval;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.util.ext.LimitConditionExpBundle;
import kd.wtc.wtbs.business.web.applybill.commonhelper.UnifyApplyBillEngineHelper;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.business.web.billservice.attfile.BillAttFileService;
import kd.wtc.wtbs.business.web.billservice.plan.BillPlanService;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.bill.AttfileLimitScope;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.enums.bill.UnifyCallChainEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyPlanEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.bill.PlanRuleEngineOutParam;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillDutyInfoResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillEntryResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillResult;
import kd.wtc.wtbs.common.model.billservice.BillAttFileVersionPlanInfo;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class UnifyBillCommonHelper {
    private static final Log LOG = LogFactory.getLog(UnifyBillCommonHelper.class);

    public static Map<Long, List<DynamicObject>> getPlanDyByAttFilePlan(Map<Long, List<DynamicObject>> attFilePlanDys, WtcAbstractUnityBillOperator operator) {
        HashMap attFileIdAndPlanBoIds = Maps.newHashMapWithExpectedSize((int)attFilePlanDys.size());
        HashSet planBoIds = Sets.newHashSetWithExpectedSize((int)attFilePlanDys.size());
        attFilePlanDys.forEach((key, attFilePlanDyLists) -> {
            ArrayList planBoIdsInOneAttFile = Lists.newArrayListWithExpectedSize((int)attFilePlanDyLists.size());
            for (DynamicObject attFilePlanDy : attFilePlanDyLists) {
                long boId = attFilePlanDy.getLong(WTCStringUtils.joinStr((String[])new String[]{operator.getUnifyBillEnum().getAttFileScheduleEnum().getKey(), ".", "id"}));
                planBoIdsInOneAttFile.add(boId);
                planBoIds.add(boId);
            }
            attFileIdAndPlanBoIds.put(key, planBoIdsInOneAttFile);
        });
        String entityNumber = operator.getUnifyBillEnum().getUnifyPlanEnum().getEntityNumber();
        DynamicObject[] allSeqHisDys = UnifyBillCommonHelper.getAllSeqHisDys(entityNumber, WTCHisServiceHelper.getMinEndDate(), WTCHisServiceHelper.getMaxEndDate(), planBoIds);
        HashMap attFileIdAndPlanDy = Maps.newHashMapWithExpectedSize((int)allSeqHisDys.length);
        for (Map.Entry attFileAndPlanBoIds : attFileIdAndPlanBoIds.entrySet()) {
            ArrayList planDys = Lists.newArrayListWithExpectedSize((int)planBoIds.size());
            Long attFileBoId = (Long)attFileAndPlanBoIds.getKey();
            List planBoIdsInAttFile = (List)attFileAndPlanBoIds.getValue();
            for (DynamicObject planHisDy : allSeqHisDys) {
                if (!planBoIdsInAttFile.contains(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)planHisDy, (String)"boid"))) continue;
                planDys.add(planHisDy);
            }
            attFileIdAndPlanDy.put(attFileBoId, planDys);
        }
        return attFileIdAndPlanDy;
    }

    @Deprecated
    public static Long getRuleBoIdByPlanDy(DynamicObject plan, WtcAbstractUnityBillOperator operator) {
        if (plan == null) {
            return 0L;
        }
        UnifyApplyBillEngineHelper engineHelper = new UnifyApplyBillEngineHelper();
        List<PlanRuleEngineOutParam> planRuleEngineOutParam = engineHelper.getRuleEngine(operator);
        Tuple<Boolean, List<Long>> resultAndRuleBoIdSet = UnifyBillCommonHelper.matchEngineRuleBoId(plan, planRuleEngineOutParam);
        if (((Boolean)resultAndRuleBoIdSet.item1).booleanValue()) {
            List ruleBoIds = (List)resultAndRuleBoIdSet.item2;
            if (CollectionUtils.isEmpty((Collection)ruleBoIds)) {
                return 0L;
            }
            if (ruleBoIds.size() > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u4e2d\u7684\u89c4\u5219\u5f15\u64ce\u4ec5\u53ef\u914d\u7f6e\u4e00\u6761\u89c4\u5219\u3002", (String)"UnifyBillCommonHelper_0", (String)"wtc-wtbs-business", (Object[])new Object[0]));
            }
            return (Long)ruleBoIds.get(0);
        }
        UnifyPlanEnum unifyPlanEnum = operator.getUnifyBillEnum().getUnifyPlanEnum();
        return plan.getLong(unifyPlanEnum.getFieldRuleInPlan() + "." + "id");
    }

    public static Long getRuleBoIdByPlanDy(DynamicObject plan, LocalDate engineQueryDate, DynamicObject matchEngineAttFileDy, WtcAbstractUnityBillOperator operator) {
        if (plan == null) {
            return 0L;
        }
        UnifyApplyBillEngineHelper engineHelper = new UnifyApplyBillEngineHelper();
        List<PlanRuleEngineOutParam> planRuleEngineOutParam = engineHelper.getRuleEngine(operator);
        Tuple<Boolean, List<Long>> resultAndRuleBoIdSet = BillPlanService.getInstance().matchEngineRuleBoId(plan, engineQueryDate, matchEngineAttFileDy, planRuleEngineOutParam);
        if (((Boolean)resultAndRuleBoIdSet.item1).booleanValue()) {
            List ruleBoIds = (List)resultAndRuleBoIdSet.item2;
            if (CollectionUtils.isEmpty((Collection)ruleBoIds)) {
                return 0L;
            }
            if (ruleBoIds.size() > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u4e2d\u7684\u89c4\u5219\u5f15\u64ce\u4ec5\u53ef\u914d\u7f6e\u4e00\u6761\u89c4\u5219\u3002", (String)"UnifyBillCommonHelper_0", (String)"wtc-wtbs-business", (Object[])new Object[0]));
            }
            return (Long)ruleBoIds.get(0);
        }
        UnifyPlanEnum unifyPlanEnum = operator.getUnifyBillEnum().getUnifyPlanEnum();
        return plan.getLong(unifyPlanEnum.getFieldRuleInPlan() + "." + "id");
    }

    private static Tuple<Boolean, List<Long>> matchEngineRuleBoId(DynamicObject needMatchPlan, List<PlanRuleEngineOutParam> planRuleEngineOutParamList) {
        if (!CollectionUtils.isEmpty(planRuleEngineOutParamList) && needMatchPlan != null) {
            for (PlanRuleEngineOutParam ruleEngineOutParam : planRuleEngineOutParamList) {
                DynamicObject planInEngine = ruleEngineOutParam.getPlan();
                if (planInEngine == null || !needMatchPlan.getPkValue().equals(planInEngine.getPkValue())) continue;
                List rules = ruleEngineOutParam.getRules();
                if (CollectionUtils.isEmpty((Collection)rules)) {
                    return new Tuple((Object)Boolean.TRUE, Collections.emptyList());
                }
                return new Tuple((Object)Boolean.TRUE, rules.stream().map(dy -> HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dy, (String)"boid")).collect(Collectors.toList()));
            }
        }
        return new Tuple((Object)Boolean.FALSE, Collections.emptyList());
    }

    public static DynamicObject[] getAllSeqHisDys(String entityKey, Date startTime, Date endTime, Set<Long> boIds) {
        QFilter dateQFilter = WTCHisServiceHelper.getDateQFilter(startTime, endTime);
        dateQFilter.and("boid", "in", boIds);
        dateQFilter.and("datastatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"1", "2", "0"}));
        dateQFilter.and("iscurrentversion", "!=", (Object)"1");
        HRBaseServiceHelper attPlanService = new HRBaseServiceHelper(entityKey);
        return attPlanService.loadDynamicObjectArray(dateQFilter.toArray());
    }

    public static DynamicObject getSeqHisDyByDate(Object boId, Date time, List<DynamicObject> allDys) {
        for (DynamicObject allDy : allDys) {
            Object boIdFromDy = allDy.get("boid");
            Date startTime = allDy.getDate("bsed");
            Date endTime = allDy.getDate("bsled");
            endTime = WTCDateUtils.getDayEndTime((Date)endTime);
            if (!boIdFromDy.equals(boId) || !WTCDateUtils.betweenDay((Date)time, (Date)startTime, (Date)endTime)) continue;
            return allDy;
        }
        return null;
    }

    public static List<UnifyBillDutyInfoResult> matchDutyInfoByBillIdAndIndex(long billId, int entryIndex, List<UnifyBillResult> unifyBillResult) {
        for (UnifyBillResult billResult : unifyBillResult) {
            if (billId != billResult.getBillId()) continue;
            for (UnifyBillEntryResult unifyBillEntryResult : billResult.getEntryResultList()) {
                int resultIndex = unifyBillEntryResult.getEntryIndex();
                if (resultIndex != entryIndex) continue;
                return unifyBillEntryResult.getDutyInfos();
            }
        }
        return Collections.emptyList();
    }

    public static List<UnifyBillDutyInfoResult> matchOneBillDutyDateInfo(long attFileBoId, Date startTime, Date endTime, Long needMatchTypeId, List<UnifyBillResult> unifyBillResult) {
        if (startTime == null || endTime == null) {
            return Collections.emptyList();
        }
        for (UnifyBillResult serviceResult : unifyBillResult) {
            List<UnifyBillDutyInfoResult> infos;
            if (attFileBoId != serviceResult.getAttFileBoId() || CollectionUtils.isEmpty(infos = UnifyBillCommonHelper.getMatchDutyInfoByInitTimeAndType(serviceResult.getEntryResultList(), startTime, endTime, needMatchTypeId))) continue;
            return infos;
        }
        return Collections.emptyList();
    }

    private static List<UnifyBillDutyInfoResult> getMatchDutyInfoByInitTimeAndType(List<UnifyBillEntryResult> entryResultList, Date startTime, Date endTime, Long needMatchTypeId) {
        for (UnifyBillEntryResult billServiceEntryResult : entryResultList) {
            Date startTimeInBillInfo = billServiceEntryResult.getDutyDateQueryStartTime();
            Date endTimeInBillInfo = billServiceEntryResult.getDutyDateQueryEndTime();
            if (startTimeInBillInfo.getTime() != startTime.getTime() || endTime.getTime() != endTimeInBillInfo.getTime()) continue;
            if (needMatchTypeId == null) {
                return billServiceEntryResult.getDutyInfos();
            }
            if (!needMatchTypeId.equals(billServiceEntryResult.getNeedMatchTypeId())) continue;
            return billServiceEntryResult.getDutyInfos();
        }
        return Collections.emptyList();
    }

    public static UnifyBillEntryResult matchEntryInfo(long billId, int index, List<UnifyBillResult> unifyBillResult) {
        for (UnifyBillResult billServiceResult : unifyBillResult) {
            if (billId != billServiceResult.getBillId()) continue;
            for (UnifyBillEntryResult billServiceEntryResult : billServiceResult.getEntryResultList()) {
                if (index != billServiceEntryResult.getEntryIndex()) continue;
                return billServiceEntryResult;
            }
        }
        return null;
    }

    public static UnifyBillEntryResult matchEntryInfo(long attFileBoId, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime, List<UnifyBillResult> unifyBillResult) {
        for (UnifyBillResult billServiceResult : unifyBillResult) {
            if (attFileBoId != billServiceResult.getAttFileBoId()) continue;
            for (UnifyBillEntryResult billServiceEntryResult : billServiceResult.getEntryResultList()) {
                Date startTimeInBillInfo = billServiceEntryResult.getDutyDateQueryStartTime();
                Date endTimeInBillInfo = billServiceEntryResult.getDutyDateQueryEndTime();
                if (startTimeInBillInfo.getTime() != dutyDateQueryStartTime.getTime() || dutyDateQueryEndTime.getTime() != endTimeInBillInfo.getTime()) continue;
                return billServiceEntryResult;
            }
        }
        return null;
    }

    public static void handleBeforeGetUnifyResult(UnifyCallChainEnum chainEnum, WtcAbstractUnityBillOperator invokeOperator, WtcAbstractUnityBillOperator checkOperator) {
        if (!invokeOperator.getInfoContext().hasInvokeCall(chainEnum)) {
            invokeOperator.invokeEvent(Lists.newArrayList((Object[])new UnifyCallChainEnum[]{chainEnum}));
        }
        if (checkOperator != invokeOperator.getInfoContext().getInvokeService(chainEnum)) {
            LOG.error("UnifyBillCommonHelper.handleBeforeGetUnifyResult operator get result error.UnifyCallChainEnum = {}", (Object)chainEnum);
            throw new KDBizException(ResManager.loadKDString((String)"\u975e\u5f53\u524d\u5b9e\u73b0\u7c7b\u52a0\u8f7d\u7684\u4e0a\u4e0b\u6587\u6570\u636e\u3002", (String)"UnifyBillCommonHelper_1", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
    }

    public static Set<Long> getContextAppFileBoIds(List<UnifyBillResult> unifyBillResultList) {
        if (CollectionUtils.isEmpty(unifyBillResultList)) {
            return Collections.emptySet();
        }
        return unifyBillResultList.stream().map(UnifyBillResult::getAttFileBoId).collect(Collectors.toSet());
    }

    public static void limitScopeTypesGroupByAttfileBo(List<DynamicObject> allTypeInAttFile, List<DynamicObject> allAttFileVersion, Map<Long, List<DynamicObject>> allRuleInAttFile, UnifyBillEnum unifyBillEnum) {
        UnifyBillCommonHelper.limitScopeTypesGroupByAttfileBo(allTypeInAttFile, allAttFileVersion, allRuleInAttFile, unifyBillEnum, null);
    }

    @Deprecated
    public static void limitScopeTypesGroupByAttfileBo(List<DynamicObject> allTypeInAttFile, List<DynamicObject> allAttFileVersion, Map<Long, List<DynamicObject>> allRuleInAttFile, UnifyBillEnum unifyBillEnum, LimitConditionExpBundle limitBundle) {
        if (CollectionUtils.isEmpty(allRuleInAttFile)) {
            return;
        }
        AttfileLimitScopeServiceImpl limitScopeService = new AttfileLimitScopeServiceImpl();
        ArrayList<DynamicObject> temp = new ArrayList<DynamicObject>(10);
        Set<Long> versionIds = allAttFileVersion.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        Map<Long, AttfileLimitScope> longAttfileLimitScopeMap = limitScopeService.queryAttfileVersionInfo(versionIds, null);
        for (DynamicObject attFileVersionDy : allAttFileVersion) {
            long attFileVid = attFileVersionDy.getLong("id");
            limitBundle = new LimitConditionExpBundle(limitBundle.getLimitSource(), limitBundle.getPluginProxy(), attFileVid);
            AttfileLimitScope attfileLimitScope = longAttfileLimitScopeMap.get(attFileVid);
            List<DynamicObject> ruleInAttFileList = allRuleInAttFile.get(attFileVid);
            if (attfileLimitScope == null || CollectionUtils.isEmpty(ruleInAttFileList)) {
                LOG.warn("UnifyBillCommonHelper_limitScopeTypesGroupByAttfileBo can not match attFileVid.attFileVid :{},ruleInAttFileList is null :{},ruleInAttFileList is empty :{}", new Object[]{attFileVid, attfileLimitScope == null, CollectionUtils.isEmpty(ruleInAttFileList)});
                continue;
            }
            for (DynamicObject ruleInAttFile : ruleInAttFileList) {
                DynamicObjectCollection entryEntity = ruleInAttFile.getDynamicObjectCollection(unifyBillEnum.getUnifyPlanEnum().getRuleEnum().getCalEntry());
                for (DynamicObject entryRow : entryEntity) {
                    String calCulDes = entryRow.getString(unifyBillEnum.getUnifyPlanEnum().getRuleEnum().getUnifyRuleCalEntryEnum().getCalCulDes());
                    DynamicObject type = entryRow.getDynamicObject(unifyBillEnum.getUnifyPlanEnum().getRuleEnum().getUnifyRuleCalEntryEnum().getType());
                    boolean match = limitScopeService.matchLimit(attfileLimitScope, calCulDes, limitBundle);
                    if (match) {
                        temp.add(type);
                        continue;
                    }
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info("UnifyBillCommonHelper_limitScopeTypesGroupByAttfileBo is not match");
                }
            }
        }
        LOG.info("UnifyBillCommonHelper_limitScopeTypesGroupByAttfileBo temp.size = {}", (Object)temp.size());
        allTypeInAttFile.addAll(temp);
    }

    public static void limitScopeTypesGroupByAttfileBoNew(List<DynamicObject> allTypeInAttFile, List<DynamicObject> allAttFileVersion, Map<Long, List<DynamicObject>> allRuleInAttFile, UnifyBillEnum unifyBillEnum, List<RuleConditionRetrieval> ruleConditionRetrievals) {
        if (CollectionUtils.isEmpty(allRuleInAttFile)) {
            return;
        }
        ArrayList<DynamicObject> temp = new ArrayList<DynamicObject>(10);
        Map<String, List<RuleConditionRetrieval>> resultMap = ruleConditionRetrievals.stream().collect(Collectors.groupingBy(RuleConditionRetrieval::getDimensionKey));
        for (DynamicObject attFileVersionDy : allAttFileVersion) {
            long attFileVid = attFileVersionDy.getLong("id");
            List<DynamicObject> ruleInAttFileList = allRuleInAttFile.get(attFileVid);
            if (WTCCollections.isEmpty(ruleInAttFileList)) continue;
            for (DynamicObject ruleInAttFile : ruleInAttFileList) {
                DynamicObjectCollection entryEntity = ruleInAttFile.getDynamicObjectCollection(unifyBillEnum.getUnifyPlanEnum().getRuleEnum().getCalEntry());
                for (DynamicObject entryRow : entryEntity) {
                    DynamicObject type = entryRow.getDynamicObject(unifyBillEnum.getUnifyPlanEnum().getRuleEnum().getUnifyRuleCalEntryEnum().getType());
                    List<RuleConditionRetrieval> retrievalResults = resultMap.get(attFileVid + "_" + entryRow.get("id"));
                    if (WTCCollections.isNotEmpty(retrievalResults)) {
                        Optional<RuleConditionRetrieval> any = retrievalResults.stream().filter(RuleConditionRetrieval::isMatchResult).findAny();
                        if (!any.isPresent()) continue;
                        temp.add(type);
                        continue;
                    }
                    temp.add(type);
                }
            }
        }
        LOG.info("UnifyBillCommonHelper_limitScopeTypesGroupByAttfileBo temp.size = {}", (Object)temp.size());
        allTypeInAttFile.addAll(temp);
    }

    @Deprecated
    public static Map<Long, Map<Long, List<DynamicObject>>> getPlanDyGroupByAttFilePlan(Map<Long, List<DynamicObject>> attFileFilePlanDys, WtcAbstractUnityBillOperator operator) {
        HashMap attFileIdAndPlanBoIds = Maps.newHashMapWithExpectedSize((int)attFileFilePlanDys.size());
        HashSet planBoIds = Sets.newHashSetWithExpectedSize((int)attFileFilePlanDys.size());
        attFileFilePlanDys.forEach((key, attFilePlanDyLists) -> {
            HashMap<Long, ArrayList<Long>> planBoIdsInOneAttFileVersion = new HashMap<Long, ArrayList<Long>>(4);
            for (DynamicObject attFilePlanDy : attFilePlanDyLists) {
                long boId = attFilePlanDy.getLong(WTCStringUtils.joinStr((String[])new String[]{operator.getUnifyBillEnum().getAttFileScheduleEnum().getKey(), ".", "id"}));
                long attfilevid = attFilePlanDy.getLong("attfilevid");
                Long boDy = attFilePlanDy.getLong(operator.getUnifyBillEnum().getAttFileScheduleEnum().getKey() + ".id");
                ArrayList<Long> boDys = (ArrayList<Long>)planBoIdsInOneAttFileVersion.get(attfilevid);
                if (CollectionUtils.isEmpty((Collection)boDys)) {
                    boDys = new ArrayList<Long>();
                }
                boDys.add(boDy);
                planBoIdsInOneAttFileVersion.put(attfilevid, boDys);
                planBoIds.add(boId);
            }
            attFileIdAndPlanBoIds.put(key, planBoIdsInOneAttFileVersion);
        });
        String entityNumber = operator.getUnifyBillEnum().getUnifyPlanEnum().getEntityNumber();
        DynamicObject[] allSeqHisDys = UnifyBillCommonHelper.getAllSeqHisDys(entityNumber, WTCHisServiceHelper.getMinEndDate(), WTCHisServiceHelper.getMaxEndDate(), planBoIds);
        HashMap attFileIdAndPlanDy = Maps.newHashMapWithExpectedSize((int)allSeqHisDys.length);
        for (Map.Entry attFileAndPlanBoIds : attFileIdAndPlanBoIds.entrySet()) {
            HashMap planDys = new HashMap(4);
            Long attFileBoId = (Long)attFileAndPlanBoIds.getKey();
            Map planBoIdsInAttFile = (Map)attFileAndPlanBoIds.getValue();
            for (DynamicObject planHisDy : allSeqHisDys) {
                planBoIdsInAttFile.forEach((k, v) -> v.forEach(j -> {
                    if (j.equals(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)planHisDy, (String)"boid"))) {
                        List dynamicObjects = planDys.computeIfAbsent(k, k1 -> new ArrayList(4));
                        dynamicObjects.add(planHisDy);
                    }
                }));
            }
            attFileIdAndPlanDy.put(attFileBoId, planDys);
        }
        attFileFilePlanDys.forEach((key, val) -> attFileIdAndPlanDy.putIfAbsent(key, Collections.emptyMap()));
        return attFileIdAndPlanDy;
    }

    public static Map<Long, List<BillAttFileVersionPlanInfo>> getRelaForAttFileVersionAndPlan(Map<Long, List<DynamicObject>> attFileVersionMap, Map<Long, List<DynamicObject>> attFileFilePlanDyMap, AttFileScheduleEnum scheduleEnum) {
        BillAttFileService billAttFileService = new BillAttFileService();
        if (CollectionUtils.isEmpty(attFileVersionMap)) {
            return Collections.emptyMap();
        }
        attFileFilePlanDyMap = attFileFilePlanDyMap == null ? Collections.emptyMap() : attFileFilePlanDyMap;
        HashMap result = Maps.newHashMapWithExpectedSize((int)attFileVersionMap.size());
        for (Map.Entry<Long, List<DynamicObject>> attFileVersion : attFileVersionMap.entrySet()) {
            Long boId = attFileVersion.getKey();
            List<DynamicObject> attFileVersionList = attFileVersion.getValue();
            List<Object> attFilePlanList = attFileFilePlanDyMap.get(boId);
            List<BillAttFileVersionPlanInfo> relationByAttFileVersionAndPlan = billAttFileService.getRelationByAttFileVersionAndPlan(attFileVersionList, attFilePlanList, scheduleEnum);
            result.put(boId, relationByAttFileVersionAndPlan);
        }
        return result;
    }

    public static boolean checkCanNotCalculate(WtcAbstractUnityBillOperator check, Long attFileBoId, Date startDate, Date endDate) {
        List<Tuple<DutyShift, Shift>> dutyShiftsRange = check.getDutyShiftsRange(attFileBoId, startDate, endDate);
        Boolean hasShift = false;
        if (WTCCollections.isNotEmpty(dutyShiftsRange)) {
            Optional<Tuple> startDateHasShift = dutyShiftsRange.stream().filter(ds -> WTCDateUtils.getDayStart((Date)startDate).getTime() == ((DutyShift)ds.item1).getRosterDate().getTime()).findAny();
            hasShift = startDateHasShift.isPresent();
        }
        return hasShift;
    }

    public static Map<Long, List<DynamicObject>> getAttFileVersionIdAndDy(WtcAbstractUnityBillOperator operator) {
        Map attFileVersionIdAndDyMap = operator.getInfoContext().getUnifyBillCommonInfo().getAttFileBoIdAndVersionDy();
        if (attFileVersionIdAndDyMap == null) {
            Set attFileBoIds = operator.getInfoContext().getBillResult().stream().map(UnifyBillResult::getAttFileBoId).collect(Collectors.toSet());
            AttFileQueryParam attFileQueryParamForVersion = new AttFileQueryParam();
            attFileQueryParamForVersion.setBeCurrent(Boolean.FALSE);
            attFileQueryParamForVersion.setSetBoIds(attFileBoIds);
            attFileQueryParamForVersion.setAuthCheck(Boolean.FALSE);
            attFileQueryParamForVersion.setAttStatus(null);
            List<DynamicObject> attFileVersionDys = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParamForVersion);
            if (WTCCollections.isEmpty(attFileVersionDys)) {
                operator.getInfoContext().getUnifyBillCommonInfo().setAttFileBoIdAndVersionDy(new HashMap(16));
            } else {
                Map<Long, List<DynamicObject>> groupByBoId = attFileVersionDys.stream().collect(Collectors.groupingBy(at -> WTCDynamicObjectUtils.getBaseDataId(at, "boid")));
                operator.getInfoContext().getUnifyBillCommonInfo().setAttFileBoIdAndVersionDy(groupByBoId);
            }
        }
        return operator.getInfoContext().getUnifyBillCommonInfo().getAttFileBoIdAndVersionDy();
    }
}

