/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.matchcore.afterrulecal;

import com.alibaba.fastjson.JSON;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.web.applybill.commonhelper.UnifyBillCommonHelper;
import kd.wtc.wtbs.business.web.applybill.matchcore.afterrulecal.AbstractUnifyARCService;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.business.web.billservice.attfile.BillAttFileService;
import kd.wtc.wtbs.business.web.evaluation.EvaluationServiceHelper;
import kd.wtc.wtbs.common.enums.bill.BaseSetUnitTypeEnum;
import kd.wtc.wtbs.common.enums.bill.UnifyCallChainEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBaseSetEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyAdvanceAndAfterDetail;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillAdvanceAfterInfo;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillDutyInfoResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillEntryResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillResult;
import kd.wtc.wtbs.common.model.evaluation.RosterRepairAndAdvance;
import kd.wtc.wtbs.common.model.period.PeriodBillCheckResult;
import kd.wtc.wtbs.common.util.WTCDateUtils;

public class UnifyARCAdvanceAndAfterService
extends AbstractUnifyARCService<Map<Date, UnifyBillAdvanceAfterInfo>> {
    private static final Log LOG = LogFactory.getLog(UnifyARCAdvanceAndAfterService.class);
    private Map<UnifyBillDutyInfoResult, PeriodBillCheckResult> dutyInfoAndPeriodMap = new HashMap<UnifyBillDutyInfoResult, PeriodBillCheckResult>(16);
    private Map<UnifyBillDutyInfoResult, RosterRepairAndAdvance> dutyInfoAndRosterMap = new HashMap<UnifyBillDutyInfoResult, RosterRepairAndAdvance>(16);
    private Map<RosterRepairAndAdvance, Integer> rosterAndOffset = new HashMap<RosterRepairAndAdvance, Integer>(16);

    public UnifyARCAdvanceAndAfterService(WtcAbstractUnityBillOperator operator) {
        super(operator);
    }

    @Override
    protected void matchProcess() {
        long costStart = System.currentTimeMillis();
        this.getAllPeriodCheckInfo();
        this.getWeekDayInfo();
        UnifyBillEnum unifyBillEnum = this.getOperator().getUnifyBillEnum();
        UnifyBaseSetEnum baseSetEnum = unifyBillEnum.getUnifyPlanEnum().getRuleEnum().getUnifyRuleCalEntryEnum().getBaseSetEnum();
        for (UnifyBillResult billServiceResult : this.getBillInfoContext().getBillResult()) {
            long attFileBoId = billServiceResult.getAttFileBoId();
            for (UnifyBillEntryResult billServiceEntryResult : billServiceResult.getEntryResultList()) {
                this.setAdvanceAndAfterToDutyInfo(baseSetEnum, billServiceEntryResult, attFileBoId);
            }
        }
        long costEnd = System.currentTimeMillis();
        LOG.info("UnifyARCAdvanceAndAfterService.matchProcess \u5355\u636e\u7edf\u4e00\u6027\u80fd\u8017\u65f6 costStart={},costEnd={},cost={}", new Object[]{costStart, costEnd, costEnd - costStart});
    }

    @Override
    protected UnifyCallChainEnum defineUnifyCallChainEnum() {
        return UnifyCallChainEnum.matchAdvanceAndAfter;
    }

    @Override
    protected Map<Date, UnifyBillAdvanceAfterInfo> getResult(long attFileBoId, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime, Long needMatchTypeId) {
        if (dutyDateQueryStartTime == null || dutyDateQueryEndTime == null) {
            return Collections.emptyMap();
        }
        List<UnifyBillDutyInfoResult> matchResult = UnifyBillCommonHelper.matchOneBillDutyDateInfo(attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime, needMatchTypeId, this.getBillInfoContext().getBillResult());
        if (matchResult != null) {
            return matchResult.stream().collect(LinkedHashMap::new, (m1, v1) -> m1.put(v1.getDutyDate(), v1.getAdvanceAfterCheckErrorInfo()), HashMap::putAll);
        }
        return Collections.emptyMap();
    }

    @Override
    protected Map<Date, UnifyBillAdvanceAfterInfo> getResult(long billId, int entryIndex) {
        List<UnifyBillDutyInfoResult> matchResult = UnifyBillCommonHelper.matchDutyInfoByBillIdAndIndex(billId, entryIndex, this.getBillInfoContext().getBillResult());
        if (matchResult != null) {
            return matchResult.stream().collect(LinkedHashMap::new, (m1, v1) -> m1.put(v1.getDutyDate(), v1.getAdvanceAfterCheckErrorInfo()), HashMap::putAll);
        }
        return Collections.emptyMap();
    }

    private void getAllPeriodCheckInfo() {
        Map<Long, List<UnifyBillDutyInfoResult>> invokeRegionMethodInfo = this.getInvokeRegionMethodInfo(BaseSetUnitTypeEnum.PERIOD);
        HashMap<Long, List<LocalDate>> dateListMap = new HashMap<Long, List<LocalDate>>(16);
        for (Map.Entry<Long, List<UnifyBillDutyInfoResult>> attFileAndInfo : invokeRegionMethodInfo.entrySet()) {
            Long attFileBoId = attFileAndInfo.getKey();
            List<UnifyBillDutyInfoResult> infoLists = attFileAndInfo.getValue();
            Long personId = this.getOperator().getPersonIdByAttFileBoId(attFileBoId);
            List localDates = dateListMap.computeIfAbsent(personId, val -> new ArrayList(10));
            for (UnifyBillDutyInfoResult dutyInfoResult : infoLists) {
                Date dutyDate = dutyInfoResult.getDutyDate();
                if (dutyDate == null || localDates.contains(WTCDateUtils.toLocalDate((Date)dutyDate))) continue;
                localDates.add(WTCDateUtils.toLocalDate((Date)dutyDate));
            }
        }
        Optional<PeriodBillCheckResult> periodBillCheckResultOptional = BillAttFileService.getInstance().getPerAttPeriods(dateListMap);
        PeriodBillCheckResult periodBillCheckResult = periodBillCheckResultOptional.orElse(null);
        for (Map.Entry<Long, List<UnifyBillDutyInfoResult>> attFileAndInfo : invokeRegionMethodInfo.entrySet()) {
            List<UnifyBillDutyInfoResult> infoLists = attFileAndInfo.getValue();
            for (UnifyBillDutyInfoResult dutyInfoResult : infoLists) {
                this.dutyInfoAndPeriodMap.put(dutyInfoResult, periodBillCheckResult);
            }
        }
        BillAttFileService.getQueryLog(dateListMap, LOG);
        BillAttFileService.getBillPeriodKeyInfoLog(periodBillCheckResult, LOG);
    }

    private void getWeekDayInfo() {
        Map<Long, List<UnifyBillDutyInfoResult>> invokeRegionMethodInfo = this.getInvokeRegionMethodInfo(BaseSetUnitTypeEnum.WEEKDAY);
        HashSet<RosterRepairAndAdvance> query = new HashSet<RosterRepairAndAdvance>(16);
        Date now = WTCDateUtils.getDayStartTime((Date)new Date());
        for (Map.Entry<Long, List<UnifyBillDutyInfoResult>> entry : invokeRegionMethodInfo.entrySet()) {
            List<UnifyBillDutyInfoResult> dutyInfoResults = entry.getValue();
            for (UnifyBillDutyInfoResult dutyInfoResult : dutyInfoResults) {
                RosterRepairAndAdvance repairParam = new RosterRepairAndAdvance();
                repairParam.setAttFileBoId(entry.getKey());
                repairParam.setBaselineDate(now);
                repairParam.setCompareDate(WTCDateUtils.getDayStartTime((Date)dutyInfoResult.getDutyDate()));
                query.add(repairParam);
                this.dutyInfoAndRosterMap.put(dutyInfoResult, repairParam);
            }
        }
        this.rosterAndOffset = EvaluationServiceHelper.getWorkDaysBetween2Date(query);
        Map<Object, Object> map = this.rosterAndOffset = this.rosterAndOffset == null ? Collections.emptyMap() : this.rosterAndOffset;
        if (LOG.isInfoEnabled()) {
            LOG.info("UnifyARCAdvanceAndAfterService.getWeekDayInfo rosterAndOffset = {}", (Object)JSON.toJSONString(this.rosterAndOffset));
        }
    }

    private Map<Long, List<UnifyBillDutyInfoResult>> getInvokeRegionMethodInfo(BaseSetUnitTypeEnum unitTypeEnum) {
        HashMap<Long, List<UnifyBillDutyInfoResult>> attFileBoIdAndDutyInfo = new HashMap<Long, List<UnifyBillDutyInfoResult>>(16);
        for (UnifyBillResult billServiceResult : this.getBillInfoContext().getBillResult()) {
            long attFileBoId = billServiceResult.getAttFileBoId();
            List unifyBillDutyInfoResults = attFileBoIdAndDutyInfo.computeIfAbsent(attFileBoId, val -> new ArrayList(10));
            for (UnifyBillEntryResult billServiceEntryResult : billServiceResult.getEntryResultList()) {
                boolean checkNeedQueryRegion = this.checkNeedQueryRegion(billServiceEntryResult, unitTypeEnum);
                if (!checkNeedQueryRegion) continue;
                unifyBillDutyInfoResults.addAll(billServiceEntryResult.getDutyInfos());
            }
        }
        return attFileBoIdAndDutyInfo;
    }

    private boolean checkNeedQueryRegion(UnifyBillEntryResult billServiceEntryResult, BaseSetUnitTypeEnum unitTypeEnum) {
        List<UnifyBillDutyInfoResult> invokeRegionMethodInfo1 = this.getInvokeRegionMethodInfo_1(billServiceEntryResult, unitTypeEnum);
        return invokeRegionMethodInfo1.size() > 0;
    }

    private List<UnifyBillDutyInfoResult> getInvokeRegionMethodInfo_1(UnifyBillEntryResult billServiceEntryResult, BaseSetUnitTypeEnum unitTypeEnum) {
        UnifyBaseSetEnum baseSetEnum = this.getOperator().getUnifyBillEnum().getUnifyPlanEnum().getRuleEnum().getUnifyRuleCalEntryEnum().getBaseSetEnum();
        ArrayList<UnifyBillDutyInfoResult> data = new ArrayList<UnifyBillDutyInfoResult>(10);
        for (UnifyBillDutyInfoResult dutyInfo : billServiceEntryResult.getDutyInfos()) {
            DynamicObject baseSet = dutyInfo.getMatchBaseSet();
            if (baseSet == null || !unitTypeEnum.getCode().equals(baseSet.get(baseSetEnum.getFieldAdvanceUnitInBaseSet())) && !unitTypeEnum.getCode().equals(baseSet.get(baseSetEnum.getFieldAfterUnitInBaseSet()))) continue;
            data.add(dutyInfo);
        }
        return data;
    }

    private void setAdvanceAndAfterToDutyInfo(UnifyBaseSetEnum baseSetEnum, UnifyBillEntryResult billServiceEntryResult, long attFileBoId) {
        for (UnifyBillDutyInfoResult dutyInfo : billServiceEntryResult.getDutyInfos()) {
            DynamicObject baseSetDy = dutyInfo.getMatchBaseSet();
            if (baseSetDy == null) continue;
            boolean advanceNeed = baseSetDy.getBoolean(baseSetEnum.getFieldAdvanceNeedInBaseSet());
            String advanceUnit = baseSetDy.getString(baseSetEnum.getFieldAdvanceUnitInBaseSet());
            Object advanceNumberObj = baseSetDy.get(baseSetEnum.getFieldAdvanceNumberInBaseSet());
            Integer advanceNumber = advanceNumberObj == null ? Integer.valueOf(0) : (Integer)advanceNumberObj;
            UnifyBillAdvanceAfterInfo advanceAfterInfo = new UnifyBillAdvanceAfterInfo();
            advanceAfterInfo.setPeriodBillCheckResult(this.dutyInfoAndPeriodMap.get(dutyInfo));
            advanceAfterInfo.setPersonId(Long.valueOf(this.getOperator().getPersonIdByAttFileBoId(attFileBoId)));
            RosterRepairAndAdvance rosterRepairAndAdvance = this.dutyInfoAndRosterMap.get(dutyInfo);
            advanceAfterInfo.setWeekDayOffSet(this.rosterAndOffset.get(rosterRepairAndAdvance));
            this.matchAdvanceInfo(advanceAfterInfo, dutyInfo, advanceNeed, advanceUnit, advanceNumber);
            boolean afterNeed = baseSetDy.getBoolean(baseSetEnum.getFieldAfterNeedInBaseSet());
            String afterUnit = baseSetDy.getString(baseSetEnum.getFieldAfterUnitInBaseSet());
            Object afterNumberObj = baseSetDy.get(baseSetEnum.getFieldAfterNumberInBaseSet());
            Integer afterNumber = afterNumberObj == null ? Integer.valueOf(0) : (Integer)afterNumberObj;
            this.matchAfterInfo(advanceAfterInfo, dutyInfo, afterNeed, afterUnit, afterNumber);
            dutyInfo.setAdvanceAfterCheckInfo(advanceAfterInfo);
        }
    }

    private void matchAdvanceInfo(UnifyBillAdvanceAfterInfo billAdvanceAfterInfo, UnifyBillDutyInfoResult billDutyDateInfo, boolean need, String unit, Integer advanceNumber) {
        UnifyAdvanceAndAfterDetail unifyAdvanceAndAfterDetail = new UnifyAdvanceAndAfterDetail();
        unifyAdvanceAndAfterDetail.setNeedVerify(need);
        unifyAdvanceAndAfterDetail.setAdvanceAfterUnit(unit);
        unifyAdvanceAndAfterDetail.setAdvanceAfterNum(advanceNumber);
        if (!need) {
            billAdvanceAfterInfo.setPassAdvance(Boolean.valueOf(true));
            billAdvanceAfterInfo.setAdvanceInfo(unifyAdvanceAndAfterDetail);
            return;
        }
        Boolean verifyResult = true;
        if (HRStringUtils.equals((String)BaseSetUnitTypeEnum.DAY.getCode(), (String)unit)) {
            Date today = WTCDateUtils.getDayStartTime((Date)new Date());
            Date dutyDate = WTCDateUtils.getDayStartTime((Date)billDutyDateInfo.getDutyDate());
            int days = (int)((dutyDate.getTime() - today.getTime()) / 86400000L);
            verifyResult = days >= advanceNumber;
        } else if (HRStringUtils.equals((String)BaseSetUnitTypeEnum.PERIOD.getCode(), (String)unit)) {
            verifyResult = null;
        } else if (HRStringUtils.equals((String)BaseSetUnitTypeEnum.WEEKDAY.getCode(), (String)unit)) {
            verifyResult = this.verifyWeekDay(this.dutyInfoAndRosterMap.get(billDutyDateInfo), advanceNumber, true);
        }
        billAdvanceAfterInfo.setPassAdvance(verifyResult);
        billAdvanceAfterInfo.setAdvanceInfo(unifyAdvanceAndAfterDetail);
    }

    private void matchAfterInfo(UnifyBillAdvanceAfterInfo billAdvanceAfterInfo, UnifyBillDutyInfoResult billDutyDateInfo, boolean need, String unit, Integer afterNumber) {
        UnifyAdvanceAndAfterDetail unifyAdvanceAndAfterDetail = new UnifyAdvanceAndAfterDetail();
        unifyAdvanceAndAfterDetail.setNeedVerify(need);
        if (!need) {
            billAdvanceAfterInfo.setPassAfter(Boolean.valueOf(true));
            billAdvanceAfterInfo.setAfterInfo(unifyAdvanceAndAfterDetail);
            return;
        }
        Boolean verifyResult = true;
        Date today = WTCDateUtils.getDayStartTime((Date)new Date());
        Date dutyDate = WTCDateUtils.getDayStartTime((Date)billDutyDateInfo.getDutyDate());
        if (HRStringUtils.equals((String)unit, (String)BaseSetUnitTypeEnum.DAY.getCode()) && today.compareTo(dutyDate) != 0) {
            int days = (int)((today.getTime() - dutyDate.getTime()) / 86400000L);
            verifyResult = days <= afterNumber;
        } else if (HRStringUtils.equals((String)unit, (String)BaseSetUnitTypeEnum.PERIOD.getCode())) {
            verifyResult = null;
        } else if (HRStringUtils.equals((String)BaseSetUnitTypeEnum.WEEKDAY.getCode(), (String)unit) && today.compareTo(dutyDate) != 0) {
            verifyResult = this.verifyWeekDay(this.dutyInfoAndRosterMap.get(billDutyDateInfo), afterNumber, false);
        }
        billAdvanceAfterInfo.setPassAfter(verifyResult);
        unifyAdvanceAndAfterDetail.setAdvanceAfterUnit(unit);
        unifyAdvanceAndAfterDetail.setAdvanceAfterNum(afterNumber);
        billAdvanceAfterInfo.setAfterInfo(unifyAdvanceAndAfterDetail);
    }

    private boolean verifyWeekDay(RosterRepairAndAdvance rosterRepairAndAdvance, Integer offsetNumber, boolean ifAdvance) {
        if (LOG.isInfoEnabled()) {
            LOG.info("UnifyARCAdvanceAndAfterService.verifyWeekDay rosterRepairAndAdvance = {},offsetNumber={},ifAdvance={}", new Object[]{JSON.toJSONString((Object)rosterRepairAndAdvance), offsetNumber, ifAdvance});
        }
        if (rosterRepairAndAdvance != null) {
            if (ifAdvance) {
                return offsetNumber <= this.rosterAndOffset.get(rosterRepairAndAdvance);
            }
            return -offsetNumber.intValue() <= this.rosterAndOffset.get(rosterRepairAndAdvance);
        }
        LOG.error("UnifyARCAdvanceAndAfterService.verifyWeekDay \u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u5de5\u4f5c\u65e5\u8fd4\u56de");
        throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u5de5\u4f5c\u65e5\u8fd4\u56de", (String)"UnifyARCAdvanceAndAfterService_1", (String)"wtc-wtbs-business", (Object[])new Object[0]));
    }
}

