/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.matchcore.afterrulecal;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.wtc.wtbs.business.web.applybill.commonhelper.UnifyBillCommonHelper;
import kd.wtc.wtbs.business.web.applybill.matchcore.afterrulecal.AbstractUnifyARCService;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.common.enums.bill.UnifyCallChainEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBaseSetEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyRuleCalEntryEnum;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillDutyInfoResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillEntryResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillResult;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class UnifyARCBaseSetService
extends AbstractUnifyARCService<Map<Date, DynamicObject>> {
    private static final Log LOG = LogFactory.getLog(UnifyARCBaseSetService.class);

    public UnifyARCBaseSetService(WtcAbstractUnityBillOperator operator) {
        super(operator);
    }

    @Override
    protected void matchProcess() {
        long costStart = System.currentTimeMillis();
        HashSet boIds = Sets.newHashSetWithExpectedSize((int)16);
        for (UnifyBillResult billServiceResult : this.getBillInfoContext().getBillResult()) {
            this.getBaseSetBoIdsByRule(boIds, billServiceResult);
        }
        UnifyBaseSetEnum baseSetEnum = this.getOperator().getUnifyBillEnum().getUnifyPlanEnum().getRuleEnum().getUnifyRuleCalEntryEnum().getBaseSetEnum();
        DynamicObject[] allSetDys = UnifyBillCommonHelper.getAllSeqHisDys(baseSetEnum.getEntityNumber(), this.getBillInfoContext().getUnifyBillCommonInfo().getMinDate(), this.getBillInfoContext().getUnifyBillCommonInfo().getMaxDate(), boIds);
        this.matchToBillBaseByBaseSetList(allSetDys);
        long costEnd = System.currentTimeMillis();
        LOG.info("UnifyARCBaseSetService.matchProcess \u5355\u636e\u7edf\u4e00\u6027\u80fd\u8017\u65f6 costStart={},costEnd={},cost={}", new Object[]{costStart, costEnd, costEnd - costStart});
    }

    @Override
    protected UnifyCallChainEnum defineUnifyCallChainEnum() {
        return UnifyCallChainEnum.matchBaseSetInfo;
    }

    @Override
    protected Map<Date, DynamicObject> getResult(long attFileBoId, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime, Long needMatchTypeId) {
        List<UnifyBillDutyInfoResult> matchResult = UnifyBillCommonHelper.matchOneBillDutyDateInfo(attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime, needMatchTypeId, this.getBillInfoContext().getBillResult());
        if (matchResult != null) {
            return matchResult.stream().collect(LinkedHashMap::new, (m1, v1) -> m1.put(v1.getDutyDate(), v1.getMatchBaseSet()), HashMap::putAll);
        }
        return Collections.emptyMap();
    }

    @Override
    protected Map<Date, DynamicObject> getResult(long billId, int entryIndex) {
        List<UnifyBillDutyInfoResult> matchResult = UnifyBillCommonHelper.matchDutyInfoByBillIdAndIndex(billId, entryIndex, this.getBillInfoContext().getBillResult());
        if (matchResult != null) {
            return matchResult.stream().collect(LinkedHashMap::new, (m1, v1) -> m1.put(v1.getDutyDate(), v1.getMatchBaseSet()), HashMap::putAll);
        }
        return Collections.emptyMap();
    }

    private void getBaseSetBoIdsByRule(Set<Long> boIds, UnifyBillResult billServiceResult) {
        UnifyRuleCalEntryEnum ruleCalEntryEnum = this.getOperator().getUnifyBillEnum().getUnifyPlanEnum().getRuleEnum().getUnifyRuleCalEntryEnum();
        for (UnifyBillEntryResult billServiceEntryResult : billServiceResult.getEntryResultList()) {
            for (UnifyBillDutyInfoResult dutyInfo : billServiceEntryResult.getDutyInfos()) {
                DynamicObject ruleDy = dutyInfo.getMatchRuleCalDy();
                if (ruleDy == null) continue;
                boIds.add(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)ruleDy, (String)ruleCalEntryEnum.getBaseSet()));
            }
        }
    }

    private void matchToBillBaseByBaseSetList(DynamicObject[] allBaseSetArr) {
        for (UnifyBillResult billServiceResult : this.getBillInfoContext().getBillResult()) {
            for (UnifyBillEntryResult entryResult : billServiceResult.getEntryResultList()) {
                this.setBaseSetToDutyInfo(allBaseSetArr, entryResult);
            }
        }
    }

    private void setBaseSetToDutyInfo(DynamicObject[] allBaseSetArr, UnifyBillEntryResult entryResult) {
        UnifyRuleCalEntryEnum ruleCalEntryEnum = this.getOperator().getUnifyBillEnum().getUnifyPlanEnum().getRuleEnum().getUnifyRuleCalEntryEnum();
        for (UnifyBillDutyInfoResult dutyInfo : entryResult.getDutyInfos()) {
            DynamicObject ruleEntryDy = dutyInfo.getMatchRuleCalDy();
            if (ruleEntryDy == null) continue;
            long typeIdFromRule = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)ruleEntryDy, (String)ruleCalEntryEnum.getBaseSet());
            Date queryDate = dutyInfo.getDutyDate();
            if (typeIdFromRule == 0L) continue;
            DynamicObject baseSet = UnifyBillCommonHelper.getSeqHisDyByDate(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)ruleEntryDy, (String)ruleCalEntryEnum.getBaseSet()), queryDate, Lists.newArrayList((Object[])allBaseSetArr));
            dutyInfo.setMatchBaseSet(baseSet);
        }
    }
}

