/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.matchcore.afterrulecal;

import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.wtc.wtbs.business.web.applybill.commonhelper.UnifyBillCommonHelper;
import kd.wtc.wtbs.business.web.applybill.matchcore.afterrulecal.AbstractUnifyARCService;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.common.enums.bill.UnifyCallChainEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyChangeSetEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyRuleCalEntryEnum;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillDutyInfoResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillEntryResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillResult;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class UnifyARCChangeSetService
extends AbstractUnifyARCService<Map<Date, DynamicObject>> {
    private static final Log LOG = LogFactory.getLog(UnifyARCChangeSetService.class);

    public UnifyARCChangeSetService(WtcAbstractUnityBillOperator operator) {
        super(operator);
    }

    @Override
    protected void matchProcess() {
        long costStart = System.currentTimeMillis();
        HashSet boIds = Sets.newHashSetWithExpectedSize((int)10);
        for (UnifyBillResult billServiceResult : this.getBillInfoContext().getBillResult()) {
            this.getChangeSetBoId(boIds, billServiceResult);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("WtcApplyBillMatchResultHelper.matchChangeSetInfo> \u5339\u914d\u53d8\u66f4\u914d\u7f6e\uff0cboid\u96c6\u5408\u4e3a{}", (Object)JSON.toJSONString((Object)boIds));
        }
        UnifyChangeSetEnum changeSetEnum = this.getOperator().getUnifyBillEnum().getUnifyPlanEnum().getRuleEnum().getUnifyRuleCalEntryEnum().getChangeSetEnum();
        DynamicObject[] allSetDys = UnifyBillCommonHelper.getAllSeqHisDys(changeSetEnum.getEntityNumber(), this.getBillInfoContext().getUnifyBillCommonInfo().getMinDate(), this.getBillInfoContext().getUnifyBillCommonInfo().getMaxDate(), boIds);
        this.matchToBillBaseByChangeSetList(allSetDys);
        long costEnd = System.currentTimeMillis();
        LOG.info("UnifyARCChangeSetService.matchProcess \u5355\u636e\u7edf\u4e00\u6027\u80fd\u8017\u65f6 costStart={},costEnd={},cost={}", new Object[]{costStart, costEnd, costEnd - costStart});
    }

    @Override
    protected UnifyCallChainEnum defineUnifyCallChainEnum() {
        return UnifyCallChainEnum.matchChangeSetInfo;
    }

    @Override
    protected Map<Date, DynamicObject> getResult(long attFileBoId, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime, Long needMatchTypeId) {
        List<UnifyBillDutyInfoResult> matchResult = UnifyBillCommonHelper.matchOneBillDutyDateInfo(attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime, needMatchTypeId, this.getBillInfoContext().getBillResult());
        if (matchResult != null) {
            return matchResult.stream().collect(LinkedHashMap::new, (m1, v1) -> m1.put(v1.getDutyDate(), v1.getMatchChangeSet()), HashMap::putAll);
        }
        return Collections.emptyMap();
    }

    @Override
    protected Map<Date, DynamicObject> getResult(long billId, int entryIndex) {
        List<UnifyBillDutyInfoResult> matchResult = UnifyBillCommonHelper.matchDutyInfoByBillIdAndIndex(billId, entryIndex, this.getBillInfoContext().getBillResult());
        if (matchResult != null) {
            return matchResult.stream().collect(LinkedHashMap::new, (m1, v1) -> m1.put(v1.getDutyDate(), v1.getMatchChangeSet()), HashMap::putAll);
        }
        return Collections.emptyMap();
    }

    private void getChangeSetBoId(Set<Long> boIds, UnifyBillResult billServiceResult) {
        UnifyRuleCalEntryEnum unifyRuleCalEntryEnum = this.getOperator().getUnifyBillEnum().getUnifyPlanEnum().getRuleEnum().getUnifyRuleCalEntryEnum();
        for (UnifyBillEntryResult billServiceEntryResult : billServiceResult.getEntryResultList()) {
            for (UnifyBillDutyInfoResult dutyInfo : billServiceEntryResult.getDutyInfos()) {
                DynamicObject ruleEntryDy = dutyInfo.getMatchRuleCalDy();
                if (ruleEntryDy == null) continue;
                boIds.add(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)ruleEntryDy, (String)unifyRuleCalEntryEnum.getFieldChangeSetInRule()));
            }
        }
    }

    private void matchToBillBaseByChangeSetList(DynamicObject[] allBaseSetArr) {
        for (UnifyBillResult billServiceResult : this.getBillInfoContext().getBillResult()) {
            for (UnifyBillEntryResult entryResult : billServiceResult.getEntryResultList()) {
                this.setChangeSetToDutyInfo(allBaseSetArr, entryResult);
            }
        }
    }

    private void setChangeSetToDutyInfo(DynamicObject[] allBaseSetArr, UnifyBillEntryResult entryResult) {
        UnifyRuleCalEntryEnum unifyRuleCalEntryEnum = this.getOperator().getUnifyBillEnum().getUnifyPlanEnum().getRuleEnum().getUnifyRuleCalEntryEnum();
        for (UnifyBillDutyInfoResult dutyInfo : entryResult.getDutyInfos()) {
            DynamicObject ruleEntryDy = dutyInfo.getMatchRuleCalDy();
            if (ruleEntryDy == null) continue;
            long typeIdFromRule = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)ruleEntryDy, (String)unifyRuleCalEntryEnum.getFieldChangeSetInRule());
            Date queryDate = dutyInfo.getDutyDate();
            if (typeIdFromRule == 0L) continue;
            DynamicObject baseSet = UnifyBillCommonHelper.getSeqHisDyByDate(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)ruleEntryDy, (String)unifyRuleCalEntryEnum.getFieldChangeSetInRule()), queryDate, Lists.newArrayList((Object[])allBaseSetArr));
            dutyInfo.setMatchChangeSet(baseSet);
        }
    }
}

