/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.matchcore.afterrulecal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.sdk.wtc.wtbs.business.limitcond.OnLimitConditionExpPlugin;
import kd.wtc.wtbs.business.bill.AttfileLimitScopeServiceImpl;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.rulecondition.RuleConditionRetrieval;
import kd.wtc.wtbs.business.rulecondition.bill.RuleConditionBillLimitDto;
import kd.wtc.wtbs.business.rulecondition.bill.RuleConditionBillMatchService;
import kd.wtc.wtbs.business.rulecondition.bill.RuleConditionCommonService;
import kd.wtc.wtbs.business.rulecontrol.ConditionValidateService;
import kd.wtc.wtbs.business.util.ext.LimitConditionExpBundle;
import kd.wtc.wtbs.business.web.applybill.commonhelper.UnifyBillCommonHelper;
import kd.wtc.wtbs.business.web.applybill.matchcore.afterrulecal.AbstractUnifyARCService;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.common.enums.bill.UnifyCallChainEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyRuleCalEntryEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyRuleEnum;
import kd.wtc.wtbs.common.model.bill.unifybill.MatchRuleCal;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillDutyInfoResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillEntryResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillResult;

public class UnifyARCRuleCalService
extends AbstractUnifyARCService<Map<Date, DynamicObject>> {
    private static final Log LOG = LogFactory.getLog(UnifyARCRuleCalService.class);
    private Map<UnifyBillDutyInfoResult, List<MatchRuleCal>> ruleCalIdAndMatchRuleCalMap = new HashMap<UnifyBillDutyInfoResult, List<MatchRuleCal>>(16);

    public UnifyARCRuleCalService(WtcAbstractUnityBillOperator operator) {
        super(operator);
    }

    @Override
    protected void matchProcess() {
        ArrayList<MatchRuleCal> matchRuleCalLists = new ArrayList<MatchRuleCal>(10);
        for (UnifyBillResult billResult : this.getBillInfoContext().getBillResult()) {
            List entryResultList = billResult.getEntryResultList();
            for (Object unifyBillEntryResult : entryResultList) {
                long type = unifyBillEntryResult.getNeedMatchTypeId();
                matchRuleCalLists.addAll(this.getMatchRuleCal(type, unifyBillEntryResult.getDutyInfos(), billResult, (UnifyBillEntryResult)unifyBillEntryResult));
            }
        }
        List dyPk = matchRuleCalLists.stream().map(m -> {
            if (m.getAttFileVersionDy() != null) {
                return m.getAttFileVersionDy().getPkValue();
            }
            return 0L;
        }).collect(Collectors.toList());
        if (this.getBillInfoContext().getBillType() == UnifyBillEnum.OT) {
            RuleConditionBillLimitDto billLimitDto = new RuleConditionBillLimitDto();
            billLimitDto.setMatchRuleCalLists(matchRuleCalLists);
            billLimitDto.setRuleCalIdAndMatchRuleCalMap(this.ruleCalIdAndMatchRuleCalMap);
            billLimitDto.setUnifyBillInfoContext(this.getBillInfoContext());
            List<RuleConditionRetrieval> ruleConditionRetrievals = RuleConditionBillMatchService.billLimitMatch(billLimitDto);
            Map retrievalMap = ruleConditionRetrievals.stream().collect(Collectors.toMap(RuleConditionRetrieval::getDimensionKey, Function.identity(), (o1, o2) -> o2));
            for (UnifyBillResult billResult : this.getBillInfoContext().getBillResult()) {
                List entryResultList = billResult.getEntryResultList();
                for (UnifyBillEntryResult unifyBillEntryResult : entryResultList) {
                    block4: for (UnifyBillDutyInfoResult dutyInfoResult : unifyBillEntryResult.getDutyInfos()) {
                        List<MatchRuleCal> matchRuleCals = this.ruleCalIdAndMatchRuleCalMap.get(dutyInfoResult);
                        for (MatchRuleCal matchRuleCal : matchRuleCals) {
                            RuleConditionRetrieval conditionRetrieval = (RuleConditionRetrieval)retrievalMap.get(matchRuleCal.getDimensionKey());
                            if (conditionRetrieval == null || !conditionRetrieval.isMatchResult()) continue;
                            dutyInfoResult.setMatchRuleCalDy(matchRuleCal.getMatchRuleCalDy());
                            continue block4;
                        }
                    }
                }
            }
        } else {
            List ruleCalTypeId = matchRuleCalLists.stream().map(MatchRuleCal::getRuleCalTypeId).collect(Collectors.toList());
            List calCulDes = matchRuleCalLists.stream().map(MatchRuleCal::getCalCulDes).collect(Collectors.toList());
            List needMatchTypeId = matchRuleCalLists.stream().map(MatchRuleCal::getNeedMatchTypeId).collect(Collectors.toList());
            if (LOG.isDebugEnabled()) {
                LOG.debug("UnifyARCRuleCalService.matchProcess dyPk={},ruleCalTypeId={},calCulDes={},needMatchTypeId={}", new Object[]{dyPk, ruleCalTypeId, calCulDes, needMatchTypeId});
            }
            AttfileLimitScopeServiceImpl service = new AttfileLimitScopeServiceImpl();
            WTCPluginProxy<OnLimitConditionExpPlugin> pluginProxy = WTCPluginProxyFactory.create(OnLimitConditionExpPlugin.class, "kd.sdk.wtc.wtbs.business.limitcond.OnLimitConditionExpPlugin");
            LimitConditionExpBundle dataBundle = new LimitConditionExpBundle(String.valueOf(this.getOperator().getUnifyBillEnum()), pluginProxy, null);
            Map<MatchRuleCal, Boolean> matchRuleCalResult = service.matchRuleCal(matchRuleCalLists, dataBundle);
            for (UnifyBillResult billResult : this.getBillInfoContext().getBillResult()) {
                List entryResultList = billResult.getEntryResultList();
                for (UnifyBillEntryResult unifyBillEntryResult : entryResultList) {
                    this.matchRuleCal(unifyBillEntryResult, matchRuleCalResult);
                }
            }
        }
    }

    @Override
    protected UnifyCallChainEnum defineUnifyCallChainEnum() {
        return UnifyCallChainEnum.matchRuleCalInfo;
    }

    @Override
    protected Map<Date, DynamicObject> getResult(long attFileBoId, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime, Long needMatchTypeId) {
        List<UnifyBillDutyInfoResult> matchResult = UnifyBillCommonHelper.matchOneBillDutyDateInfo(attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime, needMatchTypeId, this.getBillInfoContext().getBillResult());
        if (matchResult != null) {
            return matchResult.stream().collect(LinkedHashMap::new, (m1, v1) -> m1.put(v1.getDutyDate(), v1.getMatchRuleCalDy()), HashMap::putAll);
        }
        return Collections.emptyMap();
    }

    @Override
    protected Map<Date, DynamicObject> getResult(long billId, int entryIndex) {
        List<UnifyBillDutyInfoResult> matchResult = UnifyBillCommonHelper.matchDutyInfoByBillIdAndIndex(billId, entryIndex, this.getBillInfoContext().getBillResult());
        if (matchResult != null) {
            return matchResult.stream().collect(LinkedHashMap::new, (m1, v1) -> m1.put(v1.getDutyDate(), v1.getMatchRuleCalDy()), HashMap::putAll);
        }
        return Collections.emptyMap();
    }

    private void matchRuleCal(UnifyBillEntryResult unifyBillEntryResult, Map<MatchRuleCal, Boolean> matchRuleCalResult) {
        UnifyRuleEnum ruleEnum = this.getOperator().getUnifyBillEnum().getUnifyPlanEnum().getRuleEnum();
        UnifyRuleCalEntryEnum unifyRuleCalEntryEnum = ruleEnum.getUnifyRuleCalEntryEnum();
        for (UnifyBillDutyInfoResult dutyInfo : unifyBillEntryResult.getDutyInfos()) {
            List<MatchRuleCal> matchRuleCalList = this.ruleCalIdAndMatchRuleCalMap.get(dutyInfo);
            if (CollectionUtils.isEmpty(matchRuleCalList)) continue;
            for (MatchRuleCal matchRuleCal : matchRuleCalList) {
                Boolean match;
                if (matchRuleCal == null || matchRuleCal.getNeedMatchTypeId() == null || matchRuleCal.getNeedMatchTypeId() == 0L || (match = matchRuleCalResult.get(matchRuleCal)) == null || !match.booleanValue()) continue;
                dutyInfo.setMatchRuleCalDy(matchRuleCal.getMatchRuleCalDy());
                break;
            }
            for (MatchRuleCal matchRuleCal : matchRuleCalList) {
                DynamicObject matchRuleCalDy;
                if (matchRuleCal == null || (matchRuleCalDy = matchRuleCal.getMatchRuleCalDy()) == null) continue;
                dutyInfo.addRuleCalId(Long.valueOf(matchRuleCalDy.getLong(unifyRuleCalEntryEnum.getType() + ".id")));
            }
        }
    }

    private List<MatchRuleCal> getMatchRuleCal(long needMatchTypeId, List<UnifyBillDutyInfoResult> dutyInfos, UnifyBillResult billResult, UnifyBillEntryResult unifyBillEntryResult) {
        ArrayList<MatchRuleCal> result = new ArrayList<MatchRuleCal>(10);
        for (UnifyBillDutyInfoResult dutyInfo : dutyInfos) {
            DynamicObject attFileVersion = dutyInfo.getAttFileVersion();
            if (attFileVersion == null) {
                this.ruleCalIdAndMatchRuleCalMap.put(dutyInfo, Collections.emptyList());
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("UnifyARCRuleCalService.getMatchRuleCal attFileVersion is null dutyInfo.getDutyDate() = {}", (Object)dutyInfo.getDutyDate());
                continue;
            }
            DynamicObject matchRuleDy = dutyInfo.getMatchRuleDy();
            List<MatchRuleCal> calByRule = this.getCalByRule(dutyInfo, attFileVersion, needMatchTypeId, matchRuleDy, billResult, unifyBillEntryResult);
            result.addAll(calByRule);
        }
        return result;
    }

    private List<MatchRuleCal> getCalByRule(UnifyBillDutyInfoResult dutyInfoResult, DynamicObject attFileVersion, long needMatchTypeId, DynamicObject matchRuleDy, UnifyBillResult billResult, UnifyBillEntryResult unifyBillEntryResult) {
        ArrayList<MatchRuleCal> result = new ArrayList<MatchRuleCal>(10);
        if (matchRuleDy == null) {
            this.ruleCalIdAndMatchRuleCalMap.put(dutyInfoResult, result);
            if (LOG.isDebugEnabled()) {
                LOG.debug("UnifyARCRuleCalService.getCalByRule matchRule is null");
            }
            return result;
        }
        String billEntrySeqKey = RuleConditionCommonService.getBillEntrySeqKey(billResult.getBillDy(), unifyBillEntryResult.getEntryKey(), unifyBillEntryResult.getEntryIndex());
        UnifyRuleEnum ruleEnum = this.getOperator().getUnifyBillEnum().getUnifyPlanEnum().getRuleEnum();
        UnifyRuleCalEntryEnum unifyRuleCalEntryEnum = ruleEnum.getUnifyRuleCalEntryEnum();
        DynamicObjectCollection entries = matchRuleDy.getDynamicObjectCollection(ruleEnum.getCalEntry());
        for (DynamicObject entry : entries) {
            long type = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)entry, (String)unifyRuleCalEntryEnum.getType());
            MatchRuleCal matchRuleCal = new MatchRuleCal();
            matchRuleCal.setAttFileVersionDy(attFileVersion);
            String calCulDes = entry.getString(unifyRuleCalEntryEnum.getCalCulDes());
            matchRuleCal.setCalCulDes(calCulDes);
            matchRuleCal.setAccessDto((Object)ConditionValidateService.getRuleConditionInfo(calCulDes));
            matchRuleCal.setNeedMatchTypeId(Long.valueOf(needMatchTypeId));
            matchRuleCal.setRuleCalTypeId(type);
            matchRuleCal.setMatchRuleCalDy(entry);
            long calEntryId = entry.getLong("id");
            matchRuleCal.setDimensionKey(billEntrySeqKey + "_" + calEntryId);
            result.add(matchRuleCal);
        }
        this.ruleCalIdAndMatchRuleCalMap.put(dutyInfoResult, result);
        return result;
    }
}

