/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.matchcore.attfile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.wtc.wtbs.business.web.applybill.matchcore.attfile.AbstractUnifyAttFileService;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.enums.bill.UnifyCallChainEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillResult;
import kd.wtc.wtbs.common.util.WTCStringUtils;

public class UnifyAttFileAllVersionService
extends AbstractUnifyAttFileService<List<DynamicObject>> {
    private static final Log LOG = LogFactory.getLog(UnifyAttFileAllVersionService.class);

    public UnifyAttFileAllVersionService(WtcAbstractUnityBillOperator operator) {
        super(operator);
    }

    @Override
    protected void matchProcess() {
        Set<Long> attFileBoIds = this.getBillInfoContext().getBillResult().stream().map(UnifyBillResult::getAttFileBoId).collect(Collectors.toSet());
        List<DynamicObject> attFileVersionList = AttFileQueryServiceImpl.getInstance().queryAttFiles(this.getAttFileQuery(attFileBoIds));
        LOG.info("UnifyAttFileAllVersionService.matchProcess attFileVersionList.size = {}", (Object)attFileVersionList.size());
        this.setAttFileAllVersion(attFileVersionList);
    }

    private AttFileQueryParam getAttFileQuery(Set<Long> attFileBoIdSet) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setBeCurrent(Boolean.FALSE);
        attFileQueryParam.setAttStatus(null);
        attFileQueryParam.setSetBoIds(attFileBoIdSet);
        attFileQueryParam.setProperties(WTCStringUtils.joinOnComma((String[])new String[]{"attperson", "id", "boid", "atttag.attendstatus", "startdate", "bsed", "enddate", "bsled", "firstbsed", "attperson.gender.id", "attperson.beginservicedate", "attperson.entrydate", "attperson.laborrelstatus.id", "attperson.joblevel.id", "attperson.jobgrade.id", "attperson.jobhr.jobseq.id", "attperson.regulardate", "workplace.id", "dependencytype.id", "person.id", "employee.id", "depemp.id", "dependency.id", "empgroup.id", "org.id", "affiliateadminorg.id", "empposorgrel", "empposorgrel.datastatus", "adminorg.id"}));
        return attFileQueryParam;
    }

    private void setAttFileAllVersion(List<DynamicObject> allAttFileVersionList) {
        List billResult = this.getBillInfoContext().getBillResult();
        for (UnifyBillResult unifyBillResult : billResult) {
            ArrayList<DynamicObject> attFileVersionList = new ArrayList<DynamicObject>(10);
            for (DynamicObject attFileVersion : allAttFileVersionList) {
                long boIdFromDB = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)attFileVersion, (String)"boid");
                if (unifyBillResult.getAttFileBoId() != boIdFromDB) continue;
                attFileVersionList.add(attFileVersion);
            }
            unifyBillResult.setAllAttFileVersion(attFileVersionList);
        }
    }

    @Override
    protected UnifyCallChainEnum defineUnifyCallChainEnum() {
        return UnifyCallChainEnum.matchAttFileAllVersion;
    }

    @Override
    protected List<DynamicObject> getResult(long attFileBoId) {
        for (UnifyBillResult billServiceResult : this.getBillInfoContext().getBillResult()) {
            if (attFileBoId != billServiceResult.getAttFileBoId()) continue;
            return billServiceResult.getAllAttFileVersion();
        }
        return Collections.emptyList();
    }
}

