/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.matchcore.attfile;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.web.applybill.matchcore.attfile.AbstractUnifyAttFileService;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.enums.bill.UnifyCallChainEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileF7QueryParam;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillInfoContext;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillResult;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class UnifyAttFileAuthService
extends AbstractUnifyAttFileService<Boolean> {
    private static final Log LOG = LogFactory.getLog(UnifyAttFileAuthService.class);

    public UnifyAttFileAuthService(WtcAbstractUnityBillOperator operator) {
        super(operator);
    }

    @Override
    protected void matchProcess() {
        UnifyBillInfoContext billInfoContext = this.getBillInfoContext();
        long costStart = System.currentTimeMillis();
        Set attFileBoIds = billInfoContext.getBillResult().stream().map(UnifyBillResult::getAttFileBoId).collect(Collectors.toSet());
        if (LOG.isInfoEnabled()) {
            LOG.info("UnifyAttFileAuthService.matchProcess \u6863\u6848boid:{}", (Object)JSON.toJSONString(attFileBoIds));
        }
        AttFileF7QueryParam attFileQueryParam = new AttFileF7QueryParam();
        attFileQueryParam.setProperties(WTCStringUtils.joinOnComma((String[])new String[]{"boid", "id", "bsed", "bsled"}));
        attFileQueryParam.setBeCurrent(Boolean.FALSE);
        attFileQueryParam.setAttStatus(null);
        attFileQueryParam.setSetBoIds(attFileBoIds);
        boolean billCheckIsStrict = BillCommonService.billAuthCheckIsStrict();
        if (billCheckIsStrict) {
            attFileQueryParam.setAuthCheck(Boolean.TRUE);
            attFileQueryParam.setOrgAuthCheck(true);
            attFileQueryParam.setAppId(this.getBillInfoContext().getApplyAttr().getAttFileF7AuthAppId());
            attFileQueryParam.setFormId(this.getBillInfoContext().getApplyAttr().getAttFileF7AuthEntity());
            attFileQueryParam.setPermField(this.getBillInfoContext().getApplyAttr().getAttFileAuthField());
        } else {
            attFileQueryParam.setAuthCheck(Boolean.FALSE);
            attFileQueryParam.setOrgAuthCheck(false);
        }
        List<DynamicObject> attFileList = AttFileQueryServiceImpl.getInstance().queryAttFilesByCustomAuth(attFileQueryParam);
        Set hasAuthSet = attFileList.stream().map(dy -> HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dy, (String)"boid")).collect(Collectors.toSet());
        if (LOG.isInfoEnabled()) {
            LOG.info("UnifyAttFileAuthService.matchProcess> \u6709\u6743\u9650\u7684\u6863\u6848:{}", (Object)JSON.toJSONString(hasAuthSet));
        }
        for (UnifyBillResult billServiceResult : billInfoContext.getBillResult()) {
            billServiceResult.setCheckHaveAuth(Boolean.valueOf(hasAuthSet.contains(billServiceResult.getAttFileBoId())));
        }
        long costEnd = System.currentTimeMillis();
        LOG.info("UnifyAttFileAuthService.matchProcess \u5355\u636e\u7edf\u4e00\u6027\u80fd\u8017\u65f6 costStart={},costEnd={},cost={}", new Object[]{costStart, costEnd, costEnd - costStart});
        if (!CollectionUtils.isEmpty(attFileList)) {
            List collect = attFileList.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
            if (LOG.isInfoEnabled()) {
                LOG.info("UnifyAttFileAuthService.matchProcess> \u6709\u6743\u9650\u7684\u6863\u6848vid:{}", (Object)JSON.toJSONString(collect));
            }
        }
        this.setAttFileAllVersion(attFileList);
    }

    @Override
    protected UnifyCallChainEnum defineUnifyCallChainEnum() {
        return UnifyCallChainEnum.matchAttFileAuth;
    }

    @Override
    protected Boolean getResult(long attFileBoId) {
        for (UnifyBillResult billServiceResult : this.getBillInfoContext().getBillResult()) {
            if (attFileBoId != billServiceResult.getAttFileBoId()) continue;
            return billServiceResult.getCheckHaveAuth();
        }
        return Boolean.FALSE;
    }

    private void setAttFileAllVersion(List<DynamicObject> allAttFileVersionList) {
        List billResult = this.getBillInfoContext().getBillResult();
        for (UnifyBillResult unifyBillResult : billResult) {
            ArrayList attFileVersionList = Lists.newArrayListWithExpectedSize((int)10);
            for (DynamicObject attFileVersion : allAttFileVersionList) {
                long boIdFromDB = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)attFileVersion, (String)"boid");
                if (unifyBillResult.getAttFileBoId() != boIdFromDB) continue;
                attFileVersionList.add(attFileVersion);
            }
            unifyBillResult.setAllAttFileVersionWithPerm((List)attFileVersionList);
        }
    }
}

