/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.matchcore.attfile;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtbs.business.web.applybill.commonhelper.UnifyBillCommonHelper;
import kd.wtc.wtbs.business.web.applybill.matchcore.attfile.AbstractUnifyAttFileService;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtbs.common.enums.bill.UnifyCallChainEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileScheduleQueryParam;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillResult;
import kd.wtc.wtbs.common.model.billservice.BillAttFileVersionPlanInfo;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class UnifyAttFilePlanService
extends AbstractUnifyAttFileService<List<DynamicObject>> {
    private static final Log LOG = LogFactory.getLog(UnifyAttFilePlanService.class);

    public UnifyAttFilePlanService(WtcAbstractUnityBillOperator operator) {
        super(operator);
    }

    @Override
    protected void matchProcess() {
        long costStart = System.currentTimeMillis();
        Set attFileBoIds = this.getBillInfoContext().getBillResult().stream().map(UnifyBillResult::getAttFileBoId).collect(Collectors.toSet());
        if (LOG.isInfoEnabled()) {
            LOG.info("UnifyAttFilePlanService.matchProcess> \u6863\u6848boid:{}", (Object)JSON.toJSONString(attFileBoIds));
        }
        AttFileScheduleQueryParam queryParam = new AttFileScheduleQueryParam();
        queryParam.setFileBoIdSet(attFileBoIds);
        queryParam.setBusyStatus((Set)Sets.newHashSet((Object[])new String[]{"1"}));
        String planId = WTCStringUtils.joinStr((String[])new String[]{this.getOperator().getUnifyBillEnum().getAttFileScheduleEnum().getKey(), ".", "id"});
        queryParam.setProperties(WTCStringUtils.joinOnComma((String[])new String[]{planId, "attfileid.id", "startdate", "enddate"}));
        AttFileScheduleServiceImpl attFileImpl = new AttFileScheduleServiceImpl();
        Map<Long, List<DynamicObject>> attFileFilePlanDys = attFileImpl.queryAttFileSchedule(this.getOperator().getUnifyBillEnum().getAttFileScheduleEnum(), queryParam);
        if (LOG.isInfoEnabled()) {
            LOG.info("UnifyAttFilePlanService.matchProcess> \u8c03\u7528\u6863\u6848\u670d\u52a1\u83b7\u53d6\u7684\u6863\u6848\u96c6\u5408id:{}", (Object)JSON.toJSONString(attFileFilePlanDys.keySet()));
        }
        Map<Long, List<DynamicObject>> attFileIdAndPlanDys = UnifyBillCommonHelper.getPlanDyByAttFilePlan(attFileFilePlanDys, this.getOperator());
        HashMap<Long, List<DynamicObject>> attFileVersionDys = new HashMap<Long, List<DynamicObject>>(16);
        List billResult = this.getOperator().getInfoContext().getBillResult();
        if (!CollectionUtils.isEmpty((Collection)billResult)) {
            billResult.forEach(bs -> attFileVersionDys.put(bs.getAttFileBoId(), bs.getAllAttFileVersion()));
        }
        Map<Long, List<BillAttFileVersionPlanInfo>> planInAttFileVersionGroup = UnifyBillCommonHelper.getRelaForAttFileVersionAndPlan(attFileVersionDys, attFileFilePlanDys, this.getOperator().getUnifyBillEnum().getAttFileScheduleEnum());
        for (UnifyBillResult billServiceResult : this.getBillInfoContext().getBillResult()) {
            List<Object> versionGroupPlanDy;
            long attFileBoId;
            List<DynamicObject> planDy;
            if (billServiceResult.getAllPlanInAttFile() == null) {
                billServiceResult.setAllPlanInAttFile((List)Lists.newArrayListWithExpectedSize((int)10));
                billServiceResult.setPlanInAttFileVersionGroup(Collections.emptyMap());
            }
            if (!CollectionUtils.isEmpty(planDy = attFileIdAndPlanDys.get(attFileBoId = billServiceResult.getAttFileBoId()))) {
                billServiceResult.getAllPlanInAttFile().addAll(planDy);
            }
            versionGroupPlanDy = (versionGroupPlanDy = planInAttFileVersionGroup.get(attFileBoId)) == null ? Collections.emptyList() : versionGroupPlanDy;
            HashMap groupRelation = Maps.newHashMapWithExpectedSize((int)versionGroupPlanDy.size());
            versionGroupPlanDy.forEach(vp -> groupRelation.put(vp.getAttFileVid(), this.getBillPlanByAttFilePlan(vp.getPlanDyInAttFileVid(), planDy)));
            billServiceResult.setPlanInAttFileVersionGroup((Map)groupRelation);
            for (DynamicObject attFileVersion : billServiceResult.getAllAttFileVersion()) {
                long attFileVid = attFileVersion.getLong("id");
                groupRelation.putIfAbsent(attFileVid, Collections.emptyList());
            }
        }
        long costEnd = System.currentTimeMillis();
        LOG.info("UnifyAttFilePlanService.matchProcess \u5355\u636e\u7edf\u4e00\u6027\u80fd\u8017\u65f6 costStart={},costEnd={},cost={}", new Object[]{costStart, costEnd, costEnd - costStart});
    }

    private List<DynamicObject> getBillPlanByAttFilePlan(List<DynamicObject> planDyInAttFileVidList, List<DynamicObject> billPlanDyList) {
        if (CollectionUtils.isEmpty(planDyInAttFileVidList) || CollectionUtils.isEmpty(billPlanDyList)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)planDyInAttFileVidList.size());
        for (DynamicObject planDyInAttFileVid : planDyInAttFileVidList) {
            long boId = planDyInAttFileVid.getLong(WTCStringUtils.joinStr((String[])new String[]{this.getOperator().getUnifyBillEnum().getAttFileScheduleEnum().getKey(), ".", "id"}));
            for (DynamicObject billPlan : billPlanDyList) {
                long billPlanBoId = billPlan.getLong("boid");
                if (boId != billPlanBoId) continue;
                result.add(billPlan);
            }
        }
        return result;
    }

    @Override
    protected UnifyCallChainEnum defineUnifyCallChainEnum() {
        return UnifyCallChainEnum.matchAllPlan;
    }

    @Override
    protected List<DynamicObject> getResult(long attFileBoId) {
        for (UnifyBillResult billServiceResult : this.getBillInfoContext().getBillResult()) {
            if (attFileBoId != billServiceResult.getAttFileBoId()) continue;
            return billServiceResult.getAllPlanInAttFile();
        }
        return Collections.emptyList();
    }
}

