/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.matchcore.attfile;

import com.alibaba.fastjson.JSON;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.web.applybill.commonhelper.UnifyBillCommonHelper;
import kd.wtc.wtbs.business.web.applybill.matchcore.attfile.AbstractUnifyAttFileService;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.business.web.billservice.attfile.BillAttFileService;
import kd.wtc.wtbs.common.enums.bill.UnifyCallChainEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyRuleEnum;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillResult;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class UnifyAttFileRuleService
extends AbstractUnifyAttFileService<List<DynamicObject>> {
    private static final Log LOG = LogFactory.getLog(UnifyAttFileRuleService.class);

    public UnifyAttFileRuleService(WtcAbstractUnityBillOperator operator) {
        super(operator);
    }

    @Override
    protected void matchProcess() {
        long costStart = System.currentTimeMillis();
        HashSet planRuleBoIds = Sets.newHashSetWithExpectedSize((int)16);
        BillAttFileService attFileService = BillAttFileService.getInstance();
        LocalDate today = LocalDate.now();
        for (UnifyBillResult billResult : this.getBillInfoContext().getBillResult()) {
            List<DynamicObject> attFileInOneBo = UnifyBillCommonHelper.getAttFileVersionIdAndDy(this.getOperator()).get(billResult.getAttFileBoId());
            DynamicObject attFileVersionByDate = attFileService.getAttFileVersionByDate(attFileInOneBo, WTCDateUtils.toDate((LocalDate)today));
            for (DynamicObject planDy : billResult.getAllPlanInAttFile()) {
                planRuleBoIds.add(UnifyBillCommonHelper.getRuleBoIdByPlanDy(planDy, today, attFileVersionByDate, this.getOperator()));
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("UnifyAttFileRuleService.matchProcess> \u65b9\u6848\u4e0b\u7684\u89c4\u5219boid:{}", (Object)JSON.toJSONString((Object)planRuleBoIds));
        }
        UnifyRuleEnum ruleEnum = this.getOperator().getUnifyBillEnum().getUnifyPlanEnum().getRuleEnum();
        DynamicObject[] rules = UnifyBillCommonHelper.getAllSeqHisDys(ruleEnum.getEntityNumber(), WTCHisServiceHelper.getMinEndDate(), WTCHisServiceHelper.getMaxEndDate(), planRuleBoIds);
        LOG.info("UnifyAttFileRuleService.matchProcess> \u67e5\u8be2\u7684\u89c4\u5219\u5927\u5c0f\uff1a{}", (Object)rules.length);
        for (UnifyBillResult billServiceResult : this.getBillInfoContext().getBillResult()) {
            List<DynamicObject> ruleDysByAllPlan = this.getRuleDysByAllPlan(this.getOperator(), rules, billServiceResult);
            LOG.info("UnifyAttFileRuleService.matchProcess> ruleDysByAllPlan.size = {}", (Object)ruleDysByAllPlan.size());
            billServiceResult.setAllRuleInAttFile(ruleDysByAllPlan);
            billServiceResult.setRuleInAttFileVersionGroup(this.getRuleDysByAllPlanVersion(this.getOperator(), rules, billServiceResult));
        }
        long costEnd = System.currentTimeMillis();
        LOG.info("UnifyAttFileRuleService.matchProcess \u5355\u636e\u7edf\u4e00\u6027\u80fd\u8017\u65f6 costStart={},costEnd={},cost={}", new Object[]{costStart, costEnd, costEnd - costStart});
    }

    @Override
    protected UnifyCallChainEnum defineUnifyCallChainEnum() {
        return UnifyCallChainEnum.matchAllRule;
    }

    @Override
    protected List<DynamicObject> getResult(long attFileBoId) {
        for (UnifyBillResult billServiceResult : this.getBillInfoContext().getBillResult()) {
            if (attFileBoId != billServiceResult.getAttFileBoId()) continue;
            return billServiceResult.getAllRuleInAttFile();
        }
        return Collections.emptyList();
    }

    private List<DynamicObject> getRuleDysByAllPlan(WtcAbstractUnityBillOperator operator, DynamicObject[] rules, UnifyBillResult billServiceResult) {
        BillAttFileService attFileService = BillAttFileService.getInstance();
        LocalDate today = LocalDate.now();
        List<DynamicObject> attFileInOneBo = UnifyBillCommonHelper.getAttFileVersionIdAndDy(this.getOperator()).get(billServiceResult.getAttFileBoId());
        ArrayList result = Lists.newArrayListWithExpectedSize((int)10);
        LOG.info("UnifyAttFileRuleService.getRuleDysByAllPlan> rules.size = {}", (Object)rules.length);
        for (DynamicObject planDy : billServiceResult.getAllPlanInAttFile()) {
            LOG.info("UnifyAttFileRuleService.getRuleDysByAllPlan> planDy.pkId = {}", planDy.getPkValue());
            Long ruleBoIdByPlanDy = UnifyBillCommonHelper.getRuleBoIdByPlanDy(planDy, today, attFileService.getAttFileVersionByDate(attFileInOneBo, WTCDateUtils.toDate((LocalDate)today)), operator);
            if (LOG.isInfoEnabled()) {
                LOG.info("UnifyAttFileRuleService.getRuleDysByAllPlan> ruleBoIdByPlanDy = {}", (Object)ruleBoIdByPlanDy);
            }
            for (DynamicObject ruleDy : rules) {
                if (!ruleBoIdByPlanDy.equals(ruleDy.getLong("boid"))) continue;
                result.add(ruleDy);
            }
        }
        return result;
    }

    private Map<Long, List<DynamicObject>> getRuleDysByAllPlanVersion(WtcAbstractUnityBillOperator operator, DynamicObject[] rules, UnifyBillResult billServiceResult) {
        HashMap<Long, List<DynamicObject>> result = new HashMap<Long, List<DynamicObject>>(10);
        LOG.info("UnifyAttFileRuleService.getRuleDysByAllPlanVersion> rules.size = {}", (Object)rules.length);
        BillAttFileService attFileService = BillAttFileService.getInstance();
        LocalDate today = LocalDate.now();
        billServiceResult.getPlanInAttFileVersionGroup().forEach((k, v) -> {
            List<DynamicObject> attFileInOneBo = UnifyBillCommonHelper.getAttFileVersionIdAndDy(this.getOperator()).get(billServiceResult.getAttFileBoId());
            ArrayList<DynamicObject> tempList = new ArrayList<DynamicObject>(10);
            for (DynamicObject planDy : v) {
                Long ruleBoIdByPlanDy = UnifyBillCommonHelper.getRuleBoIdByPlanDy(planDy, today, attFileService.getAttFileVersionByDate(attFileInOneBo, WTCDateUtils.toDate((LocalDate)today)), operator);
                for (DynamicObject ruleDy : rules) {
                    if (!ruleBoIdByPlanDy.equals(ruleDy.getLong("boid"))) continue;
                    tempList.add(ruleDy);
                }
                result.put((Long)k, (List<DynamicObject>)tempList);
            }
        });
        return result;
    }
}

