/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.matchcore.attfile;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtbs.business.limitcond.OnLimitConditionExpPlugin;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.rulecondition.RuleConditionRetrieval;
import kd.wtc.wtbs.business.rulecondition.bill.RuleConditionBillMatchService;
import kd.wtc.wtbs.business.rulecondition.bill.RuleConditionBillNoDateLimitDto;
import kd.wtc.wtbs.business.rulecontrol.ConditionValidateService;
import kd.wtc.wtbs.business.util.ext.LimitConditionExpBundle;
import kd.wtc.wtbs.business.web.applybill.commonhelper.UnifyBillCommonHelper;
import kd.wtc.wtbs.business.web.applybill.matchcore.attfile.AbstractUnifyAttFileService;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.common.enums.bill.UnifyCallChainEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillResult;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;

public class UnifyAttFileTypeService
extends AbstractUnifyAttFileService<List<DynamicObject>> {
    private static final Log LOG = LogFactory.getLog(UnifyAttFileTypeService.class);

    public UnifyAttFileTypeService(WtcAbstractUnityBillOperator operator) {
        super(operator);
    }

    @Override
    protected void matchProcess() {
        long costStart = System.currentTimeMillis();
        WTCPluginProxy<OnLimitConditionExpPlugin> pluginProxy = WTCPluginProxyFactory.create(OnLimitConditionExpPlugin.class, "kd.sdk.wtc.wtbs.business.limitcond.OnLimitConditionExpPlugin");
        LimitConditionExpBundle limitBundle = new LimitConditionExpBundle(String.valueOf(this.getOperator().getUnifyBillEnum()), pluginProxy, null);
        ArrayList<RuleConditionRetrieval> ruleConditionRetrievals = new ArrayList(0);
        if (this.getOperator().getUnifyBillEnum() == UnifyBillEnum.OT) {
            List<RuleConditionBillNoDateLimitDto> noDateLimitDtos = this.collectAllMatchData();
            ruleConditionRetrievals = RuleConditionBillMatchService.billLimitMatchForType(noDateLimitDtos);
        }
        for (UnifyBillResult billServiceResult : this.getBillInfoContext().getBillResult()) {
            ArrayList<DynamicObject> allTypeInAttFile = new ArrayList<DynamicObject>(16);
            List allAttFileVersion = billServiceResult.getAllAttFileVersion();
            Map allRuleInAttFile = billServiceResult.getRuleInAttFileVersionGroup();
            if (LOG.isInfoEnabled()) {
                if (!CollectionUtils.isEmpty((Map)allRuleInAttFile)) {
                    LOG.info("UnifyAttFileTypeService_allRuleInAttFile allRuleInAttFile.size = {}", (Object)allRuleInAttFile.size());
                } else {
                    LOG.info("UnifyAttFileTypeService_allRuleInAttFile allRuleInAttFile is empty");
                }
                if (!CollectionUtils.isEmpty((Collection)allAttFileVersion)) {
                    LOG.info("UnifyAttFileTypeService_allRuleInAttFile allAttFileVersion.size = {}", (Object)allAttFileVersion.size());
                } else {
                    LOG.info("UnifyAttFileTypeService_allRuleInAttFile allAttFileVersion is empty");
                }
            }
            if (this.getOperator().getUnifyBillEnum() == UnifyBillEnum.OT) {
                UnifyBillCommonHelper.limitScopeTypesGroupByAttfileBoNew(allTypeInAttFile, allAttFileVersion, allRuleInAttFile, this.getOperator().getUnifyBillEnum(), ruleConditionRetrievals);
            } else {
                UnifyBillCommonHelper.limitScopeTypesGroupByAttfileBo(allTypeInAttFile, allAttFileVersion, allRuleInAttFile, this.getOperator().getUnifyBillEnum(), limitBundle);
            }
            billServiceResult.setAllTypeInAttFile(allTypeInAttFile);
        }
        long costEnd = System.currentTimeMillis();
        LOG.info("UnifyAttFileTypeService.matchProcess \u5355\u636e\u7edf\u4e00\u6027\u80fd\u8017\u65f6 costStart={},costEnd={},cost={}", new Object[]{costStart, costEnd, costEnd - costStart});
    }

    private List<RuleConditionBillNoDateLimitDto> collectAllMatchData() {
        ArrayList<RuleConditionBillNoDateLimitDto> noDateLimitDtos = new ArrayList<RuleConditionBillNoDateLimitDto>(16);
        for (UnifyBillResult billServiceResult : this.getBillInfoContext().getBillResult()) {
            List allAttFileVersion = billServiceResult.getAllAttFileVersion();
            Map allRuleInAttFile = billServiceResult.getRuleInAttFileVersionGroup();
            if (WTCCollections.isEmpty((Collection)allAttFileVersion) || WTCCollections.isEmpty((Map)allRuleInAttFile)) continue;
            for (DynamicObject attFileVersionDy : allAttFileVersion) {
                this.buildCalRuleEntryDtos(attFileVersionDy, billServiceResult, noDateLimitDtos);
            }
        }
        return noDateLimitDtos;
    }

    private void buildCalRuleEntryDtos(DynamicObject attFileVersionDy, UnifyBillResult billServiceResult, List<RuleConditionBillNoDateLimitDto> noDateLimitDtos) {
        long attFileVid = attFileVersionDy.getLong("id");
        Map allRuleInAttFile = billServiceResult.getRuleInAttFileVersionGroup();
        List ruleInAttFileList = (List)allRuleInAttFile.get(attFileVid);
        UnifyBillEnum unifyBillEnum = this.getOperator().getUnifyBillEnum();
        if (WTCCollections.isEmpty((Collection)ruleInAttFileList) || unifyBillEnum == null) {
            return;
        }
        DynamicObject billDy = billServiceResult.getBillDy();
        String entryKey = "entryentity";
        if (UnifyBillEnum.OT == unifyBillEnum) {
            entryKey = this.getOtApplyEntryKey(billDy);
        }
        Date vStartDate = attFileVersionDy.getDate("bsed");
        Date vEndDate = attFileVersionDy.getDate("bsled");
        for (DynamicObject ruleInAttFile : ruleInAttFileList) {
            DynamicObjectCollection entryEntity = ruleInAttFile.getDynamicObjectCollection(unifyBillEnum.getUnifyPlanEnum().getRuleEnum().getCalEntry());
            for (DynamicObject entryRow : entryEntity) {
                RuleConditionBillNoDateLimitDto noDateLimitDtoEnd;
                RuleConditionBillNoDateLimitDto noDateLimitDtoStart = this.buildCalRuleEntryOneDto(attFileVersionDy, unifyBillEnum, vStartDate, billDy, entryKey, entryRow);
                if (noDateLimitDtoStart != null) {
                    noDateLimitDtos.add(noDateLimitDtoStart);
                }
                if (vStartDate == null || vStartDate.equals(vEndDate) || (noDateLimitDtoEnd = this.buildCalRuleEntryOneDto(attFileVersionDy, unifyBillEnum, vEndDate, billDy, entryKey, entryRow)) == null) continue;
                noDateLimitDtos.add(noDateLimitDtoEnd);
            }
        }
    }

    private RuleConditionBillNoDateLimitDto buildCalRuleEntryOneDto(DynamicObject attFileVersionDy, UnifyBillEnum unifyBillEnum, Date dutyDate, DynamicObject billDy, String entryKey, DynamicObject calEntryRow) {
        long attFileVid = attFileVersionDy.getLong("id");
        long attPersonId = attFileVersionDy.getLong("attperson");
        String calCulDes = calEntryRow.getString(unifyBillEnum.getUnifyPlanEnum().getRuleEnum().getUnifyRuleCalEntryEnum().getCalCulDes());
        if (HRStringUtils.isEmpty((String)calCulDes)) {
            return null;
        }
        RuleConditionBillNoDateLimitDto noDateLimitDto = new RuleConditionBillNoDateLimitDto();
        noDateLimitDto.setCondition(calCulDes);
        noDateLimitDto.setAccessDto(ConditionValidateService.getRuleConditionInfo(calCulDes));
        noDateLimitDto.setAttFileVId(attFileVid);
        noDateLimitDto.setAttFileV(attFileVersionDy);
        noDateLimitDto.setAttPersonId(attPersonId);
        noDateLimitDto.setDimensionKey(attFileVid + "_" + calEntryRow.get("id"));
        noDateLimitDto.setBillBusType(unifyBillEnum.name());
        noDateLimitDto.setBillDy(billDy);
        noDateLimitDto.setEntryKey(entryKey);
        noDateLimitDto.setIndex(0);
        if (dutyDate == null) {
            noDateLimitDto.setDutyDate(WTCDateUtils.toDate((LocalDate)LocalDate.now()));
        } else {
            noDateLimitDto.setDutyDate(dutyDate);
        }
        return noDateLimitDto;
    }

    private String getOtApplyEntryKey(DynamicObject billDy) {
        String otapplytype;
        String entryKey = "scentry";
        if (billDy != null && billDy.containsProperty("otapplytype") && "1".equals(otapplytype = billDy.getString("otapplytype"))) {
            entryKey = "sdentry";
        }
        return entryKey;
    }

    @Override
    protected UnifyCallChainEnum defineUnifyCallChainEnum() {
        return UnifyCallChainEnum.matchAllType;
    }

    @Override
    protected List<DynamicObject> getResult(long attFileBoId) {
        for (UnifyBillResult billResult : this.getBillInfoContext().getBillResult()) {
            if (attFileBoId != billResult.getAttFileBoId()) continue;
            return billResult.getAllTypeInAttFile();
        }
        return Collections.emptyList();
    }
}

