/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.matchcore.entry;

import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtbs.business.web.applybill.commonhelper.UnifyBillCommonHelper;
import kd.wtc.wtbs.business.web.applybill.matchcore.entry.AbstractUnifyEntryService;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.MultiLangEnumBridge;
import kd.wtc.wtbs.common.enums.bill.UnifyCallChainEnum;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillDutyInfoResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillEntryResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillResult;
import kd.wtc.wtbs.common.util.WTCDateUtils;

public class UnifyEntryAttFileVersionService
extends AbstractUnifyEntryService<Map<Date, DynamicObject>> {
    private static final Log LOG = LogFactory.getLog(UnifyEntryAttFileVersionService.class);

    public UnifyEntryAttFileVersionService(WtcAbstractUnityBillOperator operator) {
        super(operator);
    }

    @Override
    protected void matchProcess() {
        for (UnifyBillResult billResult : this.getBillInfoContext().getBillResult()) {
            List allAttFileVersion = billResult.getAllAttFileVersion();
            for (UnifyBillEntryResult unifyBillEntryResult : billResult.getEntryResultList()) {
                this.setAttFileVersion(unifyBillEntryResult, allAttFileVersion);
            }
        }
    }

    @Override
    protected UnifyCallChainEnum defineUnifyCallChainEnum() {
        return UnifyCallChainEnum.matchAttFileVersion;
    }

    @Override
    protected Map<Date, DynamicObject> getResult(long attFileBoId, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime) {
        List<UnifyBillDutyInfoResult> matchResult = UnifyBillCommonHelper.matchOneBillDutyDateInfo(attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime, null, this.getBillInfoContext().getBillResult());
        if (matchResult != null) {
            return matchResult.stream().collect(LinkedHashMap::new, (m1, v1) -> m1.put(v1.getDutyDate(), v1.getAttFileVersion()), HashMap::putAll);
        }
        return Collections.emptyMap();
    }

    @Override
    protected Map<Date, DynamicObject> getResult(long billId, int entryIndex) {
        List<UnifyBillDutyInfoResult> matchResult = UnifyBillCommonHelper.matchDutyInfoByBillIdAndIndex(billId, entryIndex, this.getBillInfoContext().getBillResult());
        if (matchResult != null) {
            return matchResult.stream().collect(LinkedHashMap::new, (m1, v1) -> m1.put(v1.getDutyDate(), v1.getAttFileVersion()), HashMap::putAll);
        }
        return Collections.emptyMap();
    }

    private void setAttFileVersion(UnifyBillEntryResult unifyBillEntryResult, List<DynamicObject> allAttFileVersionDys) {
        List attFileVPkId = allAttFileVersionDys.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        if (LOG.isDebugEnabled()) {
            LOG.debug("UnifyEntryAttFileVersionService.setAttFileVersion allAttFileVersionDys.size = {},vids = {}", (Object)allAttFileVersionDys.size(), (Object)JSON.toJSONString(attFileVPkId));
        }
        for (UnifyBillDutyInfoResult dutyInfoResult : unifyBillEntryResult.getDutyInfos()) {
            Date dutyDate = dutyInfoResult.getDutyDate();
            AttFileQueryServiceImpl queryService = AttFileQueryServiceImpl.getInstance();
            Date dayStartTime = WTCDateUtils.getDayStartTime((Date)dutyDate);
            Date dayEndTime = WTCDateUtils.getDayEndTime((Date)dutyDate);
            LOG.info("UnifyEntryAttFileVersionService.setAttFileVersion dayStartTime={},dayEndTime={}", (Object)dayStartTime, (Object)dayEndTime);
            List<DynamicObject> attFileDyList = queryService.filterAttFileByHisDateRange(allAttFileVersionDys, dayStartTime, dayEndTime);
            if (CollectionUtils.isEmpty(attFileDyList)) {
                LOG.info("UnifyEntryAttFileVersionService.setAttFileVersion filter is empty");
                return;
            }
            LOG.info("UnifyEntryAttFileVersionService.setAttFileVersion attFileDyList.size={}", (Object)attFileDyList.size());
            if (attFileDyList.size() > 1) {
                LOG.warn("UnifyEntryAttFileVersionService.setAttFileVersion \u6863\u6848\u7248\u672c\u5207\u5206\u9519\u8bef ,attFileDy.sie={}", (Object)attFileDyList.size());
                throw new KDBizException(new MultiLangEnumBridge("\u6863\u6848\u7248\u672c\u5207\u5206\u9519\u8bef", "UnifyEntryAttFileVersionService_0", "wtc-wtbs-business").loadKDString());
            }
            LOG.info("UnifyEntryAttFileVersionService.setAttFileVersion attFileDyList.get(0) is null = {}", (Object)(attFileDyList.get(0) == null ? 1 : 0));
            dutyInfoResult.setAttFileVersion(attFileDyList.get(0));
        }
    }
}

