/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.matchcore.entry;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.web.applybill.commonhelper.UnifyBillCommonHelper;
import kd.wtc.wtbs.business.web.applybill.matchcore.entry.AbstractUnifyEntryService;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.common.enums.bill.UnifyCallChainEnum;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillDutyInfoResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillEntryResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillResult;

public class UnifyEntryDutyAuthService
extends AbstractUnifyEntryService<Map<Date, Boolean>> {
    private static final Log LOG = LogFactory.getLog(UnifyEntryDutyAuthService.class);

    public UnifyEntryDutyAuthService(WtcAbstractUnityBillOperator operator) {
        super(operator);
    }

    @Override
    protected void matchProcess() {
        long costStart = System.currentTimeMillis();
        for (UnifyBillResult billServiceResult : this.getBillInfoContext().getBillResult()) {
            Boolean checkHaveAuth = billServiceResult.getCheckHaveAuth();
            if (!checkHaveAuth.booleanValue()) {
                UnifyEntryDutyAuthService.setFalseToDutyAuth(billServiceResult);
                continue;
            }
            List allAttFileVersionWithPerm = billServiceResult.getAllAttFileVersionWithPerm();
            Set<Long> hasAuthSet = allAttFileVersionWithPerm.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
            UnifyEntryDutyAuthService.setDutyAuthToDutyInfo(billServiceResult, hasAuthSet);
        }
        long costEnd = System.currentTimeMillis();
        LOG.info("UnifyEntryDutyAuthService.matchProcess \u5355\u636e\u7edf\u4e00\u6027\u80fd\u8017\u65f6 costStart={},costEnd={},cost={}", new Object[]{costStart, costEnd, costEnd - costStart});
    }

    @Override
    protected UnifyCallChainEnum defineUnifyCallChainEnum() {
        return UnifyCallChainEnum.matchDutyAuth;
    }

    @Override
    protected Map<Date, Boolean> getResult(long attFileBoId, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime) {
        if (dutyDateQueryStartTime == null || dutyDateQueryEndTime == null) {
            return Collections.emptyMap();
        }
        List<UnifyBillDutyInfoResult> matchResult = UnifyBillCommonHelper.matchOneBillDutyDateInfo(attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime, null, this.getBillInfoContext().getBillResult());
        if (matchResult != null) {
            return matchResult.stream().collect(LinkedHashMap::new, (m1, v1) -> m1.put(v1.getDutyDate(), v1.getDutyAuthCheckResult()), HashMap::putAll);
        }
        return Collections.emptyMap();
    }

    @Override
    protected Map<Date, Boolean> getResult(long billId, int entryIndex) {
        List<UnifyBillDutyInfoResult> matchResult = UnifyBillCommonHelper.matchDutyInfoByBillIdAndIndex(billId, entryIndex, this.getBillInfoContext().getBillResult());
        if (matchResult != null) {
            return matchResult.stream().collect(LinkedHashMap::new, (m1, v1) -> m1.put(v1.getDutyDate(), v1.getDutyAuthCheckResult()), HashMap::putAll);
        }
        return Collections.emptyMap();
    }

    private static void setFalseToDutyAuth(UnifyBillResult billServiceResult) {
        for (UnifyBillEntryResult billServiceEntryResult : billServiceResult.getEntryResultList()) {
            for (UnifyBillDutyInfoResult dutyInfo : billServiceEntryResult.getDutyInfos()) {
                dutyInfo.setDutyAuthCheckResult(Boolean.FALSE);
            }
        }
    }

    private static void setDutyAuthToDutyInfo(UnifyBillResult billServiceResult, Set<Long> hasAuthSet) {
        for (UnifyBillEntryResult billServiceEntryResult : billServiceResult.getEntryResultList()) {
            Iterator iterator = billServiceEntryResult.getDutyInfos().iterator();
            while (iterator.hasNext()) {
                UnifyBillDutyInfoResult dutyInfo;
                DynamicObject attFileVersion = (dutyInfo = (UnifyBillDutyInfoResult)iterator.next()).getAttFileVersion();
                dutyInfo.setDutyAuthCheckResult(Boolean.valueOf(attFileVersion != null && hasAuthSet.contains(attFileVersion.getLong("id"))));
            }
        }
    }
}

