/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.matchcore.entry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.param.AppCustomParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.web.applybill.matchcore.entry.AbstractUnifyEntryService;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.business.web.billservice.dutyDate.BillOptionalDutyDateService;
import kd.wtc.wtbs.common.enums.bill.ApplyBillDutyDateErrorEnum;
import kd.wtc.wtbs.common.enums.bill.UnifyCallChainEnum;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillDutyInfoResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillEntryResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillResult;
import kd.wtc.wtbs.common.model.billservice.BillOptionDutyDateReq;
import kd.wtc.wtbs.common.model.billservice.BillOptionDutyDateResp;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class UnifyEntryDutyDateService
extends AbstractUnifyEntryService<Tuple<List<Date>, ApplyBillDutyDateErrorEnum>> {
    private static final Log LOG = LogFactory.getLog(UnifyEntryDutyDateService.class);

    public UnifyEntryDutyDateService(WtcAbstractUnityBillOperator operator) {
        super(operator);
    }

    @Override
    protected void matchProcess() {
        List billCheckInfoList = this.getBillInfoContext().getBillResult();
        if (!this.isQuerySingle()) {
            LOG.info("start batch dutydate query");
            HashMap<UnifyBillEntryResult, BillOptionDutyDateReq> entryAndReq = new HashMap<UnifyBillEntryResult, BillOptionDutyDateReq>(10);
            HashMap<BillOptionDutyDateReq, BillOptionDutyDateResp> reqAndResp = new HashMap<BillOptionDutyDateReq, BillOptionDutyDateResp>(10);
            for (UnifyBillResult serviceResult : billCheckInfoList) {
                for (UnifyBillEntryResult billServiceEntryResult : serviceResult.getEntryResultList()) {
                    List dutyShiftRange = billServiceEntryResult.getDutyShiftRange();
                    BillOptionDutyDateReq req = new BillOptionDutyDateReq();
                    req.setAttFileBoId(Long.valueOf(serviceResult.getAttFileBoId()));
                    req.setShiftInfo(dutyShiftRange);
                    req.setStartTime(billServiceEntryResult.getDutyDateQueryStartTime());
                    req.setEndTime(billServiceEntryResult.getDutyDateQueryEndTime());
                    entryAndReq.put(billServiceEntryResult, req);
                }
            }
            if (WTCCollections.isEmpty(entryAndReq)) {
                return;
            }
            BillOptionalDutyDateService service = new BillOptionalDutyDateService();
            ArrayList<BillOptionDutyDateReq> billOptionDutyDateReqs = new ArrayList<BillOptionDutyDateReq>(entryAndReq.values());
            List<BillOptionDutyDateResp> dutyDateResps = service.getDutyDate(billOptionDutyDateReqs);
            for (int index = 0; index < dutyDateResps.size(); ++index) {
                BillOptionDutyDateReq req = (BillOptionDutyDateReq)billOptionDutyDateReqs.get(index);
                BillOptionDutyDateResp billOptionDutyDateResp = dutyDateResps.get(index);
                reqAndResp.put(req, billOptionDutyDateResp);
            }
            for (UnifyBillResult serviceResult : billCheckInfoList) {
                for (UnifyBillEntryResult billServiceEntryResult : serviceResult.getEntryResultList()) {
                    BillOptionDutyDateReq req = (BillOptionDutyDateReq)entryAndReq.get(billServiceEntryResult);
                    if (req == null) {
                        billServiceEntryResult.setHaveCorrectDuty(Boolean.FALSE);
                        billServiceEntryResult.setBillDutyDateErrorEnum(ApplyBillDutyDateErrorEnum.UN_KNOW_ERROR);
                        continue;
                    }
                    BillOptionDutyDateResp billOptionDutyDateResp = (BillOptionDutyDateResp)reqAndResp.get(req);
                    if (billOptionDutyDateResp == null) {
                        billServiceEntryResult.setHaveCorrectDuty(Boolean.FALSE);
                        billServiceEntryResult.setBillDutyDateErrorEnum(ApplyBillDutyDateErrorEnum.UN_KNOW_ERROR);
                        continue;
                    }
                    if (billOptionDutyDateResp.isCorrectMatch()) {
                        billServiceEntryResult.setHaveCorrectDuty(Boolean.TRUE);
                        billServiceEntryResult.setDutyInfos((List)Lists.newArrayList((Object[])new UnifyBillDutyInfoResult[]{new UnifyBillDutyInfoResult(billOptionDutyDateResp.getDutyDate())}));
                        continue;
                    }
                    billServiceEntryResult.setHaveCorrectDuty(Boolean.FALSE);
                    billServiceEntryResult.setBillDutyDateErrorEnum(billOptionDutyDateResp.getErrorEnum());
                }
            }
        } else {
            LOG.info("start single dutydate query");
            List<Tuple<DutyShift, Shift>> dutyShiftRange = this.getDutyShiftRange(billCheckInfoList);
            BillOptionalDutyDateService service = new BillOptionalDutyDateService();
            for (UnifyBillResult serviceResult : billCheckInfoList) {
                for (UnifyBillEntryResult billServiceEntryResult : serviceResult.getEntryResultList()) {
                    BillOptionDutyDateReq req = new BillOptionDutyDateReq();
                    req.setAttFileBoId(Long.valueOf(serviceResult.getAttFileBoId()));
                    req.setShiftInfo(dutyShiftRange);
                    req.setStartTime(billServiceEntryResult.getDutyDateQueryStartTime());
                    req.setEndTime(billServiceEntryResult.getDutyDateQueryEndTime());
                    BillOptionDutyDateResp dutyDateInfo = service.getDutyDate(req);
                    if (dutyDateInfo.isCorrectMatch()) {
                        billServiceEntryResult.setHaveCorrectDuty(Boolean.TRUE);
                        billServiceEntryResult.setDutyInfos((List)Lists.newArrayList((Object[])new UnifyBillDutyInfoResult[]{new UnifyBillDutyInfoResult(dutyDateInfo.getDutyDate())}));
                        continue;
                    }
                    billServiceEntryResult.setHaveCorrectDuty(Boolean.FALSE);
                    billServiceEntryResult.setBillDutyDateErrorEnum(dutyDateInfo.getErrorEnum());
                }
            }
        }
    }

    private boolean isQuerySingle() {
        try {
            AppCustomParam param = new AppCustomParam();
            param.setAppId(AppMetadataCache.getAppInfo((String)"wtp").getId());
            param.setSearchKeySet((Set)Sets.newHashSet((Object[])new String[]{"dutyDateSingle"}));
            Map paramMap = SystemParamServiceHelper.loadAppCustomParameterFromCache((AppCustomParam)param);
            if (paramMap == null || paramMap.get("dutyDateSingle") == null) {
                return false;
            }
            String dutyDateBatch = (String)paramMap.get("dutyDateSingle");
            return HRStringUtils.equals((String)"true", (String)dutyDateBatch);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    protected UnifyCallChainEnum defineUnifyCallChainEnum() {
        return UnifyCallChainEnum.matchDutyDate;
    }

    @Override
    protected Tuple<List<Date>, ApplyBillDutyDateErrorEnum> getResult(long attFileBoId, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime) {
        if (dutyDateQueryStartTime == null || dutyDateQueryEndTime == null) {
            return new Tuple(Collections.emptyList(), null);
        }
        for (UnifyBillResult serviceResult : this.getBillInfoContext().getBillResult()) {
            if (attFileBoId != serviceResult.getAttFileBoId()) continue;
            for (UnifyBillEntryResult entryResult : serviceResult.getEntryResultList()) {
                if (entryResult.getDutyDateQueryStartTime().getTime() != dutyDateQueryStartTime.getTime() || entryResult.getDutyDateQueryEndTime().getTime() != dutyDateQueryEndTime.getTime()) continue;
                ApplyBillDutyDateErrorEnum errorEnum = entryResult.getBillDutyDateErrorEnum();
                List dutyDate = entryResult.getDutyInfos().stream().map(UnifyBillDutyInfoResult::getDutyDate).collect(Collectors.toList());
                return new Tuple(dutyDate, (Object)errorEnum);
            }
        }
        return new Tuple(Collections.emptyList(), null);
    }

    @Override
    protected Tuple<List<Date>, ApplyBillDutyDateErrorEnum> getResult(long billId, int entryIndex) {
        for (UnifyBillResult serviceResult : this.getBillInfoContext().getBillResult()) {
            if (serviceResult.getBillId() != billId) continue;
            for (UnifyBillEntryResult entryResult : serviceResult.getEntryResultList()) {
                if (entryResult.getEntryIndex() != entryIndex) continue;
                ApplyBillDutyDateErrorEnum errorEnum = entryResult.getBillDutyDateErrorEnum();
                List dutyDate = entryResult.getDutyInfos().stream().map(UnifyBillDutyInfoResult::getDutyDate).collect(Collectors.toList());
                return new Tuple(dutyDate, (Object)errorEnum);
            }
        }
        return new Tuple(Collections.emptyList(), null);
    }

    private List<Tuple<DutyShift, Shift>> getDutyShiftRange(List<UnifyBillResult> billCheckInfoList) {
        ArrayList countDutyShiftRange = Lists.newArrayListWithExpectedSize((int)16);
        for (UnifyBillResult billServiceResult : billCheckInfoList) {
            for (UnifyBillEntryResult billServiceEntryResult : billServiceResult.getEntryResultList()) {
                List dutyShiftRange = billServiceEntryResult.getDutyShiftRange();
                if (CollectionUtils.isEmpty((Collection)dutyShiftRange)) continue;
                countDutyShiftRange.addAll(dutyShiftRange);
            }
        }
        return countDutyShiftRange;
    }
}

