/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.matchcore.entry;

import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.wtc.wtbs.business.web.applybill.commonhelper.UnifyBillCommonHelper;
import kd.wtc.wtbs.business.web.applybill.matchcore.entry.AbstractUnifyEntryService;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.enums.bill.UnifyCallChainEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileScheduleQueryParam;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillDutyInfoResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillEntryResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillResult;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class UnifyEntryDutyPlanService
extends AbstractUnifyEntryService<Map<Date, DynamicObject>> {
    private static final Log LOG = LogFactory.getLog(UnifyEntryDutyPlanService.class);

    public UnifyEntryDutyPlanService(WtcAbstractUnityBillOperator operator) {
        super(operator);
    }

    @Override
    protected void matchProcess() {
        long costStart = System.currentTimeMillis();
        Set attIds = this.getBillInfoContext().getBillResult().stream().map(UnifyBillResult::getAttFileBoId).collect(Collectors.toSet());
        if (LOG.isInfoEnabled()) {
            LOG.info("UnifyEntryDutyPlanService.matchProcess> \u65b9\u6848\uff0cboid\u96c6\u5408\u4e3a{}", (Object)JSON.toJSONString(attIds));
        }
        AttFileScheduleEnum attFileScheduleEnum = this.getOperator().getUnifyBillEnum().getAttFileScheduleEnum();
        AttFileScheduleQueryParam queryParam = new AttFileScheduleQueryParam();
        queryParam.setFileBoIdSet(attIds);
        queryParam.setBusyStatus((Set)Sets.newHashSet((Object[])new String[]{"1"}));
        queryParam.setStartDate(this.getBillInfoContext().getUnifyBillCommonInfo().getMinDate());
        queryParam.setEndDate(this.getBillInfoContext().getUnifyBillCommonInfo().getMaxDate());
        AttFileScheduleServiceImpl attFileImpl = new AttFileScheduleServiceImpl();
        Map<Long, List<DynamicObject>> attFileFilePlanDys = attFileImpl.queryAttFileSchedule(attFileScheduleEnum, queryParam);
        if (LOG.isInfoEnabled()) {
            LOG.info("UnifyEntryDutyPlanService.matchProcess> plan in attFile\uff0cscheduleEnum={},minTime = {},maxTime = {},\u96c6\u5408key(\u6863\u6848id)\u4e3a{}\uff0csize={}", new Object[]{attFileScheduleEnum, this.getBillInfoContext().getUnifyBillCommonInfo().getMinDate(), this.getBillInfoContext().getUnifyBillCommonInfo().getMaxDate(), JSON.toJSONString(attFileFilePlanDys.keySet()), attFileFilePlanDys.size()});
        }
        Map<Long, List<DynamicObject>> planDyByAttFilePlan = UnifyBillCommonHelper.getPlanDyByAttFilePlan(attFileFilePlanDys, this.getOperator());
        this.matchByAllHisPlanList(attFileFilePlanDys, planDyByAttFilePlan);
        long costEnd = System.currentTimeMillis();
        LOG.info("UnifyEntryDutyPlanService.matchProcess \u5355\u636e\u7edf\u4e00\u6027\u80fd\u8017\u65f6 costStart={},costEnd={},cost={}", new Object[]{costStart, costEnd, costEnd - costStart});
    }

    @Override
    protected UnifyCallChainEnum defineUnifyCallChainEnum() {
        return UnifyCallChainEnum.matchPlanInfo;
    }

    @Override
    protected Map<Date, DynamicObject> getResult(long attFileBoId, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime) {
        List<UnifyBillDutyInfoResult> matchResult = UnifyBillCommonHelper.matchOneBillDutyDateInfo(attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime, null, this.getBillInfoContext().getBillResult());
        if (matchResult != null) {
            return matchResult.stream().collect(LinkedHashMap::new, (m1, v1) -> m1.put(v1.getDutyDate(), v1.getMatchPlanDy()), HashMap::putAll);
        }
        return Collections.emptyMap();
    }

    @Override
    protected Map<Date, DynamicObject> getResult(long billId, int entryIndex) {
        List<UnifyBillDutyInfoResult> matchResult = UnifyBillCommonHelper.matchDutyInfoByBillIdAndIndex(billId, entryIndex, this.getBillInfoContext().getBillResult());
        if (matchResult != null) {
            LOG.info("UnifyEntryDutyPlanService.getResult> \u5339\u914d\u65b9\u6848\u7ed3\u679c\u5927\u5c0f{}", (Object)matchResult.size());
            return matchResult.stream().collect(LinkedHashMap::new, (m1, v1) -> m1.put(v1.getDutyDate(), v1.getMatchPlanDy()), HashMap::putAll);
        }
        return Collections.emptyMap();
    }

    private void matchByAllHisPlanList(Map<Long, List<DynamicObject>> attFileFilePlanDys, Map<Long, List<DynamicObject>> hisPlanDys) {
        LOG.info("UnifyEntryDutyPlanService.matchByAllHisPlanList> begin");
        for (UnifyBillResult billServiceResult : this.getBillInfoContext().getBillResult()) {
            Long attFileBoId = billServiceResult.getAttFileBoId();
            for (UnifyBillEntryResult billServiceEntryResult : billServiceResult.getEntryResultList()) {
                this.setHisPlanToDutyInfo(hisPlanDys.get(attFileBoId), attFileFilePlanDys.get(attFileBoId), billServiceEntryResult, attFileBoId);
            }
        }
    }

    private void setHisPlanToDutyInfo(List<DynamicObject> hisPlanDys, List<DynamicObject> attFileFilePlanDys, UnifyBillEntryResult billServiceEntryResult, Long attFileBoId) {
        AttFileScheduleEnum attFileScheduleEnum = this.getOperator().getUnifyBillEnum().getAttFileScheduleEnum();
        for (UnifyBillDutyInfoResult billDutyDateCheckInfo : billServiceEntryResult.getDutyInfos()) {
            Date queryDate = billDutyDateCheckInfo.getDutyDate();
            LOG.info("UnifyEntryDutyPlanService.setHisPlanToDutyInfo> \u6863\u6848id:{}\uff0c\u65f6\u95f4\uff1a{}", (Object)attFileBoId, (Object)queryDate);
            if (CollectionUtils.isEmpty(hisPlanDys)) continue;
            DynamicObject matchPlan = null;
            for (DynamicObject attFileFilePlanDy : attFileFilePlanDys) {
                long attPlanBoId;
                DynamicObject seqHisDyByDate;
                if (!WTCDateUtils.betweenDay((Date)queryDate, (Date)attFileFilePlanDy.getDate("startdate"), (Date)attFileFilePlanDy.getDate("enddate")) || (seqHisDyByDate = UnifyBillCommonHelper.getSeqHisDyByDate(attPlanBoId = attFileFilePlanDy.getLong(WTCStringUtils.joinStr((String[])new String[]{attFileScheduleEnum.getKey(), ".", "id"})), queryDate, hisPlanDys)) == null) continue;
                LOG.info("UnifyEntryDutyPlanService.setHisPlanToDutyInfo> \u83b7\u53d6\u5386\u53f2\u7248\u672c\u7684\u65b9\u6848pkId = {}", seqHisDyByDate.getPkValue());
                if (attPlanBoId != HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)seqHisDyByDate, (String)"boid")) continue;
                matchPlan = seqHisDyByDate;
            }
            if (matchPlan == null) continue;
            billDutyDateCheckInfo.setMatchPlanDy(matchPlan);
        }
    }
}

