/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.matchcore.entry;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.wtc.wtbs.business.web.applybill.matchcore.entry.AbstractUnifyEntryService;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.common.enums.bill.UnifyCallChainEnum;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillEntryResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillResult;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;

public class UnifyEntryDutyShiftService
extends AbstractUnifyEntryService<Map<Date, DutyShift>> {
    public UnifyEntryDutyShiftService(WtcAbstractUnityBillOperator operator) {
        super(operator);
    }

    @Override
    protected void matchProcess() {
    }

    @Override
    protected UnifyCallChainEnum defineUnifyCallChainEnum() {
        return UnifyCallChainEnum.matchShift;
    }

    @Override
    protected Map<Date, DutyShift> getResult(long attFileBoId, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime) {
        if (dutyDateQueryStartTime == null || dutyDateQueryEndTime == null) {
            return Collections.emptyMap();
        }
        for (UnifyBillResult billServiceResult : this.getBillInfoContext().getBillResult()) {
            if (attFileBoId != billServiceResult.getAttFileBoId()) continue;
            for (UnifyBillEntryResult billServiceEntryResult : billServiceResult.getEntryResultList()) {
                if (billServiceEntryResult.getDutyDateQueryStartTime().getTime() != dutyDateQueryStartTime.getTime() || billServiceEntryResult.getDutyDateQueryEndTime().getTime() != dutyDateQueryEndTime.getTime()) continue;
                return billServiceEntryResult.getDutyInfos().stream().collect(LinkedHashMap::new, (m1, v1) -> m1.put(v1.getDutyDate(), v1.getDutyShift()), HashMap::putAll);
            }
        }
        return Collections.emptyMap();
    }

    @Override
    protected Map<Date, DutyShift> getResult(long billId, int entryIndex) {
        for (UnifyBillResult billServiceResult : this.getBillInfoContext().getBillResult()) {
            if (billServiceResult.getBillId() != billId) continue;
            for (UnifyBillEntryResult billServiceEntryResult : billServiceResult.getEntryResultList()) {
                if (billServiceEntryResult.getEntryIndex() != entryIndex) continue;
                return billServiceEntryResult.getDutyInfos().stream().collect(LinkedHashMap::new, (m1, v1) -> m1.put(v1.getDutyDate(), v1.getDutyShift()), HashMap::putAll);
            }
        }
        return Collections.emptyMap();
    }
}

