/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.matchcore.entry;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.Tuple;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.wtc.wtbs.business.web.applybill.matchcore.entry.AbstractUnifyEntryService;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.common.enums.bill.UnifyCallChainEnum;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillEntryResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillResult;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class UnifyEntryEachDateShiftService
extends AbstractUnifyEntryService<List<Date>> {
    private static final Log LOG = LogFactory.getLog(UnifyEntryEachDateShiftService.class);

    public UnifyEntryEachDateShiftService(WtcAbstractUnityBillOperator operator) {
        super(operator);
    }

    @Override
    protected void matchProcess() {
        long costStart = System.currentTimeMillis();
        for (UnifyBillResult billServiceResult : this.getBillInfoContext().getBillResult()) {
            for (UnifyBillEntryResult billServiceEntryResult : billServiceResult.getEntryResultList()) {
                UnifyEntryEachDateShiftService.verifyHaveShitEachDate(billServiceEntryResult);
            }
        }
        long costEnd = System.currentTimeMillis();
        LOG.info("UnifyEntryEachDateShiftService.matchProcess \u5355\u636e\u7edf\u4e00\u6027\u80fd\u8017\u65f6 costStart={},costEnd={},cost={}", new Object[]{costStart, costEnd, costEnd - costStart});
    }

    @Override
    protected UnifyCallChainEnum defineUnifyCallChainEnum() {
        return UnifyCallChainEnum.matchEachDateWithNoShift;
    }

    @Override
    protected List<Date> getResult(long attFileBoId, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime) {
        if (dutyDateQueryStartTime == null || dutyDateQueryEndTime == null) {
            return Collections.emptyList();
        }
        for (UnifyBillResult billServiceResult : this.getBillInfoContext().getBillResult()) {
            if (attFileBoId != billServiceResult.getAttFileBoId()) continue;
            for (UnifyBillEntryResult entryResult : billServiceResult.getEntryResultList()) {
                if (entryResult.getDutyDateQueryStartTime().getTime() != dutyDateQueryStartTime.getTime() || entryResult.getDutyDateQueryEndTime().getTime() != dutyDateQueryEndTime.getTime()) continue;
                return entryResult.getNoShiftDate();
            }
        }
        return Collections.emptyList();
    }

    @Override
    protected List<Date> getResult(long billId, int entryIndex) {
        for (UnifyBillResult billServiceResult : this.getBillInfoContext().getBillResult()) {
            if (billServiceResult.getBillId() != billId) continue;
            for (UnifyBillEntryResult entryResult : billServiceResult.getEntryResultList()) {
                if (entryResult.getEntryIndex() != entryIndex) continue;
                return entryResult.getNoShiftDate();
            }
        }
        return Collections.emptyList();
    }

    private static void verifyHaveShitEachDate(UnifyBillEntryResult billServiceEntryResult) {
        List<Tuple<Date, Boolean>> dateAndShiftResult = UnifyEntryEachDateShiftService.haveShitEachDate(billServiceEntryResult);
        ArrayList failHaveShiftDate = Lists.newArrayListWithExpectedSize((int)dateAndShiftResult.size());
        for (Tuple<Date, Boolean> dateBooleanTuple : dateAndShiftResult) {
            Date date = (Date)dateBooleanTuple.item1;
            if (LOG.isInfoEnabled()) {
                LOG.info("UnifyEntryEachDateShiftService.verifyHaveShitEachDate date = {},haveShift={}", (Object)JSON.toJSONString((Object)date), dateBooleanTuple.item2);
            }
            if (((Boolean)dateBooleanTuple.item2).booleanValue()) continue;
            failHaveShiftDate.add(date);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("UnifyEntryEachDateShiftService.verifyHaveShitEachDate failHaveShiftDate = {}", (Object)JSON.toJSONString((Object)failHaveShiftDate));
        }
        billServiceEntryResult.setNoShiftDate((List)failHaveShiftDate);
    }

    private static List<Tuple<Date, Boolean>> haveShitEachDate(UnifyBillEntryResult billServiceEntryResult) {
        ArrayList dateRange = Lists.newArrayListWithExpectedSize((int)10);
        Date lastDate = billServiceEntryResult.getDutyDateQueryStartTime();
        Date endDate = billServiceEntryResult.getDutyDateQueryEndTime();
        if (null == lastDate || null == endDate) {
            return Lists.newArrayListWithExpectedSize((int)10);
        }
        Date lastDateInBegin = WTCDateUtils.getDayStartTime((Date)lastDate);
        Date endDateInBegin = WTCDateUtils.getDayStartTime((Date)endDate);
        while (lastDateInBegin.getTime() <= endDateInBegin.getTime()) {
            dateRange.add(lastDateInBegin);
            lastDateInBegin = HRDateTimeUtils.addDay((Date)lastDateInBegin, (long)1L);
        }
        List dutyShiftRange = billServiceEntryResult.getDutyShiftRange();
        LOG.info("UnifyEntryEachDateShiftService.haveShitEachDate shiftRangeSize={}", (Object)dutyShiftRange.size());
        if (LOG.isDebugEnabled()) {
            LOG.debug("UnifyEntryEachDateShiftService.haveShitEachDate dateRange={}", (Object)JSON.toJSONString((Object)dateRange));
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)10);
        for (Date date : dateRange) {
            Date dayStart = WTCDateUtils.getDayStartTime((Date)date);
            Boolean match = Boolean.FALSE;
            for (Tuple dutyShiftShiftTuple : dutyShiftRange) {
                Date rosterDate = ((DutyShift)dutyShiftShiftTuple.item1).getRosterDate();
                Date rosterDateStart = WTCDateUtils.getDayStartTime((Date)rosterDate);
                if (!HRDateTimeUtils.format((Date)dayStart, (String)"yyyy-MM-dd").equals(HRDateTimeUtils.format((Date)rosterDateStart, (String)"yyyy-MM-dd"))) continue;
                match = Boolean.TRUE;
                break;
            }
            result.add(new Tuple((Object)dayStart, (Object)match));
        }
        return result;
    }
}

