/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.matchcore.entry;

import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.web.applybill.matchcore.entry.AbstractUnifyEntryService;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.common.enums.WTTESystemParamEnum;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.enums.bill.UnifyCallChainEnum;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillDutyInfoResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillEntryResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillResult;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTTESystemParamQueryUtil;

public class UnifyEntryFrozenService
extends AbstractUnifyEntryService<Map<Date, Tuple<Date, Date>>> {
    private static final Log LOG = LogFactory.getLog(UnifyEntryFrozenService.class);

    public UnifyEntryFrozenService(WtcAbstractUnityBillOperator operator) {
        super(operator);
    }

    @Override
    protected void matchProcess() {
        long costStart = System.currentTimeMillis();
        boolean inFrozen = false;
        BillTypeEnum billTypeEnum = this.getOperator().getUnifyBillEnum().getBillTypeEnum();
        if (WTTESystemParamQueryUtil.getFreezeSystemParam((WTTESystemParamEnum)WTTESystemParamEnum.BILL)) {
            inFrozen = WTTESystemParamQueryUtil.getBillTypeSystemParam((long)billTypeEnum.getFrozenBillTypeId());
        }
        if (!inFrozen) {
            for (UnifyBillResult serviceResult : this.getBillInfoContext().getBillResult()) {
                for (UnifyBillEntryResult billServiceEntryResult : serviceResult.getEntryResultList()) {
                    UnifyEntryFrozenService.setFrozenToDutyInfo(Collections.emptyMap(), serviceResult.getAttFileBoId(), billServiceEntryResult);
                }
            }
            return;
        }
        List attFileBos = this.getBillInfoContext().getBillResult().stream().map(UnifyBillResult::getAttFileBoId).collect(Collectors.toList());
        if (LOG.isInfoEnabled()) {
            LOG.info("UnifyEntryFrozenService.matchProcess query attFileBos = {}", (Object)JSON.toJSONString(attFileBos));
        }
        Map storageMap = (Map)WTCServiceHelper.invokeWtcWtpBizService("IAttStateInfoService", "queryFrozenScopeByFileBoId", attFileBos);
        if (LOG.isInfoEnabled()) {
            LOG.info("UnifyEntryFrozenService.matchProcess  IAttStateInfoService.queryFrozenScopeByFileBoId  storageMap = {}", (Object)JSON.toJSONString((Object)storageMap));
        }
        for (UnifyBillResult serviceResult : this.getBillInfoContext().getBillResult()) {
            Long attFileBoId = serviceResult.getAttFileBoId();
            for (UnifyBillEntryResult billServiceEntryResult : serviceResult.getEntryResultList()) {
                UnifyEntryFrozenService.setFrozenToDutyInfo(storageMap, attFileBoId, billServiceEntryResult);
            }
        }
        long costEnd = System.currentTimeMillis();
        LOG.info("UnifyEntryFrozenService.matchProcess \u5355\u636e\u7edf\u4e00\u6027\u80fd\u8017\u65f6 costStart={},costEnd={},cost={}", new Object[]{costStart, costEnd, costEnd - costStart});
    }

    @Override
    protected UnifyCallChainEnum defineUnifyCallChainEnum() {
        return UnifyCallChainEnum.matchFrozenInfo;
    }

    @Override
    protected Map<Date, Tuple<Date, Date>> getResult(long attFileBoId, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime) {
        if (dutyDateQueryStartTime == null || dutyDateQueryEndTime == null) {
            return Collections.emptyMap();
        }
        for (UnifyBillResult billServiceResult : this.getBillInfoContext().getBillResult()) {
            if (attFileBoId != billServiceResult.getAttFileBoId()) continue;
            for (UnifyBillEntryResult billServiceEntryResult : billServiceResult.getEntryResultList()) {
                if (billServiceEntryResult.getDutyDateQueryStartTime().getTime() != dutyDateQueryStartTime.getTime() || billServiceEntryResult.getDutyDateQueryEndTime().getTime() != dutyDateQueryEndTime.getTime()) continue;
                return UnifyEntryFrozenService.getFrozenByDutyInfo(billServiceEntryResult);
            }
        }
        return Collections.emptyMap();
    }

    @Override
    protected Map<Date, Tuple<Date, Date>> getResult(long billId, int entryIndex) {
        for (UnifyBillResult billServiceResult : this.getBillInfoContext().getBillResult()) {
            if (billServiceResult.getBillId() != billId) continue;
            for (UnifyBillEntryResult billServiceEntryResult : billServiceResult.getEntryResultList()) {
                if (billServiceEntryResult.getEntryIndex() != entryIndex) continue;
                return UnifyEntryFrozenService.getFrozenByDutyInfo(billServiceEntryResult);
            }
        }
        return Collections.emptyMap();
    }

    private static void setFrozenToDutyInfo(Map<Long, Map<Date, Date>> storageMap, Long attFileBoId, UnifyBillEntryResult billServiceEntryResult) {
        block0: for (UnifyBillDutyInfoResult dutyInfo : billServiceEntryResult.getDutyInfos()) {
            Date dutyDate = dutyInfo.getDutyDate();
            Map<Date, Date> frozenDate = storageMap.get(attFileBoId);
            if (CollectionUtils.isEmpty(frozenDate)) {
                dutyInfo.setFrozenCheckResult(Boolean.TRUE);
                continue;
            }
            Set<Map.Entry<Date, Date>> entries = frozenDate.entrySet();
            for (Map.Entry<Date, Date> entry : entries) {
                Date startFrozenDate = entry.getKey();
                Date endFrozenDate = entry.getValue();
                if (!Objects.nonNull(startFrozenDate) || !Objects.nonNull(endFrozenDate) || !WTCDateUtils.betweenDay((Date)dutyDate, (Date)startFrozenDate, (Date)endFrozenDate)) continue;
                dutyInfo.setFrozenCheckResult(Boolean.FALSE);
                dutyInfo.setFrozenStartTime(startFrozenDate);
                dutyInfo.setFrozenEndTime(endFrozenDate);
                continue block0;
            }
        }
    }

    private static Map<Date, Tuple<Date, Date>> getFrozenByDutyInfo(UnifyBillEntryResult billServiceEntryResult) {
        List billDutyDateCheckInfos = billServiceEntryResult.getDutyInfos();
        LinkedHashMap<Date, Tuple<Date, Date>> result = new LinkedHashMap<Date, Tuple<Date, Date>>(billDutyDateCheckInfos.size());
        for (UnifyBillDutyInfoResult billDutyDateCheckInfo : billDutyDateCheckInfos) {
            result.put(billDutyDateCheckInfo.getDutyDate(), (Tuple<Date, Date>)new Tuple((Object)billDutyDateCheckInfo.getFrozenStartTime(), (Object)billDutyDateCheckInfo.getFrozenEndTime()));
        }
        return result;
    }
}

