/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.matchcore.entry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.web.applybill.commonhelper.UnifyBillCommonHelper;
import kd.wtc.wtbs.business.web.applybill.matchcore.entry.AbstractUnifyEntryService;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.business.web.billservice.attfile.BillAttFileService;
import kd.wtc.wtbs.common.enums.bill.UnifyCallChainEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyRuleEnum;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillDutyInfoResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillEntryResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillResult;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class UnifyEntryRuleService
extends AbstractUnifyEntryService<Map<Date, DynamicObject>> {
    private static final Log LOG = LogFactory.getLog(UnifyEntryRuleService.class);

    public UnifyEntryRuleService(WtcAbstractUnityBillOperator operator) {
        super(operator);
    }

    @Override
    protected void matchProcess() {
        long costStart = System.currentTimeMillis();
        ArrayList<Long> planRuleBoIds = new ArrayList<Long>(10);
        for (UnifyBillResult billServiceResult : this.getBillInfoContext().getBillResult()) {
            planRuleBoIds.addAll(this.getAllRuleBoIdByPlan(billServiceResult));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("UnifyEntryRuleService.matchProcess> \u89c4\u5219boid\u96c6\u5408:{}", planRuleBoIds);
        }
        UnifyRuleEnum ruleEnum = this.getOperator().getUnifyBillEnum().getUnifyPlanEnum().getRuleEnum();
        DynamicObject[] rules = UnifyBillCommonHelper.getAllSeqHisDys(ruleEnum.getEntityNumber(), this.getBillInfoContext().getUnifyBillCommonInfo().getMinDate(), this.getBillInfoContext().getUnifyBillCommonInfo().getMaxDate(), Sets.newHashSet(planRuleBoIds));
        this.matchToBillBaseByRuleList(rules);
        long costEnd = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug("UnifyEntryRuleService.matchProcess \u5355\u636e\u7edf\u4e00\u6027\u80fd\u8017\u65f6 costStart={},costEnd={},cost={}", new Object[]{costStart, costEnd, costEnd - costStart});
        }
    }

    @Override
    protected UnifyCallChainEnum defineUnifyCallChainEnum() {
        return UnifyCallChainEnum.matchRuleInfo;
    }

    @Override
    protected Map<Date, DynamicObject> getResult(long attFileBoId, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime) {
        List<UnifyBillDutyInfoResult> matchResult = UnifyBillCommonHelper.matchOneBillDutyDateInfo(attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime, null, this.getBillInfoContext().getBillResult());
        if (matchResult != null) {
            return matchResult.stream().collect(LinkedHashMap::new, (m1, v1) -> m1.put(v1.getDutyDate(), v1.getMatchRuleDy()), HashMap::putAll);
        }
        return Collections.emptyMap();
    }

    @Override
    protected Map<Date, DynamicObject> getResult(long billId, int entryIndex) {
        List<UnifyBillDutyInfoResult> matchResult = UnifyBillCommonHelper.matchDutyInfoByBillIdAndIndex(billId, entryIndex, this.getBillInfoContext().getBillResult());
        if (matchResult != null) {
            return matchResult.stream().collect(LinkedHashMap::new, (m1, v1) -> m1.put(v1.getDutyDate(), v1.getMatchRuleDy()), HashMap::putAll);
        }
        return Collections.emptyMap();
    }

    private List<Long> getAllRuleBoIdByPlan(UnifyBillResult billServiceResult) {
        ArrayList<Long> planRuleBoIds = new ArrayList<Long>(10);
        Map<Long, List<DynamicObject>> attFileVersionIdAndDy = UnifyBillCommonHelper.getAttFileVersionIdAndDy(this.getOperator());
        BillAttFileService attFileService = BillAttFileService.getInstance();
        for (UnifyBillEntryResult billServiceEntryResult : billServiceResult.getEntryResultList()) {
            for (UnifyBillDutyInfoResult billServiceResultDutyInfo : billServiceEntryResult.getDutyInfos()) {
                Date engineQueryDate = billServiceResultDutyInfo.getEntryMainDutyDate();
                engineQueryDate = engineQueryDate == null ? billServiceResultDutyInfo.getDutyDate() : engineQueryDate;
                DynamicObject matchEngineAttFileVersion = attFileService.getAttFileVersionByDate(attFileVersionIdAndDy.get(billServiceResult.getAttFileBoId()), engineQueryDate);
                planRuleBoIds.add(UnifyBillCommonHelper.getRuleBoIdByPlanDy(billServiceResultDutyInfo.getMatchPlanDy(), WTCDateUtils.toLocalDate((Date)engineQueryDate), matchEngineAttFileVersion, this.getOperator()));
            }
        }
        return planRuleBoIds;
    }

    private void matchToBillBaseByRuleList(DynamicObject[] allRules) {
        LOG.info("UnifyEntryRuleService.matchToBillBaseByRuleList> allRules.length = {}", (Object)allRules.length);
        for (UnifyBillResult billServiceResult : this.getBillInfoContext().getBillResult()) {
            for (UnifyBillEntryResult billServiceEntryResult : billServiceResult.getEntryResultList()) {
                this.setRuleToDutyInfo(allRules, billServiceEntryResult, billServiceResult.getAttFileBoId());
            }
        }
    }

    private void setRuleToDutyInfo(DynamicObject[] allRules, UnifyBillEntryResult billServiceEntryResult, long attFileBoId) {
        Map<Long, List<DynamicObject>> attFileVersionIdAndDy = UnifyBillCommonHelper.getAttFileVersionIdAndDy(this.getOperator());
        BillAttFileService attFileService = BillAttFileService.getInstance();
        for (UnifyBillDutyInfoResult billServiceResultDutyInfo : billServiceEntryResult.getDutyInfos()) {
            Date queryDate = billServiceResultDutyInfo.getDutyDate();
            Date engineQueryDate = billServiceResultDutyInfo.getEntryMainDutyDate();
            engineQueryDate = engineQueryDate == null ? billServiceResultDutyInfo.getDutyDate() : engineQueryDate;
            DynamicObject matchEngineAttFileVersion = attFileService.getAttFileVersionByDate(attFileVersionIdAndDy.get(attFileBoId), engineQueryDate);
            Long ruleBoId = UnifyBillCommonHelper.getRuleBoIdByPlanDy(billServiceResultDutyInfo.getMatchPlanDy(), WTCDateUtils.toLocalDate((Date)engineQueryDate), matchEngineAttFileVersion, this.getOperator());
            if (ruleBoId.equals(0L)) {
                LOG.info("UnifyEntryRuleService.setRuleToDutyInfo> not match");
                continue;
            }
            DynamicObject ruleHisDy = UnifyBillCommonHelper.getSeqHisDyByDate(ruleBoId, queryDate, Lists.newArrayList((Object[])allRules));
            LOG.info("UnifyEntryRuleService.setRuleToDutyInfo>  ruleHisDy == null?={}", (Object)(ruleHisDy == null ? 1 : 0));
            billServiceResultDutyInfo.setMatchRuleDy(ruleHisDy);
        }
    }
}

