/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.matchcore.entry;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.util.ApplyUtil;
import kd.wtc.wtbs.business.web.applybill.matchcore.entry.AbstractUnifyEntryService;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.common.enums.bill.UnifyCallChainEnum;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillEntryResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillResult;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.model.evaluation.DutyShiftResponse;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class UnifyEntryShiftRangeService
extends AbstractUnifyEntryService<List<Tuple<DutyShift, Shift>>> {
    private static final Log LOG = LogFactory.getLog(UnifyEntryShiftRangeService.class);

    public UnifyEntryShiftRangeService(WtcAbstractUnityBillOperator operator) {
        super(operator);
    }

    @Override
    protected void matchProcess() {
        long costStartShift = System.currentTimeMillis();
        List<Long> appFileBoIds = this.getBillInfoContext().getBillResult().stream().map(UnifyBillResult::getAttFileBoId).collect(Collectors.toList());
        DutyShiftResponse shiftResponse = ApplyUtil.getShift(appFileBoIds, HRDateTimeUtils.addDay((Date)this.getBillInfoContext().getUnifyBillCommonInfo().getMinDate(), (long)-3L), HRDateTimeUtils.addDay((Date)this.getBillInfoContext().getUnifyBillCommonInfo().getMaxDate(), (long)3L));
        long costEndShift = System.currentTimeMillis();
        LOG.info("UnifyEntryShiftRangeService.matchProcess costEndShift unifyBill cost costStart={},costEnd={},cost={}", new Object[]{costStartShift, costEndShift, costEndShift - costStartShift});
        long costStartAfterShift = System.currentTimeMillis();
        if (shiftResponse == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info("UnifyEntryShiftRangeService.matchProcess> dutyShift not exist\uff0cappFileBoIds = {}\uff0cstartDate= {}\uff0cendDate= {}", new Object[]{JSON.toJSON(appFileBoIds), this.getBillInfoContext().getUnifyBillCommonInfo().getMinDate(), this.getBillInfoContext().getUnifyBillCommonInfo().getMaxDate()});
            }
            for (UnifyBillResult serviceResult : this.getBillInfoContext().getBillResult()) {
                for (UnifyBillEntryResult entryResult : serviceResult.getEntryResultList()) {
                    entryResult.setDutyShiftRange(Collections.emptyList());
                }
            }
            return;
        }
        Map dutyShiftMap = shiftResponse.getDutyShiftOfFileMap();
        long costEndAfterShift = System.currentTimeMillis();
        LOG.info("UnifyEntryShiftRangeService.matchProcess costEndAfterShift unifyBill cost costStart={},costEnd={},cost={}", new Object[]{costStartAfterShift, costEndAfterShift, costEndAfterShift - costStartAfterShift});
        long costStartMatchShift = System.currentTimeMillis();
        if (CollectionUtils.isEmpty((Map)dutyShiftMap)) {
            LOG.info("UnifyEntryShiftRangeService.matchProcess> DutyShiftResponse result empty");
            for (UnifyBillResult serviceResult : this.getBillInfoContext().getBillResult()) {
                for (UnifyBillEntryResult entryResult : serviceResult.getEntryResultList()) {
                    entryResult.setDutyShiftRange(Collections.emptyList());
                }
            }
            return;
        }
        for (UnifyBillResult serviceResult : this.getBillInfoContext().getBillResult()) {
            this.setRangeToEntryResult(shiftResponse, serviceResult);
        }
        long costEndMatchShift = System.currentTimeMillis();
        LOG.info("UnifyEntryShiftRangeService.matchProcess costEndMatchShift unifyBill cost costStart={},costEnd={},cost={}", new Object[]{costStartMatchShift, costEndMatchShift, costEndMatchShift - costStartMatchShift});
        LOG.info("UnifyEntryShiftRangeService.matchProcess unifyBill cost costStart={},costEnd={},cost={}", new Object[]{costStartShift, costEndMatchShift, costEndMatchShift - costStartShift});
    }

    @Override
    protected UnifyCallChainEnum defineUnifyCallChainEnum() {
        return UnifyCallChainEnum.matchDutyShiftsRange;
    }

    @Override
    protected List<Tuple<DutyShift, Shift>> getResult(long attFileBoId, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime) {
        if (dutyDateQueryStartTime == null || dutyDateQueryEndTime == null) {
            return Collections.emptyList();
        }
        for (UnifyBillResult billServiceResult : this.getBillInfoContext().getBillResult()) {
            if (attFileBoId != billServiceResult.getAttFileBoId()) continue;
            for (UnifyBillEntryResult entryResult : billServiceResult.getEntryResultList()) {
                if (entryResult.getDutyDateQueryStartTime().getTime() != dutyDateQueryStartTime.getTime() || entryResult.getDutyDateQueryEndTime().getTime() != dutyDateQueryEndTime.getTime()) continue;
                return entryResult.getDutyShiftRange();
            }
        }
        return Collections.emptyList();
    }

    @Override
    protected List<Tuple<DutyShift, Shift>> getResult(long billId, int entryIndex) {
        for (UnifyBillResult billServiceResult : this.getBillInfoContext().getBillResult()) {
            if (billServiceResult.getBillId() != billId) continue;
            for (UnifyBillEntryResult entryResult : billServiceResult.getEntryResultList()) {
                if (entryResult.getEntryIndex() != entryIndex) continue;
                return entryResult.getDutyShiftRange();
            }
        }
        return Collections.emptyList();
    }

    private void setRangeToEntryResult(DutyShiftResponse shiftResponse, UnifyBillResult serviceResult) {
        for (UnifyBillEntryResult entryResult : serviceResult.getEntryResultList()) {
            List<Date> dateRange = this.getDateRange(entryResult.getDutyDateQueryStartTime(), entryResult.getDutyDateQueryEndTime());
            List dutyShiftList = dateRange.stream().map(date -> shiftResponse.getDutyShift(Long.valueOf(serviceResult.getAttFileBoId()), date)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            ArrayList matchShiftInfo = Lists.newArrayListWithExpectedSize((int)dateRange.size());
            for (DutyShift dutyShift : dutyShiftList) {
                Optional shiftOptional = shiftResponse.getShiftHisData(dutyShift.getShiftVid());
                if (!shiftOptional.isPresent()) continue;
                Shift shift = (Shift)shiftOptional.get();
                matchShiftInfo.add(new Tuple((Object)dutyShift, (Object)shift));
            }
            entryResult.setDutyShiftRange((List)matchShiftInfo);
        }
    }

    private List<Date> getDateRange(Date startTime, Date endTime) {
        Date startDate = HRDateTimeUtils.addDay((Date)WTCDateUtils.getDayStart((Date)startTime), (long)-3L);
        Date endDate = HRDateTimeUtils.addDay((Date)WTCDateUtils.getDayStart((Date)endTime), (long)3L);
        ArrayList dateRange = Lists.newArrayListWithExpectedSize((int)10);
        Date lastDate = startDate;
        while (lastDate.getTime() <= endDate.getTime()) {
            dateRange.add(lastDate);
            lastDate = HRDateTimeUtils.addDay((Date)lastDate, (long)1L);
        }
        return dateRange;
    }

    private boolean isEqual(String dateStr, Date date) {
        return HRStringUtils.equals((String)dateStr, (String)HRDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd"));
    }
}

