/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.matchcore.entry;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.web.applybill.matchcore.entry.AbstractUnifyEntryService;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.common.enums.bill.UnifyCallChainEnum;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillDutyInfoResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillEntryResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillResult;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.util.WTCDateUtils;

public class UnifyEntryShiftService
extends AbstractUnifyEntryService<Map<Date, Shift>> {
    private static final Log LOG = LogFactory.getLog(UnifyEntryShiftService.class);

    public UnifyEntryShiftService(WtcAbstractUnityBillOperator operator) {
        super(operator);
    }

    @Override
    protected void matchProcess() {
        for (UnifyBillResult unifyBillResult : this.getBillInfoContext().getBillResult()) {
            for (UnifyBillEntryResult unifyBillEntryResult : unifyBillResult.getEntryResultList()) {
                UnifyEntryShiftService.setShiftToDutyInfo(unifyBillEntryResult);
            }
        }
    }

    @Override
    protected UnifyCallChainEnum defineUnifyCallChainEnum() {
        return UnifyCallChainEnum.matchShift;
    }

    @Override
    protected Map<Date, Shift> getResult(long attFileBoId, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime) {
        if (dutyDateQueryStartTime == null || dutyDateQueryEndTime == null) {
            return Collections.emptyMap();
        }
        for (UnifyBillResult billServiceResult : this.getBillInfoContext().getBillResult()) {
            if (attFileBoId != billServiceResult.getAttFileBoId()) continue;
            for (UnifyBillEntryResult billServiceEntryResult : billServiceResult.getEntryResultList()) {
                if (billServiceEntryResult.getDutyDateQueryStartTime().getTime() != dutyDateQueryStartTime.getTime() || billServiceEntryResult.getDutyDateQueryEndTime().getTime() != dutyDateQueryEndTime.getTime()) continue;
                return billServiceEntryResult.getDutyInfos().stream().collect(LinkedHashMap::new, (m1, v1) -> m1.put(v1.getDutyDate(), v1.getShift()), HashMap::putAll);
            }
        }
        return Collections.emptyMap();
    }

    @Override
    protected Map<Date, Shift> getResult(long billId, int entryIndex) {
        for (UnifyBillResult billServiceResult : this.getBillInfoContext().getBillResult()) {
            if (billServiceResult.getBillId() != billId) continue;
            for (UnifyBillEntryResult billServiceEntryResult : billServiceResult.getEntryResultList()) {
                if (billServiceEntryResult.getEntryIndex() != entryIndex) continue;
                return billServiceEntryResult.getDutyInfos().stream().collect(LinkedHashMap::new, (m1, v1) -> m1.put(v1.getDutyDate(), v1.getShift()), HashMap::putAll);
            }
        }
        return Collections.emptyMap();
    }

    private static void setShiftToDutyInfo(UnifyBillEntryResult billServiceEntryResult) {
        List dutyShiftRange = billServiceEntryResult.getDutyShiftRange();
        for (UnifyBillDutyInfoResult dutyInfo : billServiceEntryResult.getDutyInfos()) {
            Date dutyDate = dutyInfo.getDutyDate();
            List collect = dutyShiftRange.stream().filter(item -> WTCDateUtils.compareDateWithDayTime((Date)dutyDate, (Date)((DutyShift)item.item1).getRosterDate())).collect(Collectors.toList());
            if (collect.size() <= 0) continue;
            Tuple shiftDate = (Tuple)collect.get(0);
            dutyInfo.setDutyShift((DutyShift)shiftDate.item1);
            dutyInfo.setShift((Shift)shiftDate.item2);
        }
    }
}

