/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.matchcore.entry;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.web.applybill.matchcore.entry.AbstractUnifyEntryService;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.common.enums.bill.UnifyCallChainEnum;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillDutyInfoResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillEntryResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillResult;

public class UnifyEntrySuspendService
extends AbstractUnifyEntryService<Map<Date, Boolean>> {
    private static final Log LOG = LogFactory.getLog(UnifyEntrySuspendService.class);

    public UnifyEntrySuspendService(WtcAbstractUnityBillOperator operator) {
        super(operator);
    }

    @Override
    protected void matchProcess() {
        long costStart = System.currentTimeMillis();
        for (UnifyBillResult billServiceResult : this.getBillInfoContext().getBillResult()) {
            for (UnifyBillEntryResult billServiceEntryResult : billServiceResult.getEntryResultList()) {
                this.setSuspendToDutyInfo(billServiceEntryResult);
            }
        }
        long costEnd = System.currentTimeMillis();
        LOG.info("UnifyEntrySuspendService.matchProcess \u5355\u636e\u7edf\u4e00\u6027\u80fd\u8017\u65f6 costStart={},costEnd={},cost={}", new Object[]{costStart, costEnd, costEnd - costStart});
    }

    @Override
    protected UnifyCallChainEnum defineUnifyCallChainEnum() {
        return UnifyCallChainEnum.matchSuspendInfo;
    }

    @Override
    protected Map<Date, Boolean> getResult(long attFileBoId, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime) {
        if (dutyDateQueryStartTime == null || dutyDateQueryEndTime == null) {
            return Collections.emptyMap();
        }
        for (UnifyBillResult serviceResult : this.getBillInfoContext().getBillResult()) {
            if (attFileBoId != serviceResult.getAttFileBoId()) continue;
            for (UnifyBillEntryResult billServiceEntryResult : serviceResult.getEntryResultList()) {
                if (billServiceEntryResult.getDutyDateQueryStartTime().getTime() != dutyDateQueryStartTime.getTime() || billServiceEntryResult.getDutyDateQueryEndTime().getTime() != dutyDateQueryEndTime.getTime()) continue;
                return billServiceEntryResult.getDutyInfos().stream().collect(LinkedHashMap::new, (m1, v1) -> m1.put(v1.getDutyDate(), v1.getCheckSuspendResult()), HashMap::putAll);
            }
        }
        return Collections.emptyMap();
    }

    @Override
    protected Map<Date, Boolean> getResult(long billId, int entryIndex) {
        for (UnifyBillResult serviceResult : this.getBillInfoContext().getBillResult()) {
            if (serviceResult.getBillId() != billId) continue;
            for (UnifyBillEntryResult billServiceEntryResult : serviceResult.getEntryResultList()) {
                if (billServiceEntryResult.getEntryIndex() != entryIndex) continue;
                return billServiceEntryResult.getDutyInfos().stream().collect(LinkedHashMap::new, (m1, v1) -> m1.put(v1.getDutyDate(), v1.getCheckSuspendResult()), HashMap::putAll);
            }
        }
        return Collections.emptyMap();
    }

    private void setSuspendToDutyInfo(UnifyBillEntryResult billServiceEntryResult) {
        for (UnifyBillDutyInfoResult dutyInfo : billServiceEntryResult.getDutyInfos()) {
            DynamicObject attFileVersion = dutyInfo.getAttFileVersion();
            if (attFileVersion == null) {
                dutyInfo.setCheckSuspendResult(Boolean.FALSE);
                LOG.info("UnifyEntrySuspendService_setSuspendToDutyInfo attFileVersion == null");
                continue;
            }
            dutyInfo.setCheckSuspendResult(Boolean.valueOf(this.ifSuspend(attFileVersion)));
        }
    }

    private boolean ifSuspend(DynamicObject attFileVersion) {
        String attStatus = attFileVersion.getString("atttag.attendstatus");
        return !HRStringUtils.equals((String)attStatus, (String)AttStatusEnum.ATT_STOP.getCode());
    }
}

