/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.matchcore.entry.extend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.wtc.wtbs.business.web.applybill.matchcore.entry.UnifyEntryDutyDateService;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.business.web.applybill.operatecore.extend.WtcAbstractUnityBillAutoOperator;
import kd.wtc.wtbs.business.web.applybill.service.BillEntityCheckService;
import kd.wtc.wtbs.common.enums.bill.UnifyCallChainEnum;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillDutyInfoResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillEntryResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillExpandInfo;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillResult;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class UnifyEntryDutyDateAutoService
extends UnifyEntryDutyDateService {
    public UnifyEntryDutyDateAutoService(WtcAbstractUnityBillOperator operator) {
        super(operator);
    }

    @Override
    public WtcAbstractUnityBillAutoOperator getOperator() {
        return (WtcAbstractUnityBillAutoOperator)super.getOperator();
    }

    @Override
    protected void matchProcess() {
        boolean startOrEnd = BillEntityCheckService.getCheckStartOrEnd();
        this.getOperator().superMatchDutyDate();
        this.getBillInfoContext().getInvokeStatusInfo().remove(UnifyCallChainEnum.matchDutyDate);
        for (UnifyBillResult serviceResult : this.getBillInfoContext().getBillResult()) {
            for (UnifyBillEntryResult billServiceEntryResult : serviceResult.getEntryResultList()) {
                UnifyBillExpandInfo expandInfo = (UnifyBillExpandInfo)billServiceEntryResult.getExpandInfo();
                String startMethod = expandInfo.getStartMethod();
                if (StringUtils.equals((CharSequence)startMethod, (CharSequence)"3")) continue;
                billServiceEntryResult.getDutyInfos().clear();
                billServiceEntryResult.setBillDutyDateErrorEnum(null);
                Date startTime = WTCDateUtils.getDayStartTime((Date)billServiceEntryResult.getDutyDateQueryStartTime());
                Date endTime = WTCDateUtils.getDayStartTime((Date)billServiceEntryResult.getDutyDateQueryEndTime());
                ArrayList dutyInfos = Lists.newArrayListWithExpectedSize((int)10);
                while (startTime.getTime() <= endTime.getTime()) {
                    dutyInfos.add(new UnifyBillDutyInfoResult(startTime));
                    startTime = HRDateTimeUtils.addDay((Date)startTime, (long)1L);
                }
                billServiceEntryResult.setDutyInfos((List)dutyInfos);
                billServiceEntryResult.setHaveCorrectDuty(Boolean.TRUE);
                Date mainDate = null;
                if (WTCCollections.isNotEmpty((Collection)dutyInfos)) {
                    if (startOrEnd && dutyInfos.get(0) != null) {
                        mainDate = ((UnifyBillDutyInfoResult)dutyInfos.get(0)).getDutyDate();
                    } else {
                        int lastIndex;
                        int n = lastIndex = dutyInfos.size() > 1 ? dutyInfos.size() - 1 : 0;
                        if (dutyInfos.get(lastIndex) != null) {
                            mainDate = ((UnifyBillDutyInfoResult)dutyInfos.get(lastIndex)).getDutyDate();
                        }
                    }
                }
                for (UnifyBillDutyInfoResult dutyInfo : dutyInfos) {
                    dutyInfo.setEntryMainDutyDate(mainDate);
                }
            }
        }
    }
}

