/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.matchcore.other;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.wtc.wtbs.business.web.applybill.matchcore.AbstractUnifyMatch;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.common.enums.bill.BillAttachmentErrorEnum;
import kd.wtc.wtbs.common.enums.bill.UnifyCallChainEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBaseSetEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.model.bill.BillSystemParam;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillAttachmentInfo;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillDutyInfoResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillEntryResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillResult;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;

public class UnifyAttachmentFileService
extends AbstractUnifyMatch {
    public UnifyAttachmentFileService(WtcAbstractUnityBillOperator operator) {
        super(operator);
    }

    @Override
    protected void matchProcess() {
    }

    @Override
    protected UnifyCallChainEnum defineUnifyCallChainEnum() {
        return UnifyCallChainEnum.matchAttachmentInfo;
    }

    public UnifyBillAttachmentInfo getResult(List<BigDecimal> attachmentInfoCapacity, Long billPkId) {
        if (attachmentInfoCapacity == null) {
            attachmentInfoCapacity = Collections.emptyList();
        }
        BillSystemParam billSystemParam = SystemParamQueryUtil.getBillSystemParam();
        UnifyBillAttachmentInfo attachmentInfo = new UnifyBillAttachmentInfo(null, null, billSystemParam.getMaxcapacity(), billSystemParam.getMaxuploadnums());
        boolean mustUploadFile = false;
        UnifyBillEnum unifyBillEnum = this.getOperator().getUnifyBillEnum();
        for (UnifyBillResult billServiceResult : this.getBillInfoContext().getBillResult()) {
            Long id = billServiceResult.getBillId();
            if (billPkId == null || !billPkId.equals(id)) continue;
            mustUploadFile = UnifyAttachmentFileService.setAttachmentResultToDutyInfo(mustUploadFile, unifyBillEnum.getUnifyPlanEnum().getRuleEnum().getUnifyRuleCalEntryEnum().getBaseSetEnum(), billServiceResult);
        }
        attachmentInfo.setMustUpLoad(Boolean.valueOf(mustUploadFile));
        boolean passNeedCheck = !mustUploadFile || !attachmentInfoCapacity.isEmpty();
        boolean passSize = attachmentInfoCapacity.size() <= attachmentInfo.getMaxUploadNums();
        boolean passCapacity = true;
        for (BigDecimal capacity : attachmentInfoCapacity) {
            if (capacity.compareTo(BigDecimal.valueOf(attachmentInfo.getMaxCapacity().intValue())) <= 0) continue;
            passCapacity = false;
            break;
        }
        BillAttachmentErrorEnum billAttachmentErrorEnum = null;
        billAttachmentErrorEnum = passNeedCheck ? null : BillAttachmentErrorEnum.NEED_ERROR;
        billAttachmentErrorEnum = billAttachmentErrorEnum == null && !passCapacity ? BillAttachmentErrorEnum.CAPACITY_ERROR : billAttachmentErrorEnum;
        billAttachmentErrorEnum = billAttachmentErrorEnum == null && !passSize ? BillAttachmentErrorEnum.NUM_ERROR : billAttachmentErrorEnum;
        attachmentInfo.setBillAttachmentErrorEnum(billAttachmentErrorEnum);
        attachmentInfo.setAttachmentVerifyResult(Boolean.valueOf(passNeedCheck && passCapacity && passSize));
        return attachmentInfo;
    }

    private static boolean setAttachmentResultToDutyInfo(boolean mustUploadFile, UnifyBaseSetEnum unifyBaseSetEnum, UnifyBillResult billServiceResult) {
        block0: for (UnifyBillEntryResult billServiceEntryResult : billServiceResult.getEntryResultList()) {
            for (UnifyBillDutyInfoResult dutyInfo : billServiceEntryResult.getDutyInfos()) {
                DynamicObject baseSet = dutyInfo.getMatchBaseSet();
                if (baseSet == null || !baseSet.getBoolean(unifyBaseSetEnum.getFieldNeedAttachmentFile())) continue;
                mustUploadFile = true;
                continue block0;
            }
        }
        return mustUploadFile;
    }
}

