/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.operatecore;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.wtc.wtbs.business.web.applybill.commonhelper.UnifyBillCommonHelper;
import kd.wtc.wtbs.business.web.applybill.matchcore.afterrulecal.UnifyARCAdvanceAndAfterService;
import kd.wtc.wtbs.business.web.applybill.matchcore.afterrulecal.UnifyARCBaseSetService;
import kd.wtc.wtbs.business.web.applybill.matchcore.afterrulecal.UnifyARCChangeSetService;
import kd.wtc.wtbs.business.web.applybill.matchcore.afterrulecal.UnifyARCRuleCalService;
import kd.wtc.wtbs.business.web.applybill.matchcore.attfile.UnifyAttFileAllVersionService;
import kd.wtc.wtbs.business.web.applybill.matchcore.attfile.UnifyAttFileAuthService;
import kd.wtc.wtbs.business.web.applybill.matchcore.attfile.UnifyAttFileHisAuthService;
import kd.wtc.wtbs.business.web.applybill.matchcore.attfile.UnifyAttFilePlanService;
import kd.wtc.wtbs.business.web.applybill.matchcore.attfile.UnifyAttFileRuleService;
import kd.wtc.wtbs.business.web.applybill.matchcore.attfile.UnifyAttFileTypeService;
import kd.wtc.wtbs.business.web.applybill.matchcore.entry.UnifyEntryAttFileVersionService;
import kd.wtc.wtbs.business.web.applybill.matchcore.entry.UnifyEntryDutyAuthService;
import kd.wtc.wtbs.business.web.applybill.matchcore.entry.UnifyEntryDutyDateService;
import kd.wtc.wtbs.business.web.applybill.matchcore.entry.UnifyEntryDutyPlanService;
import kd.wtc.wtbs.business.web.applybill.matchcore.entry.UnifyEntryDutyShiftService;
import kd.wtc.wtbs.business.web.applybill.matchcore.entry.UnifyEntryEachDateShiftService;
import kd.wtc.wtbs.business.web.applybill.matchcore.entry.UnifyEntryFrozenService;
import kd.wtc.wtbs.business.web.applybill.matchcore.entry.UnifyEntryRuleService;
import kd.wtc.wtbs.business.web.applybill.matchcore.entry.UnifyEntryShiftRangeService;
import kd.wtc.wtbs.business.web.applybill.matchcore.entry.UnifyEntryShiftService;
import kd.wtc.wtbs.business.web.applybill.matchcore.entry.UnifyEntrySuspendService;
import kd.wtc.wtbs.business.web.applybill.matchcore.other.UnifyAttachmentFileService;
import kd.wtc.wtbs.business.web.applybill.service.BillEntityCheckService;
import kd.wtc.wtbs.common.enums.bill.ApplyBillDutyDateErrorEnum;
import kd.wtc.wtbs.common.enums.bill.UnifyCallChainEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillAdvanceAfterInfo;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyInitInfo;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyServiceEntryInitInfo;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillAttachmentInfo;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillEntryResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillInfoContext;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillResult;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public abstract class WtcAbstractUnityBillOperator {
    private boolean useStartOrEnd = BillEntityCheckService.getCheckStartOrEnd();
    private static final Log logger = LogFactory.getLog(WtcAbstractUnityBillOperator.class);
    private UnifyBillInfoContext infoContext;
    private Map<UnifyCallChainEnum, Runnable> callEnumAndMatchMap = new EnumMap<UnifyCallChainEnum, Runnable>(UnifyCallChainEnum.class);

    public abstract UnifyBillEnum getUnifyBillEnum();

    protected WtcAbstractUnityBillOperator(UnifyBillInfoContext infoContext) {
        this.infoContext = infoContext;
        this.runRegister();
    }

    protected WtcAbstractUnityBillOperator(UnifyBillInfoContext infoContext, List<DynamicObject> billLists, UnifyBillEnum billType) {
        this.infoContext = infoContext;
        this.infoContext.setBillDys(billLists);
        this.infoContext.setBillType(billType);
        this.runRegister();
    }

    public boolean isUseStartOrEnd() {
        return this.useStartOrEnd;
    }

    private void runRegister() {
        this.register();
    }

    protected void register() {
        this.callEnumAndMatchMap.put(UnifyCallChainEnum.init, this::init);
        this.callEnumAndMatchMap.put(UnifyCallChainEnum.matchAttFileAuth, this::matchAttFileAuth);
        this.callEnumAndMatchMap.put(UnifyCallChainEnum.matchAttFileAuthDy, this::matchAttFileHisAuth);
        this.callEnumAndMatchMap.put(UnifyCallChainEnum.matchAttFileAllVersion, this::matchAttFileAllVersion);
        this.callEnumAndMatchMap.put(UnifyCallChainEnum.matchAllPlan, this::matchAllPlan);
        this.callEnumAndMatchMap.put(UnifyCallChainEnum.matchAllRule, this::matchAllRule);
        this.callEnumAndMatchMap.put(UnifyCallChainEnum.matchAllType, this::matchAllType);
        this.callEnumAndMatchMap.put(UnifyCallChainEnum.matchDutyShiftsRange, this::matchDutyShiftsRange);
        this.callEnumAndMatchMap.put(UnifyCallChainEnum.matchEachDateWithNoShift, this::matchEachDateWithNoShift);
        this.callEnumAndMatchMap.put(UnifyCallChainEnum.matchDutyDate, this::matchDutyDate);
        this.callEnumAndMatchMap.put(UnifyCallChainEnum.matchAttFileVersion, this::matchAttFileVersion);
        this.callEnumAndMatchMap.put(UnifyCallChainEnum.matchShift, this::matchShift);
        this.callEnumAndMatchMap.put(UnifyCallChainEnum.matchPlanInfo, this::matchPlanInfo);
        this.callEnumAndMatchMap.put(UnifyCallChainEnum.matchRuleInfo, this::matchRuleInfo);
        this.callEnumAndMatchMap.put(UnifyCallChainEnum.matchRuleCalInfo, this::matchRuleCalInfo);
        this.callEnumAndMatchMap.put(UnifyCallChainEnum.matchBaseSetInfo, this::matchBaseSetInfo);
        this.callEnumAndMatchMap.put(UnifyCallChainEnum.matchChangeSetInfo, this::matchChangeSetInfo);
        this.callEnumAndMatchMap.put(UnifyCallChainEnum.matchFrozenInfo, this::matchFrozenInfo);
        this.callEnumAndMatchMap.put(UnifyCallChainEnum.matchSuspendInfo, this::matchSuspendInfo);
        this.callEnumAndMatchMap.put(UnifyCallChainEnum.matchAdvanceAndAfter, this::matchAdvanceAndAfter);
        this.callEnumAndMatchMap.put(UnifyCallChainEnum.matchDutyAuth, this::matchDutyAuth);
    }

    public Map<UnifyCallChainEnum, Runnable> getCallEnumAndMatchMap() {
        return this.callEnumAndMatchMap;
    }

    public void invokeEvent(List<UnifyCallChainEnum> unifyCallChainEnums) {
        for (UnifyCallChainEnum unifyCallChainEnum : unifyCallChainEnums) {
            Runnable runnable = this.callEnumAndMatchMap.get(unifyCallChainEnum);
            if (runnable == null) continue;
            runnable.run();
        }
    }

    public void init() {
        if (this.getInfoContext().getInvokeStatusInfo().containsKey(UnifyCallChainEnum.init)) {
            return;
        }
        this.getInfoContext().getInvokeStatusInfo().put(UnifyCallChainEnum.init, this);
        if (logger.isDebugEnabled()) {
            logger.debug("WtcAbstractApplyBillService.init.\u521d\u59cb\u5316\u4fe1\u606f:{}", (Object)this.infoContext.getInitInfos());
        }
        ArrayList resultInfos = Lists.newArrayListWithExpectedSize((int)10);
        for (UnifyBillApplyInitInfo billApplyServiceInitInfo : this.infoContext.getInitInfos()) {
            ArrayList entryResults = Lists.newArrayListWithExpectedSize((int)billApplyServiceInitInfo.getEntryInitInfoList().size());
            for (UnifyBillApplyServiceEntryInitInfo entryInitInfo : billApplyServiceInitInfo.getEntryInitInfoList()) {
                Date entryEndDate;
                Date entryStartDate = entryInitInfo.getDutyDateQueryStartTime();
                if (entryStartDate != null) {
                    entryStartDate = WTCDateUtils.getDayStartTime((Date)entryStartDate);
                    entryStartDate = HRDateTimeUtils.addDay((Date)entryStartDate, (long)-3L);
                }
                if ((entryEndDate = entryInitInfo.getDutyDateQueryEndTime()) != null) {
                    entryEndDate = WTCDateUtils.getDayStartTime((Date)entryEndDate);
                    entryEndDate = HRDateTimeUtils.addDay((Date)entryEndDate, (long)3L);
                }
                if (entryStartDate != null && entryStartDate.before(this.infoContext.getUnifyBillCommonInfo().getMinDate())) {
                    this.infoContext.getUnifyBillCommonInfo().setMinDate(entryStartDate);
                }
                if (entryEndDate != null && entryEndDate.after(this.infoContext.getUnifyBillCommonInfo().getMaxDate())) {
                    this.infoContext.getUnifyBillCommonInfo().setMaxDate(entryEndDate);
                }
                UnifyBillEntryResult billServiceEntryResult = new UnifyBillEntryResult(entryInitInfo);
                billServiceEntryResult.setBillEntryDy(entryInitInfo.getBillEntryDy());
                billServiceEntryResult.setExpandInfo(entryInitInfo.getExpandInfo());
                entryResults.add(billServiceEntryResult);
            }
            UnifyBillResult billServiceResult = new UnifyBillResult(billApplyServiceInitInfo.getBillId(), billApplyServiceInitInfo.getAttFileBoId(), (List)entryResults);
            billServiceResult.setBillDy(billApplyServiceInitInfo.getBillDy());
            billServiceResult.setExpandInfo(billApplyServiceInitInfo.getExpandInfo());
            resultInfos.add(billServiceResult);
        }
        this.infoContext.setBillResult((List)resultInfos);
    }

    public UnifyBillInfoContext getInfoContext() {
        return this.infoContext;
    }

    protected void matchAttFileAuth() {
        UnifyAttFileAuthService attFileAuthService = new UnifyAttFileAuthService(this);
        attFileAuthService.startMatch();
    }

    public void initAttFileAuth() {
        this.matchAttFileAuth();
    }

    public Boolean haveAttFileAuth(long attFileBoId) {
        UnifyAttFileAuthService attFileAuthService = new UnifyAttFileAuthService(this);
        return (Boolean)attFileAuthService.getUnifyResult(attFileBoId, this);
    }

    public void initAllAttFileVersion() {
        this.matchAttFileAllVersion();
    }

    protected void matchAttFileAllVersion() {
        UnifyAttFileAllVersionService service = new UnifyAttFileAllVersionService(this);
        service.startMatch();
    }

    public List<DynamicObject> getAttFileAllVersion(long attFileBoId) {
        UnifyAttFileAllVersionService service = new UnifyAttFileAllVersionService(this);
        return (List)service.getUnifyResult(attFileBoId, this);
    }

    public List<DynamicObject> getAllPlan(long attFileBoId) {
        UnifyAttFilePlanService service = new UnifyAttFilePlanService(this);
        return (List)service.getUnifyResult(attFileBoId, this);
    }

    public void initAllPlan() {
        this.matchAllPlan();
    }

    protected void matchAllPlan() {
        UnifyAttFilePlanService service = new UnifyAttFilePlanService(this);
        service.startMatch();
    }

    public List<DynamicObject> getAllRule(long attFileBoId) {
        UnifyAttFileRuleService service = new UnifyAttFileRuleService(this);
        return (List)service.getUnifyResult(attFileBoId, this);
    }

    public void initAllRule() {
        this.matchAllRule();
    }

    protected void matchAllRule() {
        UnifyAttFileRuleService service = new UnifyAttFileRuleService(this);
        service.startMatch();
    }

    public List<DynamicObject> getAllType(long attFileBoId) {
        UnifyAttFileTypeService service = new UnifyAttFileTypeService(this);
        return (List)service.getUnifyResult(attFileBoId, this);
    }

    public void initAllType() {
        this.matchAllType();
    }

    protected void matchAllType() {
        UnifyAttFileTypeService service = new UnifyAttFileTypeService(this);
        service.startMatch();
    }

    public List<Tuple<DutyShift, Shift>> getDutyShiftsRange(long attFileBoId, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime) {
        if (logger.isDebugEnabled()) {
            logger.debug("WtcAbstractApplyBillService.getDutyShiftsRange,attFileBoId={},dutyDateQueryStartTime={},dutyDateQueryEndTime={}", new Object[]{attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime});
        }
        UnifyEntryShiftRangeService service = new UnifyEntryShiftRangeService(this);
        return (List)service.getUnifyResult(attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime, this);
    }

    public void initDutyShiftsRange() {
        this.matchDutyShiftsRange();
    }

    protected void matchDutyShiftsRange() {
        UnifyEntryShiftRangeService service = new UnifyEntryShiftRangeService(this);
        service.startMatch();
    }

    public List<Date> getEachDateWithNoShift(long attFileBoId, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime) {
        if (logger.isDebugEnabled()) {
            logger.debug("WtcAbstractApplyBillService.getEachDateWithShift,attFileBoId={},dutyDateQueryStartTime={},dutyDateQueryEndTime={}", new Object[]{attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime});
        }
        UnifyEntryEachDateShiftService eachDateShiftService = new UnifyEntryEachDateShiftService(this);
        return (List)eachDateShiftService.getUnifyResult(attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime, this);
    }

    public void initEachDateWithNoShift() {
        this.matchEachDateWithNoShift();
    }

    protected void matchEachDateWithNoShift() {
        UnifyEntryEachDateShiftService eachDateShiftService = new UnifyEntryEachDateShiftService(this);
        eachDateShiftService.startMatch();
    }

    public Tuple<List<Date>, ApplyBillDutyDateErrorEnum> getDutyDate(long attFileBoId, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime) {
        if (logger.isDebugEnabled()) {
            logger.debug("WtcAbstractApplyBillService.getDutyDate,attFileBoId={},dutyDateQueryStartTime={},dutyDateQueryEndTime={}", new Object[]{attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime});
        }
        UnifyEntryDutyDateService dutyDateService = new UnifyEntryDutyDateService(this);
        return (Tuple)dutyDateService.getUnifyResult(attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime, this);
    }

    public void initDutyDate() {
        this.matchDutyDate();
    }

    protected void matchDutyDate() {
        UnifyEntryDutyDateService dutyDateService = new UnifyEntryDutyDateService(this);
        dutyDateService.startMatch();
    }

    public Map<Date, Shift> getShift(long attFileBoId, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime) {
        if (logger.isDebugEnabled()) {
            logger.debug("WtcAbstractApplyBillService.getShift,attFileBoId={},dutyDateQueryStartTime={},dutyDateQueryEndTime={}", new Object[]{attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime});
        }
        UnifyEntryShiftService shiftService = new UnifyEntryShiftService(this);
        return (Map)shiftService.getUnifyResult(attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime, this);
    }

    public Map<Date, DutyShift> getDutyShift(long attFileBoId, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime) {
        if (logger.isDebugEnabled()) {
            logger.debug("WtcAbstractApplyBillService.getDutyShift,attFileBoId={},dutyDateQueryStartTime={},dutyDateQueryEndTime={}", new Object[]{attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime});
        }
        UnifyEntryDutyShiftService dutyShiftService = new UnifyEntryDutyShiftService(this);
        return (Map)dutyShiftService.getUnifyResult(attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime, this);
    }

    public void initShift() {
        this.matchShift();
    }

    protected void matchShift() {
        UnifyEntryShiftService shiftService = new UnifyEntryShiftService(this);
        shiftService.startMatch();
    }

    public Map<Date, DynamicObject> getAttFileVersion(long attFileBoId, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime) {
        if (logger.isDebugEnabled()) {
            logger.debug("WtcAbstractApplyBillService.getAttFileVersion,attFileBoId={},dutyDateQueryStartTime={},dutyDateQueryEndTime={}", new Object[]{attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime});
        }
        UnifyEntryAttFileVersionService attFileVersionService = new UnifyEntryAttFileVersionService(this);
        return (Map)attFileVersionService.getUnifyResult(attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime, this);
    }

    public void initAttFileVersion() {
        this.matchAttFileAllVersion();
    }

    protected void matchAttFileVersion() {
        UnifyEntryAttFileVersionService attFileVersionService = new UnifyEntryAttFileVersionService(this);
        attFileVersionService.startMatch();
    }

    public Map<Date, DynamicObject> getPlanDy(long attFileBoId, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime) {
        if (logger.isDebugEnabled()) {
            logger.debug("WtcAbstractApplyBillService.getPlanDy,attFileBoId={},dutyDateQueryStartTime={},dutyDateQueryEndTime={}", new Object[]{attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime});
        }
        UnifyEntryDutyPlanService planService = new UnifyEntryDutyPlanService(this);
        return (Map)planService.getUnifyResult(attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime, this);
    }

    public void initPlanInfo() {
        this.matchPlanInfo();
    }

    protected void matchPlanInfo() {
        UnifyEntryDutyPlanService planService = new UnifyEntryDutyPlanService(this);
        planService.startMatch();
    }

    public void initRuleInfo() {
        this.matchRuleInfo();
    }

    protected void matchRuleInfo() {
        UnifyEntryRuleService ruleService = new UnifyEntryRuleService(this);
        ruleService.startMatch();
    }

    public Map<Date, DynamicObject> getRuleDy(long attFileBoId, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime) {
        UnifyEntryRuleService ruleService = new UnifyEntryRuleService(this);
        return (Map)ruleService.getUnifyResult(attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime, this);
    }

    public void initRuleCalInfo() {
        this.matchRuleCalInfo();
    }

    protected void matchRuleCalInfo() {
        UnifyARCRuleCalService ruleCalService = new UnifyARCRuleCalService(this);
        ruleCalService.startMatch();
    }

    public Map<Date, DynamicObject> getRuleCalDy(long attFileBoId, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime, long needMatchTypeId) {
        if (logger.isDebugEnabled()) {
            logger.debug("WtcAbstractApplyBillService.getRuleCalDy,attFileBoId={},dutyDateQueryStartTime={},dutyDateQueryEndTime={},needMatchId={}", new Object[]{attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime, needMatchTypeId});
        }
        UnifyARCRuleCalService ruleCalService = new UnifyARCRuleCalService(this);
        return (Map)ruleCalService.getUnifyResult(attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime, needMatchTypeId, this);
    }

    public Map<Date, DynamicObject> getBaseSetDy(long attFileBoId, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime, long needMatchTypeId) {
        if (logger.isDebugEnabled()) {
            logger.debug("WtcAbstractApplyBillService.getBaseSetDy,attFileBoId={},dutyDateQueryStartTime={},dutyDateQueryEndTime={},needMatchId={}", new Object[]{attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime, needMatchTypeId});
        }
        UnifyARCBaseSetService baseSetService = new UnifyARCBaseSetService(this);
        return (Map)baseSetService.getUnifyResult(attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime, needMatchTypeId, this);
    }

    public void initBaseSetInfo() {
        this.matchBaseSetInfo();
    }

    protected void matchBaseSetInfo() {
        UnifyARCBaseSetService baseSetService = new UnifyARCBaseSetService(this);
        baseSetService.startMatch();
    }

    public Map<Date, DynamicObject> getChangeSetDy(long attFileBoId, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime, long needMatchTypeId) {
        if (logger.isDebugEnabled()) {
            logger.debug("WtcAbstractApplyBillService.getChangeSetDy,attFileBoId={},dutyDateQueryStartTime={},dutyDateQueryEndTime={}", new Object[]{attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime});
        }
        UnifyARCChangeSetService changeSetService = new UnifyARCChangeSetService(this);
        return (Map)changeSetService.getUnifyResult(attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime, needMatchTypeId, this);
    }

    public void initChangeSetInfo() {
        this.matchChangeSetInfo();
    }

    protected void matchChangeSetInfo() {
        UnifyARCChangeSetService changeSetService = new UnifyARCChangeSetService(this);
        changeSetService.startMatch();
    }

    public Map<Date, Tuple<Date, Date>> getBillFrozenInfo(long attFileBoId, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime) {
        if (logger.isDebugEnabled()) {
            logger.debug("WtcAbstractApplyBillService.getBillFrozenInfo,attFileBoId={},dutyDateQueryStartTime={},dutyDateQueryEndTime={}", new Object[]{attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime});
        }
        UnifyEntryFrozenService frozenService = new UnifyEntryFrozenService(this);
        return (Map)frozenService.getUnifyResult(attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime, this);
    }

    public void initFrozenInfo() {
        this.matchFrozenInfo();
    }

    protected void matchFrozenInfo() {
        UnifyEntryFrozenService frozenService = new UnifyEntryFrozenService(this);
        frozenService.startMatch();
    }

    public Map<Date, Boolean> verifyNotInSuspend(long attFileBoId, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime) {
        if (logger.isDebugEnabled()) {
            logger.debug("WtcAbstractApplyBillService.verifyNotInSuspend,attFileBoId={},dutyDateQueryStartTime={},dutyDateQueryEndTime={}", new Object[]{attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime});
        }
        UnifyEntrySuspendService suspendService = new UnifyEntrySuspendService(this);
        return (Map)suspendService.getUnifyResult(attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime, this);
    }

    public void initSuspendInfo() {
        this.matchSuspendInfo();
    }

    protected void matchSuspendInfo() {
        UnifyEntrySuspendService suspendService = new UnifyEntrySuspendService(this);
        suspendService.startMatch();
    }

    public Map<Date, UnifyBillAdvanceAfterInfo> getAdvanceAndAfterInfo(long attFileBoId, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime, long needMatchTypeId) {
        if (logger.isDebugEnabled()) {
            logger.debug("WtcAbstractApplyBillService.getAdvanceAndAfterInfo,attFileBoId={},dutyDateQueryStartTime={},dutyDateQueryEndTime={}", new Object[]{attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime});
        }
        UnifyARCAdvanceAndAfterService advanceAndAfterService = new UnifyARCAdvanceAndAfterService(this);
        return (Map)advanceAndAfterService.getUnifyResult(attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime, needMatchTypeId, this);
    }

    public void initAdvanceAndAfter() {
        this.matchAdvanceAndAfter();
    }

    protected void matchAdvanceAndAfter() {
        UnifyARCAdvanceAndAfterService advanceAndAfterService = new UnifyARCAdvanceAndAfterService(this);
        advanceAndAfterService.startMatch();
    }

    public Map<Date, Boolean> getDutyAuth(long attFileBoId, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime, long needMatchTypeId) {
        if (logger.isDebugEnabled()) {
            logger.debug("WtcAbstractApplyBillService.getDutyAuth,attFileBoId={},dutyDateQueryStartTime={},dutyDateQueryEndTime={}", new Object[]{attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime});
        }
        UnifyEntryDutyAuthService dutyAuthService = new UnifyEntryDutyAuthService(this);
        return (Map)dutyAuthService.getUnifyResult(attFileBoId, dutyDateQueryStartTime, dutyDateQueryEndTime, this);
    }

    public void initDutyAuth() {
        this.matchDutyAuth();
    }

    protected void matchDutyAuth() {
        UnifyEntryDutyAuthService dutyAuthService = new UnifyEntryDutyAuthService(this);
        dutyAuthService.startMatch();
    }

    public UnifyBillAttachmentInfo matchAttachmentInfo(List<BigDecimal> attachmentInfoCapacity, Long billPkId) {
        if (logger.isDebugEnabled()) {
            logger.debug("WtcAbstractApplyBillService.matchAttachmentInfo\uff0cattachmentInfoCapacity.size={}", (Object)attachmentInfoCapacity.size());
        }
        UnifyAttachmentFileService attachmentFileService = new UnifyAttachmentFileService(this);
        attachmentFileService.startMatch();
        return attachmentFileService.getResult(attachmentInfoCapacity, billPkId);
    }

    public Set<Long> getAppFileBoIds() {
        this.init();
        return UnifyBillCommonHelper.getContextAppFileBoIds(this.getInfoContext().getBillResult());
    }

    protected void matchAttFileHisAuth() {
        UnifyAttFileHisAuthService service = new UnifyAttFileHisAuthService(this);
        service.startMatch();
    }

    public List<DynamicObject> getAttFileHisAuth(long attFileBoId) {
        UnifyAttFileHisAuthService service = new UnifyAttFileHisAuthService(this);
        return (List)service.getUnifyResult(attFileBoId, this);
    }

    public long getPersonIdByAttFileBoId(long attFileBoId) {
        if (logger.isDebugEnabled()) {
            logger.debug("WtcAbstractApplyBillService.getAttFileHisAuth.attFileBoId:{}", (Object)attFileBoId);
        }
        this.matchAttFileAllVersion();
        List<DynamicObject> attFileAllVersion = this.getAttFileAllVersion(attFileBoId);
        if (WTCCollections.isEmpty(attFileAllVersion)) {
            return 0L;
        }
        return HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)attFileAllVersion.get(0), (String)"attperson");
    }
}

